/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.util.terminable.composite;

import io.fairyproject.util.terminable.Terminable;
import io.fairyproject.util.terminable.composite.CompositeClosingException;
import io.fairyproject.util.terminable.composite.CompositeTerminable;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Objects;
import java.util.concurrent.ConcurrentLinkedDeque;

public class AbstractWeakCompositeTerminable
implements CompositeTerminable {
    private final Deque<WeakReference<Terminable>> terminableQueue = new ConcurrentLinkedDeque<WeakReference<Terminable>>();

    protected AbstractWeakCompositeTerminable() {
    }

    @Override
    public CompositeTerminable with(Terminable terminable) {
        Objects.requireNonNull(terminable, "terminable");
        this.terminableQueue.push(new WeakReference<Terminable>(terminable));
        return this;
    }

    @Override
    public void close() throws CompositeClosingException {
        WeakReference<Terminable> ref;
        ArrayList<Exception> caught = new ArrayList<Exception>();
        while ((ref = this.terminableQueue.poll()) != null) {
            Terminable terminable = (Terminable)ref.get();
            if (terminable == null) continue;
            try {
                terminable.close();
            }
            catch (Exception e) {
                caught.add(e);
            }
        }
        if (!caught.isEmpty()) {
            throw new CompositeClosingException(caught);
        }
    }

    @Override
    public boolean isClosed() {
        return this.terminableQueue.stream().map(Reference::get).filter(Objects::nonNull).allMatch(Terminable::isClosed);
    }

    @Override
    public void cleanup() {
        this.terminableQueue.removeIf(ref -> {
            Terminable ac = (Terminable)ref.get();
            return ac == null || ac.isClosed();
        });
    }
}

