/*
 * Decompiled with CFR 0.152.
 */
package com.example.coinflipz;

import com.example.coinflipz.CoinFlipZListener;
import com.example.coinflipz.MessageManager;
import com.example.coinflipz.StatsManager;
import java.util.HashMap;
import java.util.Random;
import java.util.UUID;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;

public class CoinFlipZ
extends JavaPlugin {
    private static Economy econ = null;
    private MessageManager messageManager;
    private StatsManager statsManager;
    private CoinFlipZListener listener;
    private final HashMap<UUID, CoinFlipGame> pendingCoinFlips = new HashMap();
    private final HashMap<UUID, RouletteGame> activeRoulettes = new HashMap();
    private final Random random = new Random();

    public void onEnable() {
        this.saveDefaultConfig();
        this.messageManager = new MessageManager(this);
        this.statsManager = new StatsManager(this);
        if (!this.setupEconomy()) {
            this.getLogger().severe("Vault or compatible economy plugin not found! Plugin will be disabled.");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.listener = new CoinFlipZListener(this);
        this.getServer().getPluginManager().registerEvents((Listener)this.listener, (Plugin)this);
        this.getCommand("coinflipz").setExecutor((CommandExecutor)this);
        this.startCleanupTask();
        this.getLogger().info("CoinFlipZ has been enabled!");
        this.getLogger().info("MiniMessage support: ENABLED (Always)");
        this.getLogger().info("Adventure API support: " + (this.messageManager.hasNativeAdventureSupport() ? "NATIVE" : "COMPATIBILITY"));
        this.getLogger().info("Stats system loaded successfully!");
    }

    public void onDisable() {
        for (CoinFlipGame game : this.pendingCoinFlips.values()) {
            Player player = Bukkit.getPlayer((UUID)game.getCreator());
            if (player == null) continue;
            econ.depositPlayer((OfflinePlayer)player, game.getBetAmount());
            this.messageManager.sendMessageNoPrefix(player, "coinflip.game-cancelled-shutdown");
        }
        this.pendingCoinFlips.clear();
        this.activeRoulettes.clear();
        this.getLogger().info("CoinFlipZ has been disabled!");
    }

    private boolean setupEconomy() {
        if (this.getServer().getPluginManager().getPlugin("Vault") == null) {
            return false;
        }
        RegisteredServiceProvider rsp = this.getServer().getServicesManager().getRegistration(Economy.class);
        if (rsp == null) {
            return false;
        }
        econ = (Economy)rsp.getProvider();
        return econ != null;
    }

    public static Economy getEconomy() {
        return econ;
    }

    public MessageManager getMessageManager() {
        return this.messageManager;
    }

    public StatsManager getStatsManager() {
        return this.statsManager;
    }

    public CoinFlipZListener getListener() {
        return this.listener;
    }

    private void startCleanupTask() {
        Bukkit.getScheduler().runTaskTimer((Plugin)this, () -> {
            if (this.listener != null) {
                this.listener.cleanupExpiredGames();
                long timeout = 300000L;
                this.listener.getBetInputStates().entrySet().removeIf(entry -> ((CoinFlipZListener.BetInputState)entry.getValue()).isExpired(timeout));
            }
        }, 600L, 600L);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.messageManager.getMessage("player-only"));
            return true;
        }
        Player player = (Player)sender;
        if (args.length == 0) {
            this.openMainMenu(player);
            return true;
        }
        switch (args[0].toLowerCase()) {
            case "coinflip": {
                if (args.length < 2) {
                    this.messageManager.sendMessage(player, "coinflip.min-bet-error", "min_bet", this.messageManager.formatCurrency(this.getConfig().getDouble("coinflip.min-bet", 10.0)));
                    return true;
                }
                try {
                    double amount = Double.parseDouble(args[1]);
                    this.createCoinFlipGame(player, amount);
                }
                catch (NumberFormatException e) {
                    this.messageManager.sendMessage(player, "invalid-number");
                }
                return true;
            }
            case "join": {
                if (args.length < 2) {
                    this.messageManager.sendMessage(player, "coinflip.no-active-games");
                    return true;
                }
                if (this.listener != null) {
                    this.listener.handleJoinCommand(player, args[1]);
                }
                return true;
            }
            case "roulette": {
                this.openRouletteMenu(player);
                return true;
            }
            case "stats": {
                this.showPlayerStats(player);
                return true;
            }
            case "help": {
                this.showHelp(player);
                return true;
            }
            case "admin": {
                if (!player.hasPermission("coinflipz.admin")) {
                    this.messageManager.sendMessage(player, "no-permission");
                    return true;
                }
                if (args.length > 1) {
                    String action = args[1];
                    String target = args.length > 2 ? args[2] : null;
                    this.listener.handleAdminAction(player, action, target);
                } else {
                    this.openAdminPanel(player);
                }
                return true;
            }
            case "reload": {
                if (!player.hasPermission("coinflipz.admin")) {
                    this.messageManager.sendMessage(player, "no-permission");
                    return true;
                }
                this.reloadConfig();
                this.messageManager.reloadMessages();
                this.statsManager.loadStats();
                this.messageManager.sendMessage(player, "admin.config-reloaded");
                return true;
            }
        }
        this.messageManager.sendMessage(player, "unknown-command");
        return true;
    }

    private void openMainMenu(Player player) {
        String title = this.messageManager.getMessage("gui.main-menu-title");
        Inventory menu = Bukkit.createInventory(null, (int)27, (String)title);
        ItemStack filler = new ItemStack(Material.GRAY_STAINED_GLASS_PANE);
        ItemMeta fillerMeta = filler.getItemMeta();
        fillerMeta.setDisplayName(" ");
        filler.setItemMeta(fillerMeta);
        for (int i = 0; i < 27; ++i) {
            menu.setItem(i, filler);
        }
        ItemStack coinflipItem = new ItemStack(Material.GOLD_INGOT);
        ItemMeta coinflipMeta = coinflipItem.getItemMeta();
        coinflipMeta.setDisplayName(this.messageManager.getMessage("gui.coinflip-item-name"));
        coinflipMeta.setLore(this.messageManager.getMessageList("gui.coinflip-item-lore"));
        coinflipItem.setItemMeta(coinflipMeta);
        menu.setItem(11, coinflipItem);
        ItemStack rouletteItem = new ItemStack(Material.EMERALD);
        ItemMeta rouletteMeta = rouletteItem.getItemMeta();
        rouletteMeta.setDisplayName(this.messageManager.getMessage("gui.roulette-item-name"));
        rouletteMeta.setLore(this.messageManager.getMessageList("gui.roulette-item-lore"));
        rouletteItem.setItemMeta(rouletteMeta);
        menu.setItem(15, rouletteItem);
        ItemStack statsItem = new ItemStack(Material.BOOK);
        ItemMeta statsMeta = statsItem.getItemMeta();
        statsMeta.setDisplayName(this.messageManager.getMessage("gui.stats-item-name"));
        statsMeta.setLore(this.messageManager.getMessageList("gui.stats-item-lore"));
        statsItem.setItemMeta(statsMeta);
        menu.setItem(13, statsItem);
        player.openInventory(menu);
    }

    private void createCoinFlipGame(Player player, double amount) {
        double minBet = this.getConfig().getDouble("coinflip.min-bet", 10.0);
        if (amount < minBet) {
            this.messageManager.sendMessage(player, "coinflip.min-bet-error", "min_bet", this.messageManager.formatCurrency(minBet));
            return;
        }
        double maxBet = this.getConfig().getDouble("coinflip.max-bet", 10000.0);
        if (amount > maxBet) {
            this.messageManager.sendMessage(player, "coinflip.max-bet-error", "max_bet", this.messageManager.formatCurrency(maxBet));
            return;
        }
        if (!econ.has((OfflinePlayer)player, amount)) {
            this.messageManager.sendMessage(player, "not-enough-money");
            return;
        }
        econ.withdrawPlayer((OfflinePlayer)player, amount);
        CoinFlipGame game = new CoinFlipGame(this, player.getUniqueId(), amount);
        this.pendingCoinFlips.put(player.getUniqueId(), game);
        if (this.getConfig().getBoolean("coinflip.broadcast-new-games", true)) {
            String broadcast = this.messageManager.getMessage("coinflip.game-created-broadcast", "player", player.getName(), "amount", this.messageManager.formatCurrency(amount));
            for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
                onlinePlayer.sendMessage(broadcast);
            }
        }
        this.messageManager.sendMessage(player, "coinflip.waiting-opponent");
    }

    private void openRouletteMenu(Player player) {
        if (this.listener != null) {
            this.listener.openRouletteMenu(player);
        }
    }

    private void showPlayerStats(Player player) {
        if (this.listener != null) {
            this.listener.showPlayerStats(player);
        }
    }

    private void showHelp(Player player) {
        this.messageManager.sendMessageNoPrefix(player, "help.header");
        this.messageManager.sendMessageNoPrefix(player, "help.main-menu");
        this.messageManager.sendMessageNoPrefix(player, "help.coinflip");
        this.messageManager.sendMessageNoPrefix(player, "help.join");
        this.messageManager.sendMessageNoPrefix(player, "help.roulette");
        this.messageManager.sendMessageNoPrefix(player, "help.stats");
        if (player.hasPermission("coinflipz.admin")) {
            this.messageManager.sendMessageNoPrefix(player, "help.admin");
            this.messageManager.sendMessageNoPrefix(player, "help.reload");
        }
    }

    private void openAdminPanel(Player player) {
        String title = this.messageManager.getMessage("gui.admin-panel-title");
        Inventory menu = Bukkit.createInventory(null, (int)27, (String)title);
        ItemStack filler = new ItemStack(Material.GRAY_STAINED_GLASS_PANE);
        ItemMeta fillerMeta = filler.getItemMeta();
        fillerMeta.setDisplayName(" ");
        filler.setItemMeta(fillerMeta);
        for (int i = 0; i < 27; ++i) {
            menu.setItem(i, filler);
        }
        ItemStack statsItem = new ItemStack(Material.BOOK);
        ItemMeta statsMeta = statsItem.getItemMeta();
        statsMeta.setDisplayName(this.messageManager.getMessage("gui.admin-stats-name"));
        statsMeta.setLore(this.messageManager.getMessageList("gui.admin-stats-lore"));
        statsItem.setItemMeta(statsMeta);
        menu.setItem(11, statsItem);
        ItemStack leaderboardItem = new ItemStack(Material.PLAYER_HEAD);
        ItemMeta leaderboardMeta = leaderboardItem.getItemMeta();
        leaderboardMeta.setDisplayName(this.messageManager.getMessage("gui.leaderboard-name"));
        leaderboardMeta.setLore(this.messageManager.getMessageList("gui.leaderboard-lore"));
        leaderboardItem.setItemMeta(leaderboardMeta);
        menu.setItem(15, leaderboardItem);
        player.openInventory(menu);
    }

    public HashMap<UUID, CoinFlipGame> getPendingCoinFlips() {
        return this.pendingCoinFlips;
    }

    public HashMap<UUID, RouletteGame> getActiveRoulettes() {
        return this.activeRoulettes;
    }

    public class CoinFlipGame {
        private final UUID creator;
        private final double betAmount;
        private UUID opponent;

        public CoinFlipGame(CoinFlipZ this$0, UUID creator, double betAmount) {
            this.creator = creator;
            this.betAmount = betAmount;
        }

        public UUID getCreator() {
            return this.creator;
        }

        public double getBetAmount() {
            return this.betAmount;
        }

        public UUID getOpponent() {
            return this.opponent;
        }

        public void setOpponent(UUID opponent) {
            this.opponent = opponent;
        }
    }

    public class RouletteBet {
        private final String betType;
        private final int number;
        private final double amount;

        public RouletteBet(CoinFlipZ this$0, String betType, int number, double amount) {
            this.betType = betType;
            this.number = number;
            this.amount = amount;
        }

        public String getBetType() {
            return this.betType;
        }

        public int getNumber() {
            return this.number;
        }

        public double getAmount() {
            return this.amount;
        }
    }

    public class RouletteGame {
        private final UUID creator;
        private final HashMap<UUID, RouletteBet> bets;
        private boolean isSpinning;

        public RouletteGame(CoinFlipZ this$0, UUID creator) {
            this.creator = creator;
            this.bets = new HashMap();
            this.isSpinning = false;
        }

        public UUID getCreator() {
            return this.creator;
        }

        public HashMap<UUID, RouletteBet> getBets() {
            return this.bets;
        }

        public boolean isSpinning() {
            return this.isSpinning;
        }

        public void setSpinning(boolean spinning) {
            this.isSpinning = spinning;
        }

        public void addBet(UUID player, RouletteBet bet) {
            this.bets.put(player, bet);
        }
    }
}

