/*
 * Decompiled with CFR 0.152.
 */
package com.example.coinflipz;

import com.example.coinflipz.CoinFlipZ;
import com.example.coinflipz.MessageManager;
import com.example.coinflipz.StatsManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class CoinFlipZListener
implements Listener {
    private final CoinFlipZ plugin;
    private final MessageManager messageManager;
    private final Random random = new Random();
    private final HashMap<UUID, BetInputState> betInputStates = new HashMap();
    private final Set<UUID> playersInActiveGame = new HashSet<UUID>();

    public CoinFlipZListener(CoinFlipZ plugin) {
        this.plugin = plugin;
        this.messageManager = plugin.getMessageManager();
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        String title = event.getView().getTitle();
        String strippedTitle = this.messageManager.stripColors(title);
        if (strippedTitle.contains(this.messageManager.stripColors(this.messageManager.getMessage("gui.main-menu-title"))) || strippedTitle.contains(this.messageManager.stripColors(this.messageManager.getMessage("gui.roulette-menu-title"))) || strippedTitle.contains(this.messageManager.stripColors(this.messageManager.getMessage("gui.admin-panel-title"))) || strippedTitle.contains(this.messageManager.stripColors(this.messageManager.getMessage("gui.coinflip-menu-title"))) || strippedTitle.contains(this.messageManager.stripColors(this.messageManager.getMessage("gui.leaderboard-title")))) {
            event.setCancelled(true);
            if (event.getCurrentItem() == null || event.getCurrentItem().getType() == Material.AIR) {
                return;
            }
            Player player = (Player)event.getWhoClicked();
            if (strippedTitle.equals(this.messageManager.stripColors(this.messageManager.getMessage("gui.main-menu-title")))) {
                this.handleMainMenuClick(player, event.getCurrentItem().getType(), event.getSlot());
            } else if (strippedTitle.equals(this.messageManager.stripColors(this.messageManager.getMessage("gui.roulette-menu-title")))) {
                this.handleRouletteClick(player, event.getCurrentItem(), event.getSlot());
            } else if (strippedTitle.equals(this.messageManager.stripColors(this.messageManager.getMessage("gui.admin-panel-title")))) {
                this.handleAdminPanelClick(player, event.getCurrentItem().getType(), event.getSlot());
            } else if (strippedTitle.equals(this.messageManager.stripColors(this.messageManager.getMessage("gui.coinflip-menu-title")))) {
                this.handleCoinFlipGameSelectionClick(player, event.getCurrentItem(), event.getSlot());
            } else if (strippedTitle.equals(this.messageManager.stripColors(this.messageManager.getMessage("gui.leaderboard-title")))) {
                // empty if block
            }
        }
    }

    @EventHandler
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        Player player = event.getPlayer();
        if (this.betInputStates.containsKey(player.getUniqueId())) {
            event.setCancelled(true);
            String input = event.getMessage();
            if (input.equalsIgnoreCase("cancel") || input.equalsIgnoreCase("exit")) {
                this.betInputStates.remove(player.getUniqueId());
                this.messageManager.sendMessage(player, "roulette.bet-cancelled");
                return;
            }
            try {
                double amount = Double.parseDouble(input);
                BetInputState state = this.betInputStates.get(player.getUniqueId());
                if (state.getBetType().equals("coinflip")) {
                    this.processCoinFlipBetInput(player, amount);
                } else {
                    this.processRouletteBetInput(player, state.getBetType(), state.getNumber(), amount);
                }
                this.betInputStates.remove(player.getUniqueId());
            }
            catch (NumberFormatException e) {
                this.messageManager.sendMessage(player, "invalid-number");
            }
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        UUID playerId = player.getUniqueId();
        if (this.plugin.getPendingCoinFlips().containsKey(playerId) && !this.playersInActiveGame.contains(playerId)) {
            CoinFlipZ.CoinFlipGame game = this.plugin.getPendingCoinFlips().get(playerId);
            if (game.getOpponent() == null) {
                CoinFlipZ.getEconomy().depositPlayer((OfflinePlayer)player, game.getBetAmount());
                this.plugin.getPendingCoinFlips().remove(playerId);
                String broadcast = this.messageManager.getMessage("coinflip.game-cancelled-quit", "player", player.getName());
                Bukkit.broadcastMessage((String)broadcast);
            } else {
                this.plugin.getPendingCoinFlips().remove(playerId);
            }
        }
        this.playersInActiveGame.remove(playerId);
        this.betInputStates.remove(playerId);
        this.plugin.getActiveRoulettes().remove(playerId);
    }

    private void handleMainMenuClick(Player player, Material material, int slot) {
        switch (slot) {
            case 11: {
                this.openCoinFlipGamesMenu(player);
                break;
            }
            case 13: {
                this.showPlayerStats(player);
                break;
            }
            case 15: {
                this.openRouletteMenu(player);
            }
        }
    }

    private void openCoinFlipGamesMenu(Player player) {
        player.closeInventory();
        int inventorySize = 54;
        String title = this.messageManager.getMessage("gui.coinflip-menu-title");
        Inventory menu = Bukkit.createInventory(null, (int)inventorySize, (String)title);
        ItemStack filler = new ItemStack(Material.GRAY_STAINED_GLASS_PANE);
        ItemMeta fillerMeta = filler.getItemMeta();
        fillerMeta.setDisplayName(" ");
        filler.setItemMeta(fillerMeta);
        for (int i = 0; i < inventorySize; ++i) {
            menu.setItem(i, filler);
        }
        ItemStack createButton = new ItemStack(Material.EMERALD_BLOCK);
        ItemMeta createMeta = createButton.getItemMeta();
        createMeta.setDisplayName(this.messageManager.getMessage("gui.coinflip-create-button"));
        ArrayList<String> createLore = new ArrayList<String>();
        createLore.add(this.messageManager.getMessage("gui.coinflip-create-lore"));
        createMeta.setLore(createLore);
        createButton.setItemMeta(createMeta);
        menu.setItem(49, createButton);
        if (this.plugin.getPendingCoinFlips().isEmpty()) {
            ItemStack noGames = new ItemStack(Material.BARRIER);
            ItemMeta noGamesMeta = noGames.getItemMeta();
            noGamesMeta.setDisplayName(this.messageManager.getMessage("gui.coinflip-no-games"));
            ArrayList<String> noGamesLore = new ArrayList<String>();
            noGamesLore.add(this.messageManager.getMessage("gui.coinflip-no-games-lore"));
            noGamesMeta.setLore(noGamesLore);
            noGames.setItemMeta(noGamesMeta);
            menu.setItem(22, noGames);
        } else {
            int[] gameSlots = new int[]{10, 11, 12, 13, 14, 15, 16, 19, 20, 21, 22, 23, 24, 25, 28, 29, 30, 31, 32, 33, 34, 37, 38, 39, 40, 41, 42, 43};
            int slotIndex = 0;
            for (Map.Entry<UUID, CoinFlipZ.CoinFlipGame> entry : this.plugin.getPendingCoinFlips().entrySet()) {
                if (slotIndex >= gameSlots.length) break;
                UUID creatorId = entry.getKey();
                CoinFlipZ.CoinFlipGame game = entry.getValue();
                Player creator = Bukkit.getPlayer((UUID)creatorId);
                if (creator == null) continue;
                ItemStack gameItem = creatorId.equals(player.getUniqueId()) ? new ItemStack(Material.PLAYER_HEAD) : new ItemStack(Material.GOLD_INGOT);
                ItemMeta gameMeta = gameItem.getItemMeta();
                String displayName = this.messageManager.getMessage("gui.coinflip-game-title", "player", creator.getName());
                gameMeta.setDisplayName(displayName);
                ArrayList<String> lore = new ArrayList<String>();
                lore.add(this.messageManager.getMessage("gui.coinflip-game-amount", "amount", this.messageManager.formatCurrency(game.getBetAmount())));
                if (creatorId.equals(player.getUniqueId())) {
                    lore.add(this.messageManager.getMessage("gui.coinflip-your-game"));
                } else {
                    lore.add(this.messageManager.getMessage("gui.coinflip-click-join"));
                }
                gameMeta.setLore(lore);
                gameItem.setItemMeta(gameMeta);
                menu.setItem(gameSlots[slotIndex], gameItem);
                ++slotIndex;
            }
        }
        player.openInventory(menu);
    }

    private void handleCoinFlipGameSelectionClick(Player player, ItemStack clickedItem, int slot) {
        if (clickedItem.getType() == Material.GRAY_STAINED_GLASS_PANE || clickedItem.getType() == Material.BARRIER) {
            return;
        }
        if (slot == 49 && clickedItem.getType() == Material.EMERALD_BLOCK) {
            player.closeInventory();
            this.betInputStates.put(player.getUniqueId(), new BetInputState("coinflip", 0));
            this.messageManager.sendMessage(player, "roulette.bet-amount-prompt");
            this.messageManager.sendMessageNoPrefix(player, "coinflip.enter-amount-hint");
            return;
        }
        if (clickedItem.getType() == Material.GOLD_INGOT || clickedItem.getType() == Material.PLAYER_HEAD) {
            String displayName = this.messageManager.stripColors(clickedItem.getItemMeta().getDisplayName());
            String menuTitle = this.messageManager.stripColors(this.messageManager.getMessage("gui.coinflip-game-title", "player", ""));
            for (Map.Entry<UUID, CoinFlipZ.CoinFlipGame> entry : this.plugin.getPendingCoinFlips().entrySet()) {
                Player creator = Bukkit.getPlayer((UUID)entry.getKey());
                if (creator == null) continue;
                String creatorGameTitle = this.messageManager.stripColors(this.messageManager.getMessage("gui.coinflip-game-title", "player", creator.getName()));
                if (!displayName.contains(creator.getName()) && !displayName.equals(creatorGameTitle)) continue;
                this.handleJoinCommand(player, creator.getName());
                player.closeInventory();
                return;
            }
        }
    }

    public void handleJoinCommand(Player challenger, String creatorName) {
        UUID challengerId;
        Player creator = Bukkit.getPlayer((String)creatorName);
        if (creator == null || !creator.isOnline()) {
            this.messageManager.sendMessage(challenger, "player-not-found");
            return;
        }
        UUID creatorId = creator.getUniqueId();
        if (creatorId.equals(challengerId = challenger.getUniqueId())) {
            this.messageManager.sendMessage(challenger, "coinflip.cannot-join-own");
            return;
        }
        CoinFlipZ.CoinFlipGame game = this.plugin.getPendingCoinFlips().get(creatorId);
        if (game == null) {
            this.messageManager.sendMessage(challenger, "coinflip.game-not-exists");
            return;
        }
        if (!CoinFlipZ.getEconomy().has((OfflinePlayer)challenger, game.getBetAmount())) {
            this.messageManager.sendMessage(challenger, "coinflip.insufficient-funds-join");
            return;
        }
        this.playersInActiveGame.add(creatorId);
        this.playersInActiveGame.add(challengerId);
        CoinFlipZ.getEconomy().withdrawPlayer((OfflinePlayer)challenger, game.getBetAmount());
        game.setOpponent(challengerId);
        this.messageManager.sendMessage(challenger, "coinflip.game-joined", "creator", creator.getName());
        this.messageManager.sendMessage(creator, "coinflip.opponent-joined", "challenger", challenger.getName());
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            this.executeCoinFlip(creator, challenger, game.getBetAmount());
            this.plugin.getPendingCoinFlips().remove(creatorId);
            this.playersInActiveGame.remove(creatorId);
            this.playersInActiveGame.remove(challengerId);
        }, 40L);
        this.messageManager.sendMessage(creator, "coinflip.flipping-coin");
        this.messageManager.sendMessage(challenger, "coinflip.flipping-coin");
    }

    private void executeCoinFlip(Player creator, Player challenger, double betAmount) {
        boolean creatorWins = this.random.nextBoolean();
        Player winner = creatorWins ? creator : challenger;
        Player loser = creatorWins ? challenger : creator;
        double totalPot = betAmount * 2.0;
        double houseEdge = this.plugin.getConfig().getDouble("house-edge-percentage", 5.0) / 100.0;
        double houseTake = totalPot * houseEdge;
        double prize = totalPot - houseTake;
        CoinFlipZ.getEconomy().depositPlayer((OfflinePlayer)winner, prize);
        this.messageManager.sendMessage(winner, "coinflip.game-won", "winnings", this.messageManager.formatCurrency(prize));
        this.messageManager.sendMessage(loser, "coinflip.game-lost");
        String broadcast = this.messageManager.getMessage("coinflip.game-won-broadcast", "winner", winner.getName(), "loser", loser.getName(), "prize", this.messageManager.formatCurrency(prize));
        Bukkit.broadcastMessage((String)broadcast);
        this.plugin.getStatsManager().recordCoinFlip(winner.getUniqueId(), loser.getUniqueId(), betAmount, prize);
    }

    private void processCoinFlipBetInput(Player player, double amount) {
        double minBet = this.plugin.getConfig().getDouble("coinflip.min-bet", 10.0);
        double maxBet = this.plugin.getConfig().getDouble("coinflip.max-bet", 10000.0);
        if (amount < minBet) {
            this.messageManager.sendMessage(player, "coinflip.min-bet-error", "min_bet", this.messageManager.formatCurrency(minBet));
            this.betInputStates.put(player.getUniqueId(), new BetInputState("coinflip", 0));
            return;
        }
        if (amount > maxBet) {
            this.messageManager.sendMessage(player, "coinflip.max-bet-error", "max_bet", this.messageManager.formatCurrency(maxBet));
            this.betInputStates.put(player.getUniqueId(), new BetInputState("coinflip", 0));
            return;
        }
        if (!CoinFlipZ.getEconomy().has((OfflinePlayer)player, amount)) {
            this.messageManager.sendMessage(player, "not-enough-money");
            this.betInputStates.put(player.getUniqueId(), new BetInputState("coinflip", 0));
            return;
        }
        CoinFlipZ.getEconomy().withdrawPlayer((OfflinePlayer)player, amount);
        CoinFlipZ coinFlipZ = this.plugin;
        Objects.requireNonNull(coinFlipZ);
        CoinFlipZ.CoinFlipGame game = new CoinFlipZ.CoinFlipGame(coinFlipZ, player.getUniqueId(), amount);
        this.plugin.getPendingCoinFlips().put(player.getUniqueId(), game);
        if (this.plugin.getConfig().getBoolean("coinflip.broadcast-new-games", true)) {
            String broadcast = this.messageManager.getMessage("coinflip.game-created-broadcast", "player", player.getName(), "amount", this.messageManager.formatCurrency(amount));
            for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
                onlinePlayer.sendMessage(broadcast);
            }
        }
        this.messageManager.sendMessage(player, "coinflip.waiting-opponent");
        this.openCoinFlipGamesMenu(player);
    }

    public void openRouletteMenu(Player player) {
        player.closeInventory();
        String title = this.messageManager.getMessage("gui.roulette-menu-title");
        Inventory menu = Bukkit.createInventory(null, (int)54, (String)title);
        ItemStack filler = new ItemStack(Material.GRAY_STAINED_GLASS_PANE);
        ItemMeta fillerMeta = filler.getItemMeta();
        fillerMeta.setDisplayName(" ");
        filler.setItemMeta(fillerMeta);
        for (int i = 0; i < 54; ++i) {
            menu.setItem(i, filler);
        }
        int[] numberSlots = new int[]{10, 11, 12, 13, 14, 15, 16, 19, 20, 21, 22, 23, 24, 25, 28, 29, 30, 31, 32, 33, 34};
        for (int i = 0; i <= 20 && i < numberSlots.length; ++i) {
            ItemStack numberItem = new ItemStack(Material.PAPER);
            ItemMeta numberMeta = numberItem.getItemMeta();
            numberMeta.setDisplayName(this.messageManager.getRouletteNumberColor(i) + i);
            numberItem.setItemMeta(numberMeta);
            menu.setItem(numberSlots[i], numberItem);
        }
        ItemStack redBet = new ItemStack(Material.RED_WOOL);
        ItemMeta redMeta = redBet.getItemMeta();
        redMeta.setDisplayName(this.messageManager.getMessage("gui.roulette-bet-red"));
        redBet.setItemMeta(redMeta);
        menu.setItem(38, redBet);
        ItemStack blackBet = new ItemStack(Material.BLACK_WOOL);
        ItemMeta blackMeta = blackBet.getItemMeta();
        blackMeta.setDisplayName(this.messageManager.getMessage("gui.roulette-bet-black"));
        blackBet.setItemMeta(blackMeta);
        menu.setItem(39, blackBet);
        ItemStack evenBet = new ItemStack(Material.WHITE_WOOL);
        ItemMeta evenMeta = evenBet.getItemMeta();
        evenMeta.setDisplayName(this.messageManager.getMessage("gui.roulette-bet-even"));
        evenBet.setItemMeta(evenMeta);
        menu.setItem(40, evenBet);
        ItemStack oddBet = new ItemStack(Material.LIGHT_GRAY_WOOL);
        ItemMeta oddMeta = oddBet.getItemMeta();
        oddMeta.setDisplayName(this.messageManager.getMessage("gui.roulette-bet-odd"));
        oddBet.setItemMeta(oddMeta);
        menu.setItem(41, oddBet);
        ItemStack spinButton = new ItemStack(Material.EMERALD_BLOCK);
        ItemMeta spinMeta = spinButton.getItemMeta();
        spinMeta.setDisplayName(this.messageManager.getMessage("gui.roulette-spin-button"));
        spinButton.setItemMeta(spinMeta);
        menu.setItem(49, spinButton);
        player.openInventory(menu);
    }

    private void handleRouletteClick(Player player, ItemStack clickedItem, int slot) {
        if (clickedItem.getType() == Material.GRAY_STAINED_GLASS_PANE) {
            return;
        }
        if (slot == 49 && clickedItem.getType() == Material.EMERALD_BLOCK) {
            player.closeInventory();
            this.spinRoulette(player);
            return;
        }
        player.closeInventory();
        if (clickedItem.getType() == Material.PAPER) {
            String displayName = clickedItem.getItemMeta().getDisplayName();
            String stripped = this.messageManager.stripColors(displayName);
            try {
                int number = Integer.parseInt(stripped.trim());
                this.betInputStates.put(player.getUniqueId(), new BetInputState("number", number));
                this.messageManager.sendMessage(player, "roulette.betting-on", "description", this.messageManager.getBetDescription("number", number));
                this.messageManager.sendMessageNoPrefix(player, "coinflip.enter-amount-hint");
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (clickedItem.getType() == Material.RED_WOOL) {
            this.betInputStates.put(player.getUniqueId(), new BetInputState("red", 0));
            this.messageManager.sendMessage(player, "roulette.betting-on", "description", this.messageManager.getBetDescription("red", 0));
            this.messageManager.sendMessageNoPrefix(player, "coinflip.enter-amount-hint");
        } else if (clickedItem.getType() == Material.BLACK_WOOL) {
            this.betInputStates.put(player.getUniqueId(), new BetInputState("black", 0));
            this.messageManager.sendMessage(player, "roulette.betting-on", "description", this.messageManager.getBetDescription("black", 0));
            this.messageManager.sendMessageNoPrefix(player, "coinflip.enter-amount-hint");
        } else if (clickedItem.getType() == Material.WHITE_WOOL) {
            this.betInputStates.put(player.getUniqueId(), new BetInputState("even", 0));
            this.messageManager.sendMessage(player, "roulette.betting-on", "description", this.messageManager.getBetDescription("even", 0));
            this.messageManager.sendMessageNoPrefix(player, "coinflip.enter-amount-hint");
        } else if (clickedItem.getType() == Material.LIGHT_GRAY_WOOL) {
            this.betInputStates.put(player.getUniqueId(), new BetInputState("odd", 0));
            this.messageManager.sendMessage(player, "roulette.betting-on", "description", this.messageManager.getBetDescription("odd", 0));
            this.messageManager.sendMessageNoPrefix(player, "coinflip.enter-amount-hint");
        }
    }

    private void processRouletteBetInput(Player player, String betType, int number, double amount) {
        double minBet = this.plugin.getConfig().getDouble("roulette.min-bet", 5.0);
        double maxBet = this.plugin.getConfig().getDouble("roulette.max-bet", 5000.0);
        if (amount < minBet) {
            this.messageManager.sendMessage(player, "roulette.min-bet-error", "min_bet", this.messageManager.formatCurrency(minBet));
            this.betInputStates.put(player.getUniqueId(), new BetInputState(betType, number));
            return;
        }
        if (amount > maxBet) {
            this.messageManager.sendMessage(player, "roulette.max-bet-error", "max_bet", this.messageManager.formatCurrency(maxBet));
            this.betInputStates.put(player.getUniqueId(), new BetInputState(betType, number));
            return;
        }
        if (!CoinFlipZ.getEconomy().has((OfflinePlayer)player, amount)) {
            this.messageManager.sendMessage(player, "not-enough-money");
            this.betInputStates.put(player.getUniqueId(), new BetInputState(betType, number));
            return;
        }
        CoinFlipZ.getEconomy().withdrawPlayer((OfflinePlayer)player, amount);
        CoinFlipZ.RouletteGame game = this.plugin.getActiveRoulettes().get(player.getUniqueId());
        if (game == null) {
            CoinFlipZ coinFlipZ = this.plugin;
            Objects.requireNonNull(coinFlipZ);
            game = new CoinFlipZ.RouletteGame(coinFlipZ, player.getUniqueId());
            this.plugin.getActiveRoulettes().put(player.getUniqueId(), game);
        }
        CoinFlipZ coinFlipZ = this.plugin;
        Objects.requireNonNull(coinFlipZ);
        CoinFlipZ.RouletteBet bet = new CoinFlipZ.RouletteBet(coinFlipZ, betType, number, amount);
        game.addBet(player.getUniqueId(), bet);
        String betDesc = this.messageManager.getBetDescription(betType, number);
        this.messageManager.sendMessage(player, "roulette.bet-placed", "amount", this.messageManager.formatCurrency(amount), "bet_description", betDesc);
        this.openRouletteMenu(player);
    }

    private void spinRoulette(Player player) {
        CoinFlipZ.RouletteGame game = this.plugin.getActiveRoulettes().get(player.getUniqueId());
        if (game == null || game.getBets().isEmpty()) {
            this.messageManager.sendMessage(player, "roulette.no-bets-placed");
            this.openRouletteMenu(player);
            return;
        }
        if (game.isSpinning()) {
            this.messageManager.sendMessage(player, "roulette.wheel-spinning");
            return;
        }
        game.setSpinning(true);
        this.messageManager.sendMessage(player, "roulette.spinning-message");
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            int result = this.random.nextInt(37);
            String resultColor = this.messageManager.getRouletteNumberColor(result);
            this.messageManager.sendMessage(player, "roulette.wheel-result", "color", resultColor, "number", String.valueOf(result));
            for (Map.Entry<UUID, CoinFlipZ.RouletteBet> entry : game.getBets().entrySet()) {
                CoinFlipZ.RouletteBet bet = entry.getValue();
                boolean won = this.checkRouletteBet(bet, result);
                if (won) {
                    double payout = this.calculateRoulettePayout(bet.getBetType());
                    double winnings = bet.getAmount() * payout;
                    CoinFlipZ.getEconomy().depositPlayer((OfflinePlayer)player, winnings);
                    this.messageManager.sendMessage(player, "roulette.bet-won", "winnings", this.messageManager.formatCurrency(winnings));
                    this.plugin.getStatsManager().recordRoulette(player.getUniqueId(), bet.getAmount(), winnings, true);
                    continue;
                }
                this.messageManager.sendMessage(player, "roulette.bet-lost");
                this.plugin.getStatsManager().recordRoulette(player.getUniqueId(), bet.getAmount(), 0.0, false);
            }
            this.plugin.getActiveRoulettes().remove(player.getUniqueId());
        }, 60L);
    }

    private boolean checkRouletteBet(CoinFlipZ.RouletteBet bet, int result) {
        switch (bet.getBetType().toLowerCase()) {
            case "number": {
                return bet.getNumber() == result;
            }
            case "red": {
                return result != 0 && result % 2 == 0;
            }
            case "black": {
                return result != 0 && result % 2 != 0;
            }
            case "even": {
                return result != 0 && result % 2 == 0;
            }
            case "odd": {
                return result != 0 && result % 2 != 0;
            }
            case "dozen-1": {
                return result >= 1 && result <= 12;
            }
            case "dozen-2": {
                return result >= 13 && result <= 24;
            }
            case "dozen-3": {
                return result >= 25 && result <= 36;
            }
            case "low": {
                return result >= 1 && result <= 18;
            }
            case "high": {
                return result >= 19 && result <= 36;
            }
        }
        return false;
    }

    private double calculateRoulettePayout(String betType) {
        switch (betType.toLowerCase()) {
            case "number": {
                return this.plugin.getConfig().getDouble("roulette.payouts.number", 36.0);
            }
            case "red": 
            case "black": {
                return this.plugin.getConfig().getDouble("roulette.payouts.color", 2.0);
            }
            case "even": 
            case "odd": {
                return this.plugin.getConfig().getDouble("roulette.payouts.even-odd", 2.0);
            }
            case "dozen-1": 
            case "dozen-2": 
            case "dozen-3": {
                return this.plugin.getConfig().getDouble("roulette.payouts.dozen", 3.0);
            }
            case "low": 
            case "high": {
                return this.plugin.getConfig().getDouble("roulette.payouts.low-high", 2.0);
            }
        }
        return 2.0;
    }

    public void showPlayerStats(Player player) {
        StatsManager.PlayerStats stats = this.plugin.getStatsManager().getPlayerStats(player.getUniqueId());
        this.messageManager.sendMessageNoPrefix(player, "stats.header");
        this.messageManager.sendMessageNoPrefix(player, "stats.games-played", "games", String.valueOf(stats.gamesPlayed));
        this.messageManager.sendMessageNoPrefix(player, "stats.games-won", "won", String.valueOf(stats.gamesWon));
        this.messageManager.sendMessageNoPrefix(player, "stats.win-rate", "rate", String.format("%.1f", stats.getWinRate()));
        this.messageManager.sendMessageNoPrefix(player, "stats.total-wagered", "wagered", this.messageManager.formatCurrency(stats.totalWagered));
        this.messageManager.sendMessageNoPrefix(player, "stats.total-winnings", "winnings", this.messageManager.formatCurrency(stats.totalWinnings));
        this.messageManager.sendMessageNoPrefix(player, "stats.net-profit", "profit", this.messageManager.formatCurrency(stats.getNetProfit()));
        this.messageManager.sendMessageNoPrefix(player, "stats.biggest-win", "biggest_win", this.messageManager.formatCurrency(stats.biggestWin));
    }

    private void handleAdminPanelClick(Player player, Material material, int slot) {
        if (slot == 11) {
            player.closeInventory();
            this.showGlobalStats(player);
        } else if (slot == 15) {
            player.closeInventory();
            this.showLeaderboard(player);
        }
    }

    private void showGlobalStats(Player player) {
        StatsManager.GlobalStats stats = this.plugin.getStatsManager().getGlobalStats();
        this.messageManager.sendMessageNoPrefix(player, "admin.stats-header");
        this.messageManager.sendMessageNoPrefix(player, "admin.stats-games-played", "games", String.valueOf(stats.totalGames));
        this.messageManager.sendMessageNoPrefix(player, "admin.stats-money-wagered", "wagered", this.messageManager.formatCurrency(stats.totalWagered));
        this.messageManager.sendMessageNoPrefix(player, "admin.stats-house-profit", "profit", this.messageManager.formatCurrency(stats.houseProfit));
        this.messageManager.sendMessageNoPrefix(player, "admin.stats-total-winners", "winners", String.valueOf(stats.totalWinners));
        this.messageManager.sendMessageNoPrefix(player, "admin.stats-biggest-win", "biggest_win", this.messageManager.formatCurrency(stats.biggestWin));
    }

    private void showLeaderboard(Player player) {
        player.closeInventory();
        String title = this.messageManager.getMessage("gui.leaderboard-title");
        Inventory menu = Bukkit.createInventory(null, (int)54, (String)title);
        ItemStack filler = new ItemStack(Material.GRAY_STAINED_GLASS_PANE);
        ItemMeta fillerMeta = filler.getItemMeta();
        fillerMeta.setDisplayName(" ");
        filler.setItemMeta(fillerMeta);
        for (int i = 0; i < 54; ++i) {
            menu.setItem(i, filler);
        }
        List<StatsManager.LeaderboardEntry> topPlayers = this.plugin.getStatsManager().getTopPlayersByWagered(10);
        int[] displaySlots = new int[]{10, 11, 12, 13, 14, 15, 16, 19, 20, 21};
        for (int i = 0; i < topPlayers.size() && i < displaySlots.length; ++i) {
            StatsManager.LeaderboardEntry entry = topPlayers.get(i);
            Player topPlayer = Bukkit.getOfflinePlayer((UUID)entry.playerId).getPlayer();
            String playerName = topPlayer != null ? topPlayer.getName() : "Unknown";
            ItemStack playerItem = new ItemStack(Material.PLAYER_HEAD);
            ItemMeta playerMeta = playerItem.getItemMeta();
            playerMeta.setDisplayName(this.messageManager.getMessage("gui.leaderboard-player-name", "rank", String.valueOf(i + 1), "player", playerName));
            ArrayList<String> lore = new ArrayList<String>();
            lore.add(this.messageManager.getMessage("gui.leaderboard-wagered", "amount", this.messageManager.formatCurrency(entry.value)));
            playerMeta.setLore(lore);
            playerItem.setItemMeta(playerMeta);
            menu.setItem(displaySlots[i], playerItem);
        }
        player.openInventory(menu);
    }

    public HashMap<UUID, BetInputState> getBetInputStates() {
        return this.betInputStates;
    }

    public void cleanupExpiredGames() {
        long currentTime = System.currentTimeMillis();
        int expiryTime = this.plugin.getConfig().getInt("coinflip.expiry-time", 300) * 1000;
        this.plugin.getPendingCoinFlips().entrySet().removeIf(entry -> {
            CoinFlipZ.CoinFlipGame game = (CoinFlipZ.CoinFlipGame)entry.getValue();
            if (game.getOpponent() != null) {
                return false;
            }
            Player creator = Bukkit.getPlayer((UUID)game.getCreator());
            if (creator != null && creator.isOnline()) {
                CoinFlipZ.getEconomy().depositPlayer((OfflinePlayer)creator, game.getBetAmount());
                this.messageManager.sendMessage(creator, "coinflip.game-cancelled-quit", "player", creator.getName());
            }
            return true;
        });
    }

    public void forceCleanup() {
        for (CoinFlipZ.CoinFlipGame game : this.plugin.getPendingCoinFlips().values()) {
            Player player = Bukkit.getPlayer((UUID)game.getCreator());
            if (player == null) continue;
            CoinFlipZ.getEconomy().depositPlayer((OfflinePlayer)player, game.getBetAmount());
        }
        this.plugin.getPendingCoinFlips().clear();
        this.betInputStates.clear();
        this.plugin.getActiveRoulettes().clear();
        this.playersInActiveGame.clear();
    }

    public Map<UUID, String> getPlayersInBetMode() {
        HashMap<UUID, String> result = new HashMap<UUID, String>();
        for (Map.Entry<UUID, BetInputState> entry : this.betInputStates.entrySet()) {
            result.put(entry.getKey(), entry.getValue().getDescription());
        }
        return result;
    }

    public boolean cancelBetInput(UUID playerId) {
        BetInputState state = this.betInputStates.remove(playerId);
        if (state != null) {
            Player player = Bukkit.getPlayer((UUID)playerId);
            if (player != null) {
                this.messageManager.sendMessage(player, "roulette.bet-cancelled");
            }
            return true;
        }
        return false;
    }

    public int getActiveCoinFlipCount() {
        return this.plugin.getPendingCoinFlips().size();
    }

    public int getActiveRouletteCount() {
        return this.plugin.getActiveRoulettes().size();
    }

    public int getBetInputCount() {
        return this.betInputStates.size();
    }

    public void handleAdminAction(Player player, String action, String target) {
        if (!player.hasPermission("coinflipz.admin")) {
            this.messageManager.sendMessage(player, "no-permission");
            return;
        }
        switch (action.toLowerCase()) {
            case "cleanup": {
                this.forceCleanup();
                this.messageManager.sendMessage(player, "admin.config-reloaded");
                break;
            }
            case "cancel": {
                if (target != null) {
                    Player targetPlayer = Bukkit.getPlayer((String)target);
                    if (targetPlayer != null) {
                        UUID targetId = targetPlayer.getUniqueId();
                        if (this.plugin.getPendingCoinFlips().containsKey(targetId)) {
                            CoinFlipZ.CoinFlipGame game = this.plugin.getPendingCoinFlips().remove(targetId);
                            CoinFlipZ.getEconomy().depositPlayer((OfflinePlayer)targetPlayer, game.getBetAmount());
                            this.messageManager.sendMessage(targetPlayer, "coinflip.game-cancelled-shutdown");
                            this.messageManager.sendMessage(player, "admin.cancel-success", "player", target);
                        }
                        if (this.cancelBetInput(targetId)) {
                            this.messageManager.sendMessage(player, "admin.cancel-bet-success", "player", target);
                        }
                        this.plugin.getActiveRoulettes().remove(targetId);
                        this.playersInActiveGame.remove(targetId);
                        break;
                    }
                    this.messageManager.sendMessage(player, "player-not-found");
                    break;
                }
                this.messageManager.sendMessage(player, "admin.cancel-no-target");
                break;
            }
            case "stats": {
                this.showDetailedAdminStats(player);
                break;
            }
            default: {
                this.messageManager.sendMessage(player, "admin.unknown-action", "action", action);
            }
        }
    }

    private void showDetailedAdminStats(Player player) {
        this.messageManager.sendMessageNoPrefix(player, "admin.detailed-header");
        this.messageManager.sendMessageNoPrefix(player, "admin.detailed-coinflip-games", "count", String.valueOf(this.getActiveCoinFlipCount()));
        this.messageManager.sendMessageNoPrefix(player, "admin.detailed-roulette-games", "count", String.valueOf(this.getActiveRouletteCount()));
        this.messageManager.sendMessageNoPrefix(player, "admin.detailed-bet-inputs", "count", String.valueOf(this.getBetInputCount()));
        if (!this.betInputStates.isEmpty()) {
            this.messageManager.sendMessageNoPrefix(player, "admin.detailed-bet-input-header");
            for (Map.Entry<UUID, BetInputState> entry : this.betInputStates.entrySet()) {
                Player betPlayer = Bukkit.getPlayer((UUID)entry.getKey());
                String playerName = betPlayer != null ? betPlayer.getName() : "Unknown";
                BetInputState state = entry.getValue();
                this.messageManager.sendMessageNoPrefix(player, "admin.detailed-bet-input-line", "player", playerName, "description", state.getDescription(), "age", String.valueOf(state.getAgeSeconds()));
            }
        }
        if (!this.plugin.getPendingCoinFlips().isEmpty()) {
            this.messageManager.sendMessageNoPrefix(player, "admin.detailed-pending-games-header");
            for (Map.Entry<UUID, Object> entry : this.plugin.getPendingCoinFlips().entrySet()) {
                Player creator = Bukkit.getPlayer((UUID)entry.getKey());
                String creatorName = creator != null ? creator.getName() : "Unknown";
                CoinFlipZ.CoinFlipGame game = (CoinFlipZ.CoinFlipGame)entry.getValue();
                this.messageManager.sendMessageNoPrefix(player, "admin.detailed-pending-game-line", "player", creatorName, "amount", this.messageManager.formatCurrency(game.getBetAmount()));
            }
        }
    }

    public static class BetInputState {
        private final String betType;
        private final int number;
        private final long timestamp;

        public BetInputState(String betType, int number) {
            this.betType = betType;
            this.number = number;
            this.timestamp = System.currentTimeMillis();
        }

        public String getBetType() {
            return this.betType;
        }

        public int getNumber() {
            return this.number;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public boolean isExpired(long timeoutMillis) {
            return System.currentTimeMillis() - this.timestamp > timeoutMillis;
        }

        public String getDescription() {
            if (this.betType.equals("coinflip")) {
                return "Coin Flip Game Creation";
            }
            if (this.betType.equals("number")) {
                return "Roulette Number " + this.number;
            }
            return "Roulette " + this.betType.toUpperCase();
        }

        public boolean isBetType(String type) {
            return this.betType.equalsIgnoreCase(type);
        }

        public long getAgeSeconds() {
            return (System.currentTimeMillis() - this.timestamp) / 1000L;
        }
    }
}

