/*
 * Decompiled with CFR 0.152.
 */
package com.example.coinflipz;

import com.example.coinflipz.CoinFlipZ;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Method;
import java.util.List;
import java.util.logging.Level;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.ChatColor;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class MessageManager {
    private final CoinFlipZ plugin;
    private FileConfiguration messagesConfig;
    private File messagesFile;
    private final MiniMessage miniMessage;
    private final LegacyComponentSerializer legacySerializer;
    private static final Pattern STRIP_COLOR_PATTERN = Pattern.compile("(?i)\u00a7[0-9A-FK-OR]");
    private boolean hasNativeAdventure = false;
    private Method sendComponentMethod = null;

    public MessageManager(CoinFlipZ plugin) {
        this.plugin = plugin;
        this.miniMessage = MiniMessage.miniMessage();
        this.legacySerializer = LegacyComponentSerializer.legacyAmpersand();
        this.checkAdventureSupport();
        this.loadMessages();
    }

    private void checkAdventureSupport() {
        try {
            Class<?> componentClass = Class.forName("net.kyori.adventure.text.Component");
            this.sendComponentMethod = Player.class.getMethod("sendMessage", componentClass);
            this.hasNativeAdventure = true;
            this.plugin.getLogger().info("Native Adventure API support detected!");
        }
        catch (Exception e) {
            this.hasNativeAdventure = false;
            this.plugin.getLogger().info("Using legacy color code conversion");
        }
    }

    public void loadMessages() {
        this.messagesFile = new File(this.plugin.getDataFolder(), "messages.yml");
        if (!this.messagesFile.exists()) {
            this.plugin.saveResource("messages.yml", false);
        }
        this.messagesConfig = YamlConfiguration.loadConfiguration((File)this.messagesFile);
        InputStream defConfigStream = this.plugin.getResource("messages.yml");
        if (defConfigStream != null) {
            YamlConfiguration defConfig = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(defConfigStream));
            this.messagesConfig.setDefaults((Configuration)defConfig);
        }
        this.plugin.getLogger().info("Messages configuration loaded successfully!");
        this.plugin.getLogger().info("MiniMessage format: ENABLED (Always)");
    }

    public void reloadMessages() {
        if (this.messagesFile == null) {
            this.messagesFile = new File(this.plugin.getDataFolder(), "messages.yml");
        }
        this.messagesConfig = YamlConfiguration.loadConfiguration((File)this.messagesFile);
        InputStream defConfigStream = this.plugin.getResource("messages.yml");
        if (defConfigStream != null) {
            YamlConfiguration defConfig = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(defConfigStream));
            this.messagesConfig.setDefaults((Configuration)defConfig);
        }
    }

    private boolean sendNativeComponent(Player player, Component component) {
        if (this.hasNativeAdventure && this.sendComponentMethod != null) {
            try {
                this.sendComponentMethod.invoke((Object)player, component);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    private String miniMessageToLegacy(String message) {
        try {
            Component component = this.miniMessage.deserialize((Object)message);
            String ampersandCodes = this.legacySerializer.serialize(component);
            return ChatColor.translateAlternateColorCodes((char)'&', (String)ampersandCodes);
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Failed to parse MiniMessage: " + message);
            return ChatColor.translateAlternateColorCodes((char)'&', (String)this.convertBasicTags(message));
        }
    }

    private String convertBasicTags(String message) {
        message = message.replace("<black>", "&0").replace("</black>", "");
        message = message.replace("<dark_blue>", "&1").replace("</dark_blue>", "");
        message = message.replace("<dark_green>", "&2").replace("</dark_green>", "");
        message = message.replace("<dark_aqua>", "&3").replace("</dark_aqua>", "");
        message = message.replace("<dark_red>", "&4").replace("</dark_red>", "");
        message = message.replace("<dark_purple>", "&5").replace("</dark_purple>", "");
        message = message.replace("<gold>", "&6").replace("</gold>", "");
        message = message.replace("<gray>", "&7").replace("</gray>", "");
        message = message.replace("<dark_gray>", "&8").replace("</dark_gray>", "");
        message = message.replace("<blue>", "&9").replace("</blue>", "");
        message = message.replace("<green>", "&a").replace("</green>", "");
        message = message.replace("<aqua>", "&b").replace("</aqua>", "");
        message = message.replace("<red>", "&c").replace("</red>", "");
        message = message.replace("<light_purple>", "&d").replace("</light_purple>", "");
        message = message.replace("<yellow>", "&e").replace("</yellow>", "");
        message = message.replace("<white>", "&f").replace("</white>", "");
        message = message.replace("<bold>", "&l").replace("</bold>", "&r");
        message = message.replace("<italic>", "&o").replace("</italic>", "&r");
        message = message.replace("<underlined>", "&n").replace("</underlined>", "&r");
        message = message.replace("<strikethrough>", "&m").replace("</strikethrough>", "&r");
        message = message.replace("<obfuscated>", "&k").replace("</obfuscated>", "&r");
        message = message.replaceAll("<gradient:[^:]+:([^>]+)>", "&6");
        message = message.replaceAll("</gradient>", "");
        message = message.replaceAll("<[^>]+>", "");
        return message;
    }

    public String getMessage(String path) {
        String message = this.messagesConfig.getString(path);
        if (message == null) {
            this.plugin.getLogger().warning("Missing message: " + path);
            return String.valueOf(ChatColor.RED) + "Missing message: " + path;
        }
        return this.miniMessageToLegacy(message);
    }

    public String getMessage(String path, String ... placeholders) {
        String message = this.messagesConfig.getString(path);
        if (message == null) {
            this.plugin.getLogger().warning("Missing message: " + path);
            return String.valueOf(ChatColor.RED) + "Missing message: " + path;
        }
        for (int i = 0; i < placeholders.length; i += 2) {
            if (i + 1 >= placeholders.length) continue;
            message = message.replace("%" + placeholders[i] + "%", placeholders[i + 1]);
        }
        return this.miniMessageToLegacy(message);
    }

    public List<String> getMessageList(String path) {
        List messages = this.messagesConfig.getStringList(path);
        if (messages.isEmpty()) {
            this.plugin.getLogger().warning("Missing message list: " + path);
            return List.of(String.valueOf(ChatColor.RED) + "Missing message list: " + path);
        }
        return messages.stream().map(this::miniMessageToLegacy).collect(Collectors.toList());
    }

    public List<String> getMessageList(String path, String ... placeholders) {
        List messages = this.messagesConfig.getStringList(path);
        if (messages.isEmpty()) {
            this.plugin.getLogger().warning("Missing message list: " + path);
            return List.of(String.valueOf(ChatColor.RED) + "Missing message list: " + path);
        }
        return messages.stream().map(message -> {
            for (int i = 0; i < placeholders.length; i += 2) {
                if (i + 1 >= placeholders.length) continue;
                message = message.replace("%" + placeholders[i] + "%", placeholders[i + 1]);
            }
            return this.miniMessageToLegacy((String)message);
        }).collect(Collectors.toList());
    }

    public void sendMessage(Player player, String path) {
        String rawMessage = this.messagesConfig.getString(path);
        String rawPrefix = this.messagesConfig.getString("prefix");
        if (rawMessage == null) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Missing message: " + path);
            return;
        }
        if (rawPrefix == null) {
            rawPrefix = "<gold>[CoinFlipZ] <yellow>";
        }
        String fullMessage = rawPrefix + rawMessage;
        this.sendRawMessage(player, fullMessage);
    }

    public void sendMessage(Player player, String path, String ... placeholders) {
        String rawMessage = this.messagesConfig.getString(path);
        String rawPrefix = this.messagesConfig.getString("prefix");
        if (rawMessage == null) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Missing message: " + path);
            return;
        }
        if (rawPrefix == null) {
            rawPrefix = "<gold>[CoinFlipZ] <yellow>";
        }
        for (int i = 0; i < placeholders.length; i += 2) {
            if (i + 1 >= placeholders.length) continue;
            rawMessage = rawMessage.replace("%" + placeholders[i] + "%", placeholders[i + 1]);
        }
        String fullMessage = rawPrefix + rawMessage;
        this.sendRawMessage(player, fullMessage);
    }

    public void sendMessageNoPrefix(Player player, String path) {
        String rawMessage = this.messagesConfig.getString(path);
        if (rawMessage == null) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Missing message: " + path);
            return;
        }
        this.sendRawMessage(player, rawMessage);
    }

    public void sendMessageNoPrefix(Player player, String path, String ... placeholders) {
        String rawMessage = this.messagesConfig.getString(path);
        if (rawMessage == null) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Missing message: " + path);
            return;
        }
        for (int i = 0; i < placeholders.length; i += 2) {
            if (i + 1 >= placeholders.length) continue;
            rawMessage = rawMessage.replace("%" + placeholders[i] + "%", placeholders[i + 1]);
        }
        this.sendRawMessage(player, rawMessage);
    }

    public void sendRawMessage(Player player, String message) {
        try {
            Component component = this.miniMessage.deserialize((Object)message);
            if (this.sendNativeComponent(player, component)) {
                return;
            }
            String ampersandMessage = this.legacySerializer.serialize(component);
            player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)ampersandMessage));
        }
        catch (Exception e) {
            player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.convertBasicTags(message)));
        }
    }

    public void saveMessages() {
        if (this.messagesConfig == null || this.messagesFile == null) {
            return;
        }
        try {
            this.messagesConfig.save(this.messagesFile);
        }
        catch (IOException ex) {
            this.plugin.getLogger().log(Level.SEVERE, "Could not save config to " + String.valueOf(this.messagesFile), ex);
        }
    }

    public String getPrefix() {
        return this.getMessage("prefix");
    }

    public String getBetDescription(String betType, int number) {
        switch (betType.toLowerCase()) {
            case "number": {
                return this.getMessage("bet-descriptions.number", "number", String.valueOf(number));
            }
            case "red": {
                return this.getMessage("bet-descriptions.red");
            }
            case "black": {
                return this.getMessage("bet-descriptions.black");
            }
            case "even": {
                return this.getMessage("bet-descriptions.even");
            }
            case "odd": {
                return this.getMessage("bet-descriptions.odd");
            }
            case "dozen-1": {
                return this.getMessage("bet-descriptions.dozen-1");
            }
            case "dozen-2": {
                return this.getMessage("bet-descriptions.dozen-2");
            }
            case "dozen-3": {
                return this.getMessage("bet-descriptions.dozen-3");
            }
            case "low": {
                return this.getMessage("bet-descriptions.low");
            }
            case "high": {
                return this.getMessage("bet-descriptions.high");
            }
        }
        return betType;
    }

    public String getRouletteNumberColor(int number) {
        if (number == 0) {
            return this.getMessage("roulette-colors.green");
        }
        if (number % 2 == 0) {
            return this.getMessage("roulette-colors.red");
        }
        return this.getMessage("roulette-colors.black");
    }

    public String formatCurrency(double amount) {
        if (amount == (double)((long)amount)) {
            return String.valueOf((long)amount);
        }
        return String.format("%.2f", amount);
    }

    public String stripColors(String input) {
        if (input == null) {
            return null;
        }
        String result = STRIP_COLOR_PATTERN.matcher(input).replaceAll("");
        result = result.replaceAll("<[^>]+>", "");
        return result;
    }

    public boolean hasNativeAdventureSupport() {
        return this.hasNativeAdventure;
    }
}

