/*
 * Decompiled with CFR 0.152.
 */
package com.example.coinflipz;

import com.example.coinflipz.CoinFlipZ;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class StatsManager {
    private final CoinFlipZ plugin;
    private File statsFile;
    private FileConfiguration statsConfig;
    private File globalStatsFile;
    private FileConfiguration globalStatsConfig;

    public StatsManager(CoinFlipZ plugin) {
        this.plugin = plugin;
        this.loadStats();
    }

    public void loadStats() {
        this.statsFile = new File(this.plugin.getDataFolder(), "playerstats.yml");
        if (!this.statsFile.exists()) {
            try {
                this.statsFile.createNewFile();
            }
            catch (IOException e) {
                this.plugin.getLogger().severe("Could not create playerstats.yml!");
            }
        }
        this.statsConfig = YamlConfiguration.loadConfiguration((File)this.statsFile);
        this.globalStatsFile = new File(this.plugin.getDataFolder(), "globalstats.yml");
        if (!this.globalStatsFile.exists()) {
            try {
                this.globalStatsFile.createNewFile();
                this.globalStatsConfig = YamlConfiguration.loadConfiguration((File)this.globalStatsFile);
                this.globalStatsConfig.set("total-games", (Object)0);
                this.globalStatsConfig.set("total-wagered", (Object)0.0);
                this.globalStatsConfig.set("house-profit", (Object)0.0);
                this.globalStatsConfig.set("total-winners", (Object)0);
                this.globalStatsConfig.set("biggest-win", (Object)0.0);
                this.saveGlobalStats();
            }
            catch (IOException e) {
                this.plugin.getLogger().severe("Could not create globalstats.yml!");
            }
        } else {
            this.globalStatsConfig = YamlConfiguration.loadConfiguration((File)this.globalStatsFile);
        }
        this.plugin.getLogger().info("Stats files loaded successfully!");
    }

    public PlayerStats getPlayerStats(UUID playerId) {
        String path = playerId.toString();
        if (!this.statsConfig.contains(path)) {
            return new PlayerStats();
        }
        PlayerStats stats = new PlayerStats();
        stats.gamesPlayed = this.statsConfig.getInt(path + ".games-played", 0);
        stats.gamesWon = this.statsConfig.getInt(path + ".games-won", 0);
        stats.totalWagered = this.statsConfig.getDouble(path + ".total-wagered", 0.0);
        stats.totalWinnings = this.statsConfig.getDouble(path + ".total-winnings", 0.0);
        stats.biggestWin = this.statsConfig.getDouble(path + ".biggest-win", 0.0);
        return stats;
    }

    public void savePlayerStats(UUID playerId, PlayerStats stats) {
        String path = playerId.toString();
        this.statsConfig.set(path + ".games-played", (Object)stats.gamesPlayed);
        this.statsConfig.set(path + ".games-won", (Object)stats.gamesWon);
        this.statsConfig.set(path + ".total-wagered", (Object)stats.totalWagered);
        this.statsConfig.set(path + ".total-winnings", (Object)stats.totalWinnings);
        this.statsConfig.set(path + ".biggest-win", (Object)stats.biggestWin);
        this.saveStats();
    }

    public void recordCoinFlip(UUID winnerId, UUID loserId, double betAmount, double prize) {
        PlayerStats winnerStats = this.getPlayerStats(winnerId);
        ++winnerStats.gamesPlayed;
        ++winnerStats.gamesWon;
        winnerStats.totalWagered += betAmount;
        winnerStats.totalWinnings += prize;
        if (prize > winnerStats.biggestWin) {
            winnerStats.biggestWin = prize;
        }
        this.savePlayerStats(winnerId, winnerStats);
        PlayerStats loserStats = this.getPlayerStats(loserId);
        ++loserStats.gamesPlayed;
        loserStats.totalWagered += betAmount;
        this.savePlayerStats(loserId, loserStats);
        this.updateGlobalStats(betAmount * 2.0, prize, prize);
    }

    public void recordRoulette(UUID playerId, double betAmount, double winnings, boolean won) {
        PlayerStats stats = this.getPlayerStats(playerId);
        ++stats.gamesPlayed;
        stats.totalWagered += betAmount;
        if (won) {
            ++stats.gamesWon;
            stats.totalWinnings += winnings;
            if (winnings > stats.biggestWin) {
                stats.biggestWin = winnings;
            }
        }
        this.savePlayerStats(playerId, stats);
        double houseProfit = won ? betAmount - winnings : betAmount;
        this.updateGlobalStats(betAmount, houseProfit, won ? winnings : 0.0);
    }

    private void updateGlobalStats(double wagered, double profit, double winAmount) {
        int totalGames = this.globalStatsConfig.getInt("total-games", 0);
        double totalWagered = this.globalStatsConfig.getDouble("total-wagered", 0.0);
        double houseProfit = this.globalStatsConfig.getDouble("house-profit", 0.0);
        int totalWinners = this.globalStatsConfig.getInt("total-winners", 0);
        double biggestWin = this.globalStatsConfig.getDouble("biggest-win", 0.0);
        this.globalStatsConfig.set("total-games", (Object)(totalGames + 1));
        this.globalStatsConfig.set("total-wagered", (Object)(totalWagered + wagered));
        this.globalStatsConfig.set("house-profit", (Object)(houseProfit + profit));
        if (winAmount > 0.0) {
            this.globalStatsConfig.set("total-winners", (Object)(totalWinners + 1));
            if (winAmount > biggestWin) {
                this.globalStatsConfig.set("biggest-win", (Object)winAmount);
            }
        }
        this.saveGlobalStats();
    }

    public GlobalStats getGlobalStats() {
        GlobalStats stats = new GlobalStats();
        stats.totalGames = this.globalStatsConfig.getInt("total-games", 0);
        stats.totalWagered = this.globalStatsConfig.getDouble("total-wagered", 0.0);
        stats.houseProfit = this.globalStatsConfig.getDouble("house-profit", 0.0);
        stats.totalWinners = this.globalStatsConfig.getInt("total-winners", 0);
        stats.biggestWin = this.globalStatsConfig.getDouble("biggest-win", 0.0);
        return stats;
    }

    public List<LeaderboardEntry> getTopPlayersByWagered(int limit) {
        return this.getTopPlayers("total-wagered", limit);
    }

    public List<LeaderboardEntry> getTopPlayersByWinnings(int limit) {
        return this.getTopPlayers("total-winnings", limit);
    }

    public List<LeaderboardEntry> getTopPlayersByBiggestWin(int limit) {
        return this.getTopPlayers("biggest-win", limit);
    }

    public List<LeaderboardEntry> getTopPlayersByWinRate(int limit) {
        ArrayList<LeaderboardEntry> entries = new ArrayList<LeaderboardEntry>();
        for (String key : this.statsConfig.getKeys(false)) {
            try {
                UUID playerId = UUID.fromString(key);
                PlayerStats stats = this.getPlayerStats(playerId);
                if (stats.gamesPlayed <= 0) continue;
                double winRate = (double)stats.gamesWon / (double)stats.gamesPlayed * 100.0;
                entries.add(new LeaderboardEntry(playerId, winRate));
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return entries.stream().sorted((a, b) -> Double.compare(b.value, a.value)).limit(limit).collect(Collectors.toList());
    }

    private List<LeaderboardEntry> getTopPlayers(String statKey, int limit) {
        ArrayList<LeaderboardEntry> entries = new ArrayList<LeaderboardEntry>();
        for (String key : this.statsConfig.getKeys(false)) {
            try {
                UUID playerId = UUID.fromString(key);
                double value = this.statsConfig.getDouble(key + "." + statKey, 0.0);
                entries.add(new LeaderboardEntry(playerId, value));
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return entries.stream().sorted((a, b) -> Double.compare(b.value, a.value)).limit(limit).collect(Collectors.toList());
    }

    private void saveStats() {
        try {
            this.statsConfig.save(this.statsFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Could not save playerstats.yml!");
            e.printStackTrace();
        }
    }

    private void saveGlobalStats() {
        try {
            this.globalStatsConfig.save(this.globalStatsFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Could not save globalstats.yml!");
            e.printStackTrace();
        }
    }

    public static class PlayerStats {
        public int gamesPlayed = 0;
        public int gamesWon = 0;
        public double totalWagered = 0.0;
        public double totalWinnings = 0.0;
        public double biggestWin = 0.0;

        public double getWinRate() {
            if (this.gamesPlayed == 0) {
                return 0.0;
            }
            return (double)this.gamesWon / (double)this.gamesPlayed * 100.0;
        }

        public double getNetProfit() {
            return this.totalWinnings - this.totalWagered;
        }
    }

    public static class GlobalStats {
        public int totalGames = 0;
        public double totalWagered = 0.0;
        public double houseProfit = 0.0;
        public int totalWinners = 0;
        public double biggestWin = 0.0;
    }

    public static class LeaderboardEntry {
        public UUID playerId;
        public double value;

        public LeaderboardEntry(UUID playerId, double value) {
            this.playerId = playerId;
            this.value = value;
        }
    }
}

