/*
 * Decompiled with CFR 0.152.
 */
package dev.kikugie.mcstatfetch;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.LinkedHashMap;
import java.util.Map;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2596;
import net.minecraft.class_2799;
import net.minecraft.class_310;
import net.minecraft.class_3445;
import net.minecraft.class_3448;
import net.minecraft.class_3469;
import net.minecraft.class_5250;
import net.minecraft.class_634;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatFetcher
implements ClientModInitializer {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"template");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    @Nullable
    private static Instant REQUEST_STAMP = null;

    public void onInitializeClient() {
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, access) -> dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"fetch_stats").executes(ctx -> {
            StatFetcher.onRequestStats((CommandContext<FabricClientCommandSource>)ctx);
            return 1;
        })));
    }

    public static void onRequestStats(CommandContext<FabricClientCommandSource> ctx) {
        class_310 client = class_310.method_1551();
        class_634 connection = client.method_1562();
        if (client.field_1724 == null || connection == null) {
            ((FabricClientCommandSource)ctx.getSource()).sendError((class_2561)class_2561.method_43470((String)"Unable to request statistics"));
            return;
        }
        REQUEST_STAMP = Instant.now();
        class_2799 packet = new class_2799(class_2799.class_2800.field_12775);
        connection.method_52787((class_2596)packet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onReceiveStats() {
        class_310 client = class_310.method_1551();
        if (REQUEST_STAMP == null || client.field_1724 == null) {
            return;
        }
        class_3469 stats = client.field_1724.method_3143();
        LinkedHashMap<String, Map<String, Integer>> counts = new LinkedHashMap<String, Map<String, Integer>>();
        for (class_6880 holder : class_7923.field_41193.method_40295()) {
            String[] name = holder.method_55840().split(":");
            Map<String, Integer> values = StatFetcher.populateStats((class_3448)holder.comp_349(), stats);
            if (values.isEmpty()) continue;
            counts.put(name[name.length - 1], values);
        }
        LocalDateTime time = LocalDateTime.ofInstant(REQUEST_STAMP.truncatedTo(ChronoUnit.SECONDS), ZoneId.systemDefault());
        String filename = "Stats@%s.json".formatted(time.toString());
        Path location = FabricLoader.getInstance().getGameDir().resolve("statistics");
        Path file = location.resolve(filename);
        try {
            Files.createDirectories(location, new FileAttribute[0]);
            Files.writeString(file, (CharSequence)GSON.toJson(counts), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            class_2583 style = class_2583.field_24360.method_30938(Boolean.valueOf(true)).method_10958((class_2558)new class_2558.class_10607(file));
            class_5250 message = class_2561.method_43470((String)"Saves player statistics to ").method_10852((class_2561)class_2561.method_43470((String)filename).method_27696(style));
            client.field_1724.method_7353((class_2561)message, false);
        }
        catch (IOException e) {
            class_5250 message = class_2561.method_43470((String)"Failed to save the statistics file").method_27692(class_124.field_1061);
            LOGGER.error(message.getString(), (Throwable)e);
            client.field_1724.method_7353((class_2561)message, false);
        }
        finally {
            REQUEST_STAMP = null;
        }
    }

    private static <T> Map<String, Integer> populateStats(class_3448<T> type, class_3469 counter) {
        LinkedHashMap<String, Integer> counts = new LinkedHashMap<String, Integer>();
        for (class_3445 stat : type) {
            int value = counter.method_15025(stat);
            if (value <= 0) continue;
            String[] name = stat.method_1225().split("\\.");
            counts.put(name[name.length - 1], value);
        }
        return counts;
    }
}

