package dev.kikugie.mcstatfetch;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2799;
import net.minecraft.class_310;
import net.minecraft.class_3445;
import net.minecraft.class_3448;
import net.minecraft.class_3469;
import net.minecraft.class_634;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.LinkedHashMap;
import java.util.Map;

import static net.fabricmc.fabric.api.client.command.v2.ClientCommandManager.literal;

public class StatFetcher implements ClientModInitializer {
    public static final Logger LOGGER = LoggerFactory.getLogger("template");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static @Nullable Instant REQUEST_STAMP = null;

    @Override
    public void onInitializeClient() {
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, access) -> dispatcher.register(literal("fetch_stats").executes(ctx -> {
            onRequestStats(ctx);
            return 1;
        })));
    }

    public static void onRequestStats(CommandContext<FabricClientCommandSource> ctx) {
        class_310 client = class_310.method_1551();
        class_634 connection = client.method_1562();
        if (client.field_1724 == null || connection == null) {
            ctx.getSource().sendError(class_2561.method_43470("Unable to request statistics"));
            return;
        }

        REQUEST_STAMP = Instant.now();
        var packet = new class_2799(class_2799.class_2800.field_12775);
        connection.method_52787(packet);
    }

    public static void onReceiveStats() {
        class_310 client = class_310.method_1551();
        if (REQUEST_STAMP == null || client.field_1724 == null) return;

        class_3469 stats = client.field_1724.method_3143();
        Map<String, Map<String, Integer>> counts = new LinkedHashMap<>();
        for (class_6880<class_3448<?>> holder : class_7923.field_41193.method_40295()) {
            String[] name = holder.method_55840().split(":");
            Map<String, Integer> values = populateStats(holder.comp_349(), stats);
            if (!values.isEmpty()) counts.put(name[name.length - 1], values);
        }

        LocalDateTime time = LocalDateTime.ofInstant(REQUEST_STAMP.truncatedTo(ChronoUnit.SECONDS), ZoneId.systemDefault());
        String filename = "Stats-%s.json".formatted(time.toString().replace(':', '-'));
        Path location = FabricLoader.getInstance().getGameDir().resolve("statistics");
        Path file = location.resolve(filename);

        try {
            Files.createDirectories(location);
            Files.writeString(file, GSON.toJson(counts), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            class_2583 style = class_2583.field_24360.method_30938(true).method_10958(new class_2558.class_10607(file));
            class_2561 message = class_2561.method_43470("Saves player statistics to ")
                .method_10852(class_2561.method_43470(filename).method_27696(style));
            client.field_1724.method_7353(message, false);
        } catch (IOException e) {
            class_2561 message = class_2561.method_43470("Failed to save the statistics file").method_27692(class_124.field_1061);
            LOGGER.error(message.getString(), e);
            client.field_1724.method_7353(message, false);
        } finally {
            REQUEST_STAMP = null;
        }
    }

    private static  <T> Map<String, Integer> populateStats(class_3448<T> type, class_3469 counter) {
        Map<String, Integer> counts = new LinkedHashMap<>();
        for (class_3445<T> stat : type) {
            int value = counter.method_15025(stat);
            if (value <= 0) continue;

            String[] name = stat.method_1225().split("\\.");
            counts.put(name[name.length - 1], value);
        }
        return counts;
    }
}