/*
 * Decompiled with CFR 0.152.
 */
package org.eu.hanana.reimu.chatimage;

import cpw.mods.cl.ModularURLHandler;
import java.io.File;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.client.gui.ConfigurationScreen;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.HandlerThread;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eu.hanana.reimu.chatimage.EventHandler;
import org.eu.hanana.reimu.chatimage.Util;
import org.eu.hanana.reimu.chatimage.config.ChatImageConfig;
import org.eu.hanana.reimu.chatimage.core.ChatimageURLStreamHandlerFactory;
import org.eu.hanana.reimu.chatimage.register.MenuRegister;
import sun.misc.Unsafe;

@Mod(value="chatimage")
public class ChatimageMod {
    public static final String MOD_ID = "chatimage";
    public static final Logger logger = LogManager.getLogger();
    public static boolean GLOBAL_PROTOCOL = true;

    public ChatimageMod(IEventBus modBus, ModContainer container) {
        NeoForge.EVENT_BUS.register((Object)new EventHandler());
        MenuRegister.register(modBus);
        modBus.addListener(this::init);
        container.getEventBus().register(ChatImageConfig.class);
        container.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)ChatImageConfig.commonSpec);
        container.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ChatImageConfig.clientSpec);
        if (FMLEnvironment.dist.isClient()) {
            this.clientSideInit(container);
            modBus.addListener(this::registerScreens);
        }
        modBus.addListener(this::registerPayloads);
    }

    private void registerPayloads(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar("1").executesOn(HandlerThread.NETWORK);
    }

    private void clientSideInit(ModContainer container) {
        container.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)(mc, parent) -> new ConfigurationScreen(container, parent)));
    }

    private void init(FMLCommonSetupEvent event) {
        if (ChatImageConfig.remove_all.booleanValue()) {
            try {
                Util.deleteDirectory(new File(".", MOD_ID));
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        GLOBAL_PROTOCOL = true;
        try {
            URL.setURLStreamHandlerFactory(new ChatimageURLStreamHandlerFactory());
        }
        catch (Throwable e) {
            try {
                Field field = Unsafe.class.getDeclaredField("theUnsafe");
                field.setAccessible(true);
                Unsafe unsafe = (Unsafe)field.get(null);
                long handlers = unsafe.objectFieldOffset(ModularURLHandler.class.getDeclaredField("handlers"));
                Map object = (Map)unsafe.getObject(ModularURLHandler.INSTANCE, handlers);
                HashMap<String, ChatimageURLStreamHandlerFactory.ChatimageURLStreamHandler> eMap = new HashMap<String, ChatimageURLStreamHandlerFactory.ChatimageURLStreamHandler>(object);
                eMap.put("ci", new ChatimageURLStreamHandlerFactory.ChatimageURLStreamHandler());
                unsafe.getAndSetObject(ModularURLHandler.INSTANCE, handlers, eMap);
                logger.warn("Add protocol with Unsafe,this is unsafe!");
            }
            catch (Throwable ex) {
                GLOBAL_PROTOCOL = false;
                ex.printStackTrace();
                logger.error("Failed to add ci protocol!Using default!");
            }
        }
    }

    private void registerScreens(RegisterMenuScreensEvent event) {
    }
}

