/*
 * Decompiled with CFR 0.152.
 */
package org.eu.hanana.reimu.chatimage.core;

import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.resources.ResourceLocation;
import org.eu.hanana.reimu.chatimage.core.ChatImage;
import org.eu.hanana.reimu.chatimage.core.ImageStatus;

public class ClientChatImageTooltip
implements ClientTooltipComponent {
    private final ChatImage ci;

    public ClientChatImageTooltip(ChatImage chatImage) {
        this.ci = chatImage;
    }

    public int getWidth(Font font) {
        if (this.ci.status != ImageStatus.OK) {
            return 0;
        }
        return this.ci.w + 4;
    }

    public int getHeight(Font font) {
        if (this.ci.status != ImageStatus.OK) {
            return 0;
        }
        return this.ci.h + 4;
    }

    public void renderText(GuiGraphics guiGraphics, Font font, int x, int y) {
    }

    public void renderImage(Font font, int x, int y, int width, int height, GuiGraphics guiGraphics) {
        super.renderImage(font, x, y, width, height, guiGraphics);
        if (this.ci == null) {
            return;
        }
        ResourceLocation texture = this.ci.getTexture();
        if (texture == null) {
            return;
        }
        guiGraphics.blitInscribed(texture, x + 2, y + 2, this.ci.w, this.ci.h, this.ci.w, this.ci.h, true, true);
    }
}

