/*
 * Decompiled with CFR 0.152.
 */
package org.eu.hanana.reimu.chatimage;

import com.mojang.blaze3d.platform.NativeImage;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.resources.ResourceLocation;
import org.lwjgl.system.MemoryUtil;

public class ClientUtil {
    public static ResourceLocation uploadBufferedImage(BufferedImage image, String id) throws IOException {
        NativeImage nativeImage;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)image, "png", baos);
        byte[] bytes = baos.toByteArray();
        ByteBuffer buffer = MemoryUtil.memAlloc((int)bytes.length);
        buffer.put(bytes);
        buffer.flip();
        try {
            nativeImage = NativeImage.read((ByteBuffer)buffer);
        }
        catch (IOException e) {
            throw new IOException("\u65e0\u6cd5\u8bfb\u53d6NativeImage", e);
        }
        finally {
            MemoryUtil.memFree((Buffer)buffer);
        }
        ResourceLocation location = ResourceLocation.fromNamespaceAndPath((String)"chatimagemod", (String)("dynamic/icon/" + id));
        AtomicBoolean done = new AtomicBoolean(false);
        AtomicReference<Object> error = new AtomicReference<Object>(null);
        Minecraft.getInstance().schedule(() -> {
            try {
                DynamicTexture texture = new DynamicTexture(null, nativeImage);
                Minecraft.getInstance().getTextureManager().register(location, (AbstractTexture)texture);
            }
            catch (Throwable t) {
                error.set(t);
            }
            finally {
                done.set(true);
            }
        });
        while (!done.get()) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (error.get() != null) {
            throw new IOException("\u6ce8\u518c\u52a8\u6001\u7eb9\u7406\u5931\u8d25", error.get());
        }
        return location;
    }
}

