/*
 * Decompiled with CFR 0.152.
 */
package org.eu.hanana.reimu.chatimage;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.event.ServerChatEvent;
import org.eu.hanana.reimu.chatimage.Util;
import org.eu.hanana.reimu.chatimage.core.Actions;
import org.eu.hanana.reimu.chatimage.core.ChatImage;
import org.eu.hanana.reimu.chatimage.network.transporter.FtpManager;

public class EventHandler {
    @SubscribeEvent
    public void onClientDisconnected(ClientPlayerNetworkEvent.LoggingOut event) {
        ChatImage.clearCache();
        FtpManager.ftpDownloadPendingCallback.clear();
        FtpManager.ftpUploadPendingData.clear();
    }

    @SubscribeEvent
    public void onServerChat(ServerChatEvent event) {
        List flatList = event.getMessage().toFlatList();
        MutableComponent result = Component.empty();
        for (Component component : flatList) {
            String string = component.getString();
            List<String> parts = Util.splitByCiCodes(string);
            for (String part : parts) {
                if (part.startsWith("CI{")) {
                    try {
                        ChatImage.getChatImage(part);
                        if (FMLEnvironment.dist.isDedicatedServer()) {
                            ChatImage.clearCache();
                        }
                        result.append((Component)Component.translatable((String)"msg.ci.photo").setStyle(component.getStyle().withColor(ChatFormatting.GREEN).withHoverEvent((HoverEvent)new Actions.ShowImage((Component)Component.literal((String)part))).withClickEvent((ClickEvent)new Actions.ViewImage(part))));
                    }
                    catch (Throwable e) {
                        result.append((Component)Component.translatable((String)"msg.ci.photo").setStyle(Style.EMPTY.withColor(ChatFormatting.RED).withHoverEvent((HoverEvent)new HoverEvent.ShowText((Component)Component.translatable((String)"msg.ci.error_gen").append((Component)Component.literal((String)"\n")).append((Component)Component.literal((String)e.toString()))))));
                    }
                    continue;
                }
                result.append((Component)Component.literal((String)part).setStyle(component.getStyle()));
            }
        }
        event.setMessage((Component)result);
    }
}

