/*
 * Decompiled with CFR 0.152.
 */
package org.eu.hanana.reimu.chatimage;

import com.mojang.blaze3d.platform.NativeImage;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.IntBuffer;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import net.minecraft.util.ARGB;
import org.lwjgl.system.MemoryUtil;

public class Util {
    private static final String CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
    private static final SecureRandom SECURE_RANDOM = new SecureRandom();

    public static String randomString(int length) {
        StringBuilder sb = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            sb.append(CHARS.charAt(SECURE_RANDOM.nextInt(CHARS.length())));
        }
        return sb.toString();
    }

    public static String getFileExtension(File file) {
        if (file == null || file.isDirectory()) {
            return "/";
        }
        String name = file.getName();
        int dotIndex = name.lastIndexOf(46);
        if (dotIndex > 0 && dotIndex < name.length() - 1) {
            return name.substring(dotIndex + 1).toLowerCase();
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage iconToImage(Icon icon) {
        if (icon == null) {
            return null;
        }
        int w = icon.getIconWidth();
        int h = icon.getIconHeight();
        BufferedImage image = new BufferedImage(w, h, 2);
        Graphics2D g = image.createGraphics();
        try {
            icon.paintIcon(null, g, 0, 0);
        }
        finally {
            g.dispose();
        }
        return image;
    }

    public static List<String> splitByCiCodes(String text) {
        ArrayList<String> parts = new ArrayList<String>();
        int index = 0;
        while (index < text.length()) {
            int start = text.indexOf("CI{", index);
            if (start == -1) {
                parts.add(text.substring(index));
                break;
            }
            if (start > index) {
                parts.add(text.substring(index, start));
            }
            int braceLevel = 0;
            int end = -1;
            for (int i = start + 3; i < text.length(); ++i) {
                char c = text.charAt(i);
                if (c == '{') {
                    ++braceLevel;
                    continue;
                }
                if (c != '}') continue;
                if (braceLevel == 0) {
                    end = i;
                    break;
                }
                --braceLevel;
            }
            if (end == -1) {
                parts.add(text.substring(start));
                break;
            }
            parts.add(text.substring(start, end + 1));
            index = end + 1;
        }
        return parts;
    }

    public static byte[] mergeByteArrays(byte[][] byteArrays) {
        int totalLength = 0;
        for (byte[] array : byteArrays) {
            totalLength += array.length;
        }
        byte[] mergedArray = new byte[totalLength];
        int currentIndex = 0;
        for (byte[] array : byteArrays) {
            System.arraycopy(array, 0, mergedArray, currentIndex, array.length);
            currentIndex += array.length;
        }
        return mergedArray;
    }

    public static boolean deleteDirectory(File directory) {
        File[] files;
        if (!directory.exists()) {
            return false;
        }
        if (directory.isDirectory() && (files = directory.listFiles()) != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    Util.deleteDirectory(file);
                    continue;
                }
                file.delete();
            }
        }
        return directory.delete();
    }

    public static List<byte[]> splitByteArray(byte[] data, int chunkSize) {
        ArrayList<byte[]> chunks = new ArrayList<byte[]>();
        for (int i = 0; i < data.length; i += chunkSize) {
            int end = Math.min(i + chunkSize, data.length);
            byte[] chunk = new byte[end - i];
            System.arraycopy(data, i, chunk, 0, chunk.length);
            chunks.add(chunk);
        }
        return chunks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readFileToByteArray(File file) throws IOException {
        FileInputStream fis = null;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            int length;
            fis = new FileInputStream(file);
            byte[] buffer = new byte[1024];
            while ((length = fis.read(buffer)) != -1) {
                bos.write(buffer, 0, length);
            }
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
        finally {
            if (fis != null) {
                fis.close();
            }
            bos.close();
        }
    }

    public static BufferedImage convertToBufferedImage(NativeImage nativeImage) {
        if (nativeImage.format() != NativeImage.Format.RGBA) {
            throw new IllegalArgumentException("\u53ea\u652f\u6301 RGBA \u683c\u5f0f\u7684 NativeImage");
        }
        int width = nativeImage.getWidth();
        int height = nativeImage.getHeight();
        BufferedImage bufferedImage = new BufferedImage(width, height, 2);
        IntBuffer pixelBuffer = MemoryUtil.memIntBuffer((long)nativeImage.getPointer(), (int)(width * height));
        int[] pixels = new int[width * height];
        pixelBuffer.get(pixels);
        for (int i = 0; i < pixels.length; ++i) {
            pixels[i] = ARGB.fromABGR((int)pixels[i]);
        }
        bufferedImage.setRGB(0, 0, width, height, pixels, 0, width);
        return bufferedImage;
    }
}

