/*
 * Decompiled with CFR 0.152.
 */
package org.eu.hanana.reimu.chatimage.config;

import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class ChatImageConfig {
    public static Boolean remove_all;
    public static Boolean copy_base64;
    public static Integer maxFileSize;
    public static Integer maxPvWidth;
    public static Integer maxPvHeight;
    public static Boolean autoViewRaw;
    public static final ModConfigSpec commonSpec;
    public static final Common COMMON;
    public static final ModConfigSpec clientSpec;
    public static final Client CLIENT;

    @SubscribeEvent
    public static void onLoad(ModConfigEvent event) {
        if (event.getConfig().getType() == ModConfig.Type.CLIENT) {
            copy_base64 = (Boolean)ChatImageConfig.CLIENT.COPY_BASE64.get();
            maxPvWidth = (Integer)ChatImageConfig.CLIENT.MAX_PV_W.get();
            maxPvHeight = (Integer)ChatImageConfig.CLIENT.MAX_PV_H.get();
            autoViewRaw = (Boolean)ChatImageConfig.CLIENT.AUTO_VIEW_RAW.get();
        }
        if (event.getConfig().getType() == ModConfig.Type.COMMON) {
            remove_all = (Boolean)ChatImageConfig.COMMON.REMOVE_UPLOADS.get();
            maxFileSize = (Integer)ChatImageConfig.COMMON.MAX_FILE_SIZE.get();
        }
    }

    static {
        Pair specPair = new ModConfigSpec.Builder().configure(Common::new);
        commonSpec = (ModConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
        specPair = new ModConfigSpec.Builder().configure(Client::new);
        clientSpec = (ModConfigSpec)specPair.getRight();
        CLIENT = (Client)specPair.getLeft();
    }

    public static class Client {
        public final ModConfigSpec.BooleanValue COPY_BASE64;
        public final ModConfigSpec.BooleanValue AUTO_VIEW_RAW;
        public final ModConfigSpec.IntValue MAX_PV_W;
        public final ModConfigSpec.IntValue MAX_PV_H;

        Client(ModConfigSpec.Builder builder) {
            this.COPY_BASE64 = builder.comment("[CLIENT] Copy base64 data instead of ci code.").translation("cfg.ci.copy_base64").define("copy_base64", false);
            this.MAX_PV_W = builder.comment("[CLIENT] max preview width, 0 means infinty.").translation("cfg.ci.maxpvw").defineInRange("max_pv_w", 200, 0, 1000);
            this.MAX_PV_H = builder.comment("[CLIENT] max preview height, 0 means infinty.").translation("cfg.ci.maxpvh").defineInRange("max_pv_h", 200, 0, 1000);
            this.AUTO_VIEW_RAW = builder.comment("[CLIENT] max preview height, 0 means infinty.").translation("cfg.ci.maxpvh").define("auto_view_raw", true);
        }
    }

    public static class Common {
        public final ModConfigSpec.BooleanValue REMOVE_UPLOADS;
        public final ModConfigSpec.IntValue MAX_FILE_SIZE;

        Common(ModConfigSpec.Builder builder) {
            this.MAX_FILE_SIZE = builder.comment("The max file size of upload image (byte).").translation("cfg.ci.maxsize").defineInRange("maxsize", 0x300000, 0, 0x1400000);
            this.REMOVE_UPLOADS = builder.comment("Delete all uploaded image when server restart.").translation("cfg.ci.remove_all").define("remove_uploads", true);
        }
    }
}

