/*
 * Decompiled with CFR 0.152.
 */
package org.eu.hanana.reimu.chatimage.core;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.Expose;
import com.mojang.blaze3d.platform.NativeImage;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.imageio.ImageIO;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.thread.BlockableEventLoop;
import net.neoforged.fml.loading.FMLEnvironment;
import org.eu.hanana.reimu.chatimage.ChatimageMod;
import org.eu.hanana.reimu.chatimage.core.ChatimageURLStreamHandlerFactory;
import org.eu.hanana.reimu.chatimage.core.ClientReflect;
import org.eu.hanana.reimu.chatimage.core.ImageStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.system.MemoryUtil;

public class ChatImage {
    public static final Map<String, ChatImage> BufferedChatImage = new HashMap<String, ChatImage>();
    public static final Map<String, ResourceLocation> BufferedTexture = new HashMap<String, ResourceLocation>();
    public URL url;
    public int w;
    public int h;
    public int rawW;
    public int rawH;
    public String info;
    public boolean currentRaw;
    public ImageStatus status = ImageStatus.NEW;
    private static Class<ClientReflect> clientRClass;

    protected ChatImage() {
    }

    protected ChatImage(String url, int w, int h, String info) throws MalformedURLException {
        this();
        if (!ChatimageMod.GLOBAL_PROTOCOL) {
            if (url.startsWith("ci:")) {
                this.url = URL.of(URI.create(url), new ChatimageURLStreamHandlerFactory.ChatimageURLStreamHandler());
                ChatimageMod.logger.warn("The ci protocol was not added to system.May because by an error.Failed to a stable mode.");
            } else {
                this.url = URI.create(url).toURL();
            }
        } else {
            this.url = URI.create(url).toURL();
        }
        this.w = w;
        this.h = h;
        this.info = info;
    }

    public static ChatImage getChatImage(String ciCode) throws Throwable {
        if (!BufferedChatImage.containsKey(ciCode)) {
            ChatImageData chatImageData = new ChatImageData(ciCode);
            BufferedChatImage.put(ciCode, new ChatImage(chatImageData.url, chatImageData.w, chatImageData.h, chatImageData.info));
        }
        return BufferedChatImage.get(ciCode);
    }

    public static void clearCache() {
        if (FMLEnvironment.dist.isClient()) {
            try {
                clientRClass.getMethod("clearCache", new Class[0]).invoke(null, new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        BufferedTexture.clear();
        BufferedChatImage.clear();
        ChatimageMod.logger.info("cached cleared");
    }

    public String getTextureId() {
        return Integer.toHexString(this.url.toString().hashCode()) + "@" + this.w + "," + this.h;
    }

    public boolean viewRaw(boolean isRaw) {
        if (this.status != ImageStatus.OK) {
            return false;
        }
        if (isRaw == this.currentRaw) {
            return false;
        }
        if (this.getTexture() != null) {
            ResourceLocation texId = this.getTexture();
            try {
                clientRClass.getMethod("closeTexture", ResourceLocation.class, String.class).invoke(null, texId, this.getTextureId());
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        this.w ^= this.rawW;
        this.rawW = this.w ^ this.rawW;
        this.w ^= this.rawW;
        this.h ^= this.rawH;
        this.rawH = this.h ^ this.rawH;
        this.h ^= this.rawH;
        this.currentRaw = isRaw;
        this.status = ImageStatus.NEW;
        return true;
    }

    @Nullable
    public ResourceLocation getTexture() {
        if (this.status == ImageStatus.OK && BufferedTexture.containsKey(this.getTextureId())) {
            return BufferedTexture.get(this.getTextureId());
        }
        if (this.status == ImageStatus.NEW) {
            new Thread(this::downloadImg).start();
        }
        return null;
    }

    public void downloadImg() {
        block14: {
            this.status = ImageStatus.WAIT;
            try {
                NativeImage read;
                int bytesRead;
                URLConnection urlConnection = this.url.openConnection();
                BufferedInputStream inputStream = new BufferedInputStream(urlConnection.getInputStream());
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                byte[] dataBuffer = new byte[1024];
                while ((bytesRead = ((InputStream)inputStream).read(dataBuffer)) != -1) {
                    outputStream.write(dataBuffer, 0, bytesRead);
                }
                byte[] abyte = outputStream.toByteArray();
                BufferedImage image = ImageIO.read(new ByteArrayInputStream(abyte));
                if (!this.currentRaw) {
                    this.rawW = image.getWidth();
                    this.rawH = image.getHeight();
                }
                BufferedImage outputImage = new BufferedImage(this.w, this.h, image.getType());
                Graphics2D g2d = outputImage.createGraphics();
                g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                g2d.drawImage(image, 0, 0, this.w, this.h, null);
                g2d.dispose();
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)outputImage, "png", byteArrayOutputStream);
                abyte = byteArrayOutputStream.toByteArray();
                ByteBuffer bytebuffer = MemoryUtil.memAlloc((int)abyte.length);
                try {
                    read = NativeImage.read((ByteBuffer)bytebuffer.put(abyte).flip());
                }
                catch (IOException ioexception) {
                    throw new IOException(ioexception);
                }
                finally {
                    MemoryUtil.memFree((Buffer)bytebuffer);
                }
                ResourceLocation resourcelocation = ResourceLocation.fromNamespaceAndPath((String)"chatimage", (String)("dynamic/ci/" + BufferedTexture.size()));
                AtomicBoolean finish = new AtomicBoolean(false);
                AtomicReference<Object> error = new AtomicReference<Object>(null);
                ((BlockableEventLoop)clientRClass.getMethod("getClientBlockableEventLoop", new Class[0]).invoke(null, new Object[0])).schedule(() -> {
                    try {
                        clientRClass.getMethod("registerDynamicTexture", ResourceLocation.class, NativeImage.class).invoke(null, resourcelocation, read);
                        BufferedTexture.put(this.getTextureId(), resourcelocation);
                        this.status = ImageStatus.OK;
                        finish.set(true);
                    }
                    catch (Throwable throwable) {
                        error.set(throwable);
                        finish.set(true);
                    }
                });
                while (!finish.get()) {
                    Thread.sleep(100L);
                }
                if (error.get() != null) {
                    throw (Throwable)error.get();
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
                ChatimageMod.logger.error((Object)e);
                this.status = ImageStatus.ERROR;
                if (!FMLEnvironment.dist.isClient()) break block14;
                try {
                    clientRClass.getMethod("sendToast", Component.class, Component.class).invoke(null, Component.literal((String)"ERROR/\u9519\u8bef"), Component.literal((String)e.toString()));
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
    }

    static {
        if (FMLEnvironment.dist.isClient()) {
            try {
                clientRClass = Class.forName("org.eu.hanana.reimu.chatimage.core.ClientReflect");
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class ChatImageData {
        @Expose
        public String url;
        @Expose
        public int w;
        @Expose
        public int h;
        @Expose
        public String info;
        private final Gson gson = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().create();

        public ChatImageData(String url, int w, int h, String info) {
            this.url = url;
            this.w = w;
            this.h = h;
            this.info = info;
        }

        public ChatImageData(ChatImage ci) {
            this(ci.url.toString(), ci.w, ci.h, ci.info);
        }

        public ChatImageData(String ciCode) {
            ciCode = ciCode.substring(2);
            ChatImageData chatImageData = (ChatImageData)this.gson.fromJson(ciCode, ChatImageData.class);
            this.url = chatImageData.url;
            this.w = chatImageData.w;
            this.h = chatImageData.h;
            this.info = chatImageData.info;
        }

        public String toString() {
            return this.toCiCode();
        }

        @NotNull
        public static String[] getCiCodes(String longStr) {
            int start;
            ArrayList<String> results = new ArrayList<String>();
            int index = 0;
            while (index < longStr.length() && (start = longStr.indexOf("CI{", index)) != -1) {
                int braceLevel = 0;
                int end = -1;
                for (int i = start + 3; i < longStr.length(); ++i) {
                    char c = longStr.charAt(i);
                    if (c == '{') {
                        ++braceLevel;
                        continue;
                    }
                    if (c != '}') continue;
                    if (braceLevel == 0) {
                        end = i;
                        break;
                    }
                    --braceLevel;
                }
                if (end == -1) break;
                results.add(longStr.substring(start, end + 1));
                index = end + 1;
            }
            return results.isEmpty() ? new String[]{} : results.toArray(new String[0]);
        }

        public String toCiCode() {
            return "CI" + this.gson.toJson((Object)this);
        }

        public void setImageSizeRaw() throws IOException {
            try (InputStream inputStream = URI.create(this.url).toURL().openConnection().getInputStream();){
                BufferedImage read = ImageIO.read(inputStream);
                this.w = read.getWidth();
                this.h = read.getHeight();
            }
        }
    }
}

