/*
 * Decompiled with CFR 0.152.
 */
package org.eu.hanana.reimu.chatimage.core;

import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.resources.ResourceLocation;
import org.eu.hanana.reimu.chatimage.ChatimageMod;
import org.eu.hanana.reimu.chatimage.config.ChatImageConfig;
import org.eu.hanana.reimu.chatimage.core.ChatImage;
import org.eu.hanana.reimu.chatimage.core.ImageStatus;

public class ClientChatImageTooltip
implements ClientTooltipComponent {
    private final ChatImage ci;
    public int w;
    public int h;

    public ClientChatImageTooltip(ChatImage chatImage) {
        this.ci = chatImage;
        this.w = Math.min(this.ci.w, ChatImageConfig.maxPvHeight);
        this.h = Math.min(this.ci.h, ChatImageConfig.maxPvHeight);
    }

    public int getWidth(Font font) {
        if (this.ci.status != ImageStatus.OK) {
            return 0;
        }
        return this.w + 4;
    }

    public int getHeight(Font font) {
        if (this.ci.status != ImageStatus.OK) {
            return 0;
        }
        return this.h + 4;
    }

    public void renderText(GuiGraphics guiGraphics, Font font, int x, int y) {
    }

    public void renderImage(Font font, int x, int y, int width, int height, GuiGraphics guiGraphics) {
        super.renderImage(font, x, y, width, height, guiGraphics);
        if (this.ci == null) {
            return;
        }
        ResourceLocation texture = this.ci.getTexture();
        if (texture == null) {
            return;
        }
        try {
            guiGraphics.blitInscribed(texture, x + 2, y + 2, this.w, this.h, this.w, this.h, true, true);
        }
        catch (Exception e) {
            ChatimageMod.logger.info("Detected a unexpected bug fixed", (Throwable)e);
            this.ci.viewRaw(false);
        }
    }
}

