/*
 * Decompiled with CFR 0.152.
 */
package org.eu.hanana.reimu.chatimage.network;

import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.handling.IPayloadHandler;
import org.eu.hanana.reimu.chatimage.network.FileTransportPayload;
import org.eu.hanana.reimu.chatimage.network.transporter.FtpInputStream;
import org.eu.hanana.reimu.chatimage.network.transporter.FtpManager;
import org.eu.hanana.reimu.chatimage.network.transporter.PendingData;
import org.jetbrains.annotations.NotNull;

public class FileTransportHandle
implements IPayloadHandler<FileTransportPayload> {
    public void handle(@NotNull FileTransportPayload payload, @NotNull IPayloadContext context) {
        if (payload.op().equals("tr_start") && !FtpManager.ftpDownloadPendingData.containsKey(payload.key())) {
            PendingData pendingData = new PendingData();
            pendingData.key = payload.key();
            pendingData.send = false;
            pendingData.startTime = System.nanoTime();
            pendingData.ftpInputStream = new FtpInputStream(pendingData);
            if (!context.player().isLocalPlayer()) {
                pendingData.ftpInputStream.player = (ServerPlayer)context.player();
            }
            FtpManager.ftpDownloadPendingData.put(payload.key(), pendingData);
        }
        try {
            if (payload.op().startsWith("tr_")) {
                FtpManager.ftpDownloadPendingData.get((Object)payload.key()).ftpInputStream.receivedPacket(payload, context);
            } else if (payload.op().startsWith("rt_")) {
                FtpManager.ftpUploadPendingData.get((Object)payload.key()).ftpInputStream.receivedPacket(payload, context);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

