/*
 * Decompiled with CFR 0.152.
 */
package org.eu.hanana.reimu.chatimage.network.transporter;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Tuple;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eu.hanana.reimu.chatimage.ChatimageMod;
import org.eu.hanana.reimu.chatimage.Util;
import org.eu.hanana.reimu.chatimage.config.ChatImageConfig;
import org.eu.hanana.reimu.chatimage.network.FileTransportPayload;
import org.eu.hanana.reimu.chatimage.network.transporter.FtpManager;
import org.eu.hanana.reimu.chatimage.network.transporter.PendingData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FtpInputStream
extends InputStream
implements Runnable {
    public static final String TR = "tr_";
    public static final String RT = "rt_";
    public static final String TR_START = "tr_start";
    public static final String RT_START = "rt_start";
    public static final String TR_DATA = "tr_data";
    public static final String TR_END = "tr_end";
    public static final String RT_NEXT = "rt_next";
    public static final String RT_CALLBACK = "rt_callbackReceiver";
    private static final Logger log = LogManager.getLogger(FtpInputStream.class);
    private final AtomicLong totalBytesReceived = new AtomicLong(0L);
    private final BlockingQueue<byte[]> queue = new LinkedBlockingQueue<byte[]>();
    private final byte[] data;
    private final PendingData pendingData;
    private boolean closed;
    private byte[] currentChunk = null;
    private int pos = 0;
    public Consumer<Tuple<String, FtpInputStream>> callbackReceiver = ftpInputStream -> {
        try (FtpInputStream ftpInputStream2 = this;){
            Files.copy((InputStream)ftpInputStream.getB(), Path.of("chatimage", (String)ftpInputStream.getA()), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    };
    public Consumer<Tuple<String, FtpInputStream>> callbackTransfer;
    @Nullable
    public ServerPlayer player;

    public FtpInputStream(byte[] data, @Nullable ServerPlayer player, String key) {
        this.callbackTransfer = ftpInputStream -> {};
        this.data = data;
        this.player = player;
        this.closed = false;
        this.pendingData = new PendingData();
        this.pendingData.key = key;
        this.pendingData.ftpInputStream = this;
        this.pendingData.startTime = System.nanoTime();
        this.pendingData.send = true;
        FtpManager.ftpUploadPendingData.put(this.pendingData.key, this.pendingData);
    }

    public FtpInputStream(byte[] data, @Nullable ServerPlayer player) {
        this(data, player, Util.randomString(50));
    }

    public FtpInputStream(PendingData data1) {
        this.callbackTransfer = ftpInputStream -> {};
        this.data = null;
        this.pendingData = data1;
        this.player = null;
    }

    @Override
    public void run() {
        if (this.data.length == 0) {
            return;
        }
        this.sendPacket(new FileTransportPayload(TR_START, this.pendingData.key, 0, new byte[0], ""));
    }

    public void receivedPacket(@NotNull FileTransportPayload payload, @NotNull IPayloadContext context) throws InterruptedException, IOException {
        String op = payload.op();
        ChatimageMod.logger.debug("Received Network FTP, {}", (Object)op);
        if (op.equals(TR_START)) {
            if (FtpManager.ftpDownloadPendingCallback.containsKey(this.pendingData.key)) {
                this.callbackReceiver = FtpManager.ftpDownloadPendingCallback.get(this.pendingData.key);
                FtpManager.ftpDownloadPendingCallback.remove(this.pendingData.key);
            }
            this.sendPacket(new FileTransportPayload(RT_START, this.pendingData.key, 0, new byte[0], ""));
        } else if (op.equals(RT_START)) {
            this.feed(this.data);
            this.close();
            this.sendPacket(new FileTransportPayload(TR_DATA, this.pendingData.key, 0, this.getNextData(30720), ""));
        } else if (op.equals(TR_DATA)) {
            this.feed(payload.payload());
            if (this.totalBytesReceived.get() > (long)ChatImageConfig.maxFileSize.intValue()) {
                this.sendPacket(new FileTransportPayload(RT_CALLBACK, this.pendingData.key, 0, new byte[0], "File Too Big!"));
            } else {
                this.sendPacket(new FileTransportPayload(RT_NEXT, this.pendingData.key, 0, new byte[0], ""));
            }
        } else if (op.equals(RT_NEXT)) {
            byte[] data = this.getNextData(30720);
            if (data.length == 0) {
                this.sendPacket(new FileTransportPayload(TR_END, this.pendingData.key, 0, new byte[0], ""));
            } else {
                this.sendPacket(new FileTransportPayload(TR_DATA, this.pendingData.key, 0, data, ""));
            }
        } else if (op.equals(TR_END)) {
            this.close();
            File dir = new File("chatimage");
            dir.mkdirs();
            Path outputPath = Files.createTempFile(dir.toPath(), "upload-", ".tmp", new FileAttribute[0]);
            this.callbackReceiver.accept((Tuple<String, FtpInputStream>)new Tuple((Object)outputPath.getFileName().toString(), (Object)this));
            this.sendPacket(new FileTransportPayload(RT_CALLBACK, this.pendingData.key, 0, new byte[0], outputPath.getFileName().toString()));
            FtpManager.ftpDownloadPendingData.remove(this.pendingData.key);
            log.info("Receive completed!");
        } else if (op.equals(RT_CALLBACK)) {
            FtpManager.ftpUploadPendingData.remove(this.pendingData.key);
            this.callbackTransfer.accept((Tuple<String, FtpInputStream>)new Tuple((Object)payload.extra(), (Object)this));
            log.info("Transfer completed! remote: {}", (Object)payload.extra());
        }
    }

    public byte[] getNextData(int length) throws IOException {
        byte[] buffer = new byte[length];
        int readLen = this.read(buffer);
        if (readLen == -1) {
            return new byte[0];
        }
        if (readLen == buffer.length) {
            return buffer;
        }
        byte[] exact = new byte[readLen];
        System.arraycopy(buffer, 0, exact, 0, readLen);
        return exact;
    }

    private void sendPacket(CustomPacketPayload payload) {
        if (this.player == null) {
            try {
                Class.forName("net.neoforged.neoforge.client.network.ClientPacketDistributor").getMethod("sendToServer", CustomPacketPayload.class, CustomPacketPayload[].class).invoke(null, payload, new CustomPacketPayload[0]);
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        } else {
            PacketDistributor.sendToPlayer((ServerPlayer)this.player, (CustomPacketPayload)payload, (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public boolean isToServer() {
        return this.player == null;
    }

    public void feed(byte[] data) {
        if (!this.closed && data != null && data.length > 0) {
            this.queue.offer(data);
            this.totalBytesReceived.addAndGet(data.length);
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.currentChunk == null || this.pos >= this.currentChunk.length) {
            try {
                this.currentChunk = this.queue.poll(5L, TimeUnit.SECONDS);
                this.pos = 0;
                if (this.currentChunk.length == 0) {
                    return -1;
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IOException("Interrupted while waiting for network data", e);
            }
        }
        int remaining = this.currentChunk.length - this.pos;
        int toRead = Math.min(len, remaining);
        System.arraycopy(this.currentChunk, this.pos, b, off, toRead);
        this.pos += toRead;
        return toRead;
    }

    @Override
    public int available() {
        int available = this.currentChunk != null ? this.currentChunk.length - this.pos : 0;
        for (byte[] chunk : this.queue) {
            available += chunk.length;
        }
        return available;
    }

    @Override
    public void close() {
        this.closed = true;
        this.queue.offer(new byte[0]);
    }

    @Override
    public int read() throws IOException {
        byte[] buf = new byte[1];
        int n = this.read(buf, 0, 1);
        return n == -1 ? -1 : buf[0] & 0xFF;
    }
}

