/*
 * Decompiled with CFR 0.152.
 */
package org.eu.hanana.reimu.chatimage.screen;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.swing.filechooser.FileSystemView;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.fml.loading.FMLEnvironment;
import org.eu.hanana.reimu.chatimage.ClientUtil;
import org.eu.hanana.reimu.chatimage.Util;
import org.eu.hanana.reimu.chatimage.screen.widget.TextListWidget;

public class FileScreen
extends Screen {
    public static final SystemToast.SystemToastId CHATIMAGE_TOAST_ID = new SystemToast.SystemToastId(2000L);
    public static final ResourceLocation DEMO_BACKGROUND_LOCATION = ResourceLocation.withDefaultNamespace((String)"textures/gui/demo_background.png");
    public Runnable afterInit = () -> {};
    public Consumer<String> callback = s -> {};
    private Screen parent;
    public EditBox filenameTextField;
    public EditBox pathTextField;
    private TextListWidget selectList;
    private final Map<String, ResourceLocation> icons = new HashMap<String, ResourceLocation>();
    private Thread iconThread;

    public FileScreen() {
        super((Component)Component.translatable((String)"gui.ci.file"));
    }

    protected void init() {
        int x = this.width / 2;
        int y = this.height / 2;
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"X"), button -> this.onClose()).bounds(x + 103, y - 77, 14, 14).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"->"), button -> this.refresh()).bounds(x + 50, y - 65, 20, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"^"), button -> {
            File file = new File(this.pathTextField.getValue());
            this.pathTextField.setValue(file.getParent());
            this.refresh();
        }).bounds(x + 73, y - 65, 20, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"gui.ok"), button -> this.selected()).bounds(x + 90, y + 58, 28, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"gui.cancel"), button -> this.onClose()).bounds(x + 55, y + 58, 28, 20).build());
        this.filenameTextField = new EditBox(this.font, x - 100, y + 58, 130, 20, (Component)Component.empty());
        this.addRenderableWidget((GuiEventListener)this.filenameTextField);
        this.pathTextField = new EditBox(this.font, x - 80, y - 65, 130, 20, (Component)Component.empty());
        this.addRenderableWidget((GuiEventListener)this.pathTextField);
        this.selectList = new TextListWidget(this, 220, y - 40, y + 55){

            @Override
            public void onSelect(TextListWidget.TextEntry entry) {
                super.onSelect(entry);
                if (FileScreen.this.filenameTextField.getValue().equals(entry.text)) {
                    FileScreen.this.doubleClicked(entry.text);
                }
                FileScreen.this.filenameTextField.setValue(entry.text);
            }
        };
        this.addRenderableWidget((GuiEventListener)this.selectList);
        this.selectList.setX(x - 110);
        this.pathTextField.setMaxLength(Integer.MAX_VALUE);
        this.filenameTextField.setMaxLength(Integer.MAX_VALUE);
        this.pathTextField.setValue(new File(".").getAbsolutePath());
        this.refresh();
        this.afterInit.run();
    }

    public void onFilesDrop(List<Path> packs) {
        super.onFilesDrop(packs);
        Path first = packs.getFirst();
        File file = first.toFile();
        String parent1 = file.getParent();
        this.pathTextField.setValue(parent1);
        this.filenameTextField.setValue(file.getName());
        this.selected();
    }

    private void selected() {
        if (this.isGettingIcons()) {
            return;
        }
        File file = new File(new File(this.pathTextField.getValue()), this.filenameTextField.getValue());
        if (file.isDirectory()) {
            try {
                this.pathTextField.setValue(file.getCanonicalFile().getAbsolutePath());
            }
            catch (IOException e) {
                this.pathTextField.setValue(file.getAbsolutePath());
            }
            this.refresh();
            this.getMinecraft().schedule(() -> this.filenameTextField.setValue(""));
        } else {
            if (!file.exists()) {
                this.getMinecraft().getToastManager().addToast((Toast)new SystemToast(CHATIMAGE_TOAST_ID, (Component)Component.translatable((String)"msg.ci.file_not_found"), (Component)Component.empty()));
                return;
            }
            this.callback.accept(file.getAbsolutePath());
            this.onClose();
        }
    }

    private void doubleClicked(String text) {
        this.selected();
    }

    public void refresh() {
        this.refresh(this.pathTextField.getValue());
    }

    public void refresh(String value) {
        if (this.iconThread != null && this.iconThread.isAlive()) {
            return;
        }
        File file = new File(value);
        if (!file.exists() || !file.isDirectory()) {
            this.getMinecraft().getToastManager().addToast((Toast)new SystemToast(SystemToast.SystemToastId.WORLD_BACKUP, this.title, (Component)Component.translatable((String)"msg.ci.file_not_found")));
            return;
        }
        this.selectList.clearEntries();
        this.pathTextField.setValue(file.getAbsolutePath());
        this.iconThread = new Thread(() -> {
            File[] files = file.listFiles();
            if (files == null) {
                files = new File[]{};
            }
            Arrays.sort(files, (a, b) -> {
                if (a.isDirectory() && !b.isDirectory()) {
                    return -1;
                }
                if (!a.isDirectory() && b.isDirectory()) {
                    return 1;
                }
                return a.getName().compareToIgnoreCase(b.getName());
            });
            ArrayList<TextListWidget.TextEntry> tls = new ArrayList<TextListWidget.TextEntry>();
            tls.add(this.selectList.newEntry("../"));
            for (File s : files) {
                tls.add(this.selectList.newEntry(s.getName() + (s.isDirectory() ? "/" : "")));
            }
            File[] finalFiles = files;
            for (File file1 : finalFiles) {
                String ext = Util.getFileExtension(file1);
                if (this.icons.containsKey(ext)) continue;
                BufferedImage bufferedImage = Util.iconToImage(FileSystemView.getFileSystemView().getSystemIcon(file1));
                ResourceLocation resourceLocation = null;
                try {
                    resourceLocation = ClientUtil.uploadBufferedImage(bufferedImage, ext);
                    this.icons.put(ext, resourceLocation);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                for (TextListWidget.TextEntry tl : tls) {
                    tl.icon = this.icons.get(Util.getFileExtension(new File(file, tl.text)));
                }
            }
            for (TextListWidget.TextEntry tl : tls) {
                tl.icon = this.icons.get(Util.getFileExtension(new File(file, tl.text)));
            }
            tls.forEach(this.selectList::addEntry);
        });
        this.selectList.setScrollAmount(0.0);
        this.iconThread.start();
    }

    public boolean isGettingIcons() {
        return this.iconThread != null && this.iconThread.isAlive();
    }

    public void onClose() {
        if (this.iconThread != null && this.iconThread.isAlive()) {
            return;
        }
        for (ResourceLocation value : this.icons.values()) {
            AbstractTexture texture;
            if (!FMLEnvironment.dist.isClient() || !((texture = Minecraft.getInstance().getTextureManager().getTexture(value)) instanceof DynamicTexture)) continue;
            DynamicTexture dynamicTexture = (DynamicTexture)texture;
            dynamicTexture.close();
        }
        if (this.parent != null) {
            this.getMinecraft().screen = this.parent;
            return;
        }
        super.onClose();
    }

    public void renderBackground(GuiGraphics p_283391_, int p_295532_, int p_296277_, float p_295918_) {
        super.renderBackground(p_283391_, p_295532_, p_296277_, p_295918_);
        int i = (this.width - 248) / 2;
        int j = (this.height - 166) / 2;
        p_283391_.blit(RenderPipelines.GUI_TEXTURED, DEMO_BACKGROUND_LOCATION, i, j, 0.0f, 0.0f, 248, 166, 256, 256);
    }

    public void render(GuiGraphics p_281247_, int p_281844_, int p_283693_, float p_281842_) {
        super.render(p_281247_, p_281844_, p_283693_, p_281842_);
        int i = (this.width - 248) / 2 + 10;
        int j = (this.height - 166) / 2 + 8;
        int x = this.width / 2;
        int y = this.height / 2;
        p_281247_.drawString(this.font, this.title, i, j, -14737633, false);
        if (this.isGettingIcons()) {
            p_281247_.drawString(this.font, (Component)Component.translatable((String)"gui.ci.working"), i + 60, j, -58083, false);
        } else {
            p_281247_.drawString(this.font, (Component)Component.translatable((String)"gui.ci.drag_tip"), i + 60, j, -14681059, false);
        }
        p_281247_.drawString(this.font, (Component)Component.translatable((String)"gui.ci.path"), i + 3, j + 15, -14737633, false);
    }

    public FileScreen setParent(Screen screen) {
        this.parent = screen;
        return this;
    }
}

