/*
 * Decompiled with CFR 0.152.
 */
package org.eu.hanana.reimu.chatimage.screen;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.util.Base64;
import javax.imageio.ImageIO;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.eu.hanana.reimu.chatimage.ChatimageMod;
import org.eu.hanana.reimu.chatimage.Util;
import org.eu.hanana.reimu.chatimage.config.ChatImageConfig;
import org.eu.hanana.reimu.chatimage.core.ChatImage;

public class ViewImageScreen
extends Screen {
    public static final SystemToast.SystemToastId CHATIMAGE_TOAST_ID = new SystemToast.SystemToastId(2000L);
    public static final ResourceLocation DEMO_BACKGROUND_LOCATION = ResourceLocation.withDefaultNamespace((String)"textures/gui/demo_background.png");
    private ChatImage image;
    protected float img_x;
    protected float img_y;
    protected float scale = 1.0f;
    private boolean dragging;
    private Button btnRaw;

    public ViewImageScreen(String value) {
        super((Component)Component.translatable((String)"gui.ci.info"));
        try {
            this.image = ChatImage.getChatImage(value);
        }
        catch (Throwable e) {
            ChatimageMod.logger.error("Can not gen ci instance.", e);
        }
    }

    protected void init() {
        int x = this.width / 2;
        int y = this.height / 2;
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"X"), button -> this.onClose()).bounds(x + 103, y - 77, 14, 14).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"+"), button -> this.scale += 3080.25f / (float)this.image.w / (float)this.image.h).bounds(x - 80, y - 66, 15, 15).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"O"), button -> this.reset()).bounds(x - 60, y - 66, 15, 15).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"-"), button -> this.scale -= 3080.25f / (float)this.image.w / (float)this.image.h).bounds(x - 40, y - 66, 15, 15).build());
        this.btnRaw = Button.builder((Component)Component.translatable((String)"gui.ci.raw"), button -> this.viewRaw()).bounds(x - 20, y - 66, 45, 15).build();
        this.addRenderableWidget((GuiEventListener)this.btnRaw);
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"chat.copy"), (Button.OnPress)new Button.OnPress(){

            public void onPress(Button button) {
                if (ChatImageConfig.copy_base64.booleanValue()) {
                    ResourceLocation texture = ViewImageScreen.this.image.getTexture();
                    if (texture == null) {
                        return;
                    }
                    try {
                        DynamicTexture texture1 = (DynamicTexture)ViewImageScreen.this.getMinecraft().getTextureManager().getTexture(texture);
                        BufferedImage bufferedImage = Util.convertToBufferedImage(texture1.getPixels());
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        ImageIO.write((RenderedImage)bufferedImage, "PNG", baos);
                        byte[] imageData = baos.toByteArray();
                        ViewImageScreen.this.getMinecraft().keyboardHandler.setClipboard("image/png;base64," + Base64.getEncoder().encodeToString(imageData));
                    }
                    catch (Exception e) {
                        ChatimageMod.logger.error((Object)e);
                    }
                } else {
                    ViewImageScreen.this.getMinecraft().keyboardHandler.setClipboard(new ChatImage.ChatImageData(ViewImageScreen.this.image).toString());
                }
            }
        }).bounds(x + 30, y - 66, 40, 15).build());
        this.reset();
        if (ChatImageConfig.autoViewRaw.booleanValue()) {
            this.viewRaw();
        }
    }

    private void viewRaw() {
        this.image.viewRaw(true);
        this.removeWidget((GuiEventListener)this.btnRaw);
        this.reset();
    }

    public void onClose() {
        super.onClose();
        this.image.viewRaw(false);
    }

    public boolean mouseScrolled(double pMouseX, double pMouseY, double pScrollX, double pScrollY) {
        this.scale += (float)(pScrollY * 0.25 * 111.0 * 111.0 / (double)this.image.w / (double)this.image.h);
        return super.mouseScrolled(pMouseX, pMouseY, pScrollX, pScrollY);
    }

    private void reset() {
        int x = this.width / 2;
        int y = this.height / 2;
        this.scale = (float)ViewImageScreen.getBestScale(this.image.w, this.image.h, 220, 120);
        this.img_x = (float)(x - 110) + (220.0f - (float)this.image.w * this.scale) / 2.0f;
        this.img_y = (float)(y - 50) + (120.0f - (float)this.image.h * this.scale) / 2.0f;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        boolean flag = false;
        int x = this.width / 2;
        int y = this.height / 2;
        if (mouseX >= (double)(x - 110) && mouseX <= (double)(x + 110) && mouseY >= (double)(y - 50) && mouseY <= (double)(y + 50)) {
            flag = true;
            this.dragging = true;
        }
        return super.mouseClicked(mouseX, mouseY, button) || flag;
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        this.dragging = false;
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        if (this.dragging) {
            this.img_x += (float)pDragX;
            this.img_y += (float)pDragY;
        }
        return super.mouseDragged(pMouseX, pMouseY, pButton, pDragX, pDragY);
    }

    public void renderBackground(GuiGraphics pGuiGraphics, int p_295532_, int p_296277_, float p_295918_) {
        super.renderBackground(pGuiGraphics, p_295532_, p_296277_, p_295918_);
        int x = this.width / 2;
        int y = this.height / 2;
        int i = (this.width - 248) / 2;
        int j = (this.height - 166) / 2;
        pGuiGraphics.blit(RenderPipelines.GUI_TEXTURED, DEMO_BACKGROUND_LOCATION, i, j, 0.0f, 0.0f, 248, 166, 256, 256);
        pGuiGraphics.enableScissor(x - 110, y - 50, x + 110, y + 70);
        pGuiGraphics.fill(0, 0, this.width, this.height, -1275068416);
        ResourceLocation texture = this.image.getTexture();
        pGuiGraphics.pose().pushMatrix();
        pGuiGraphics.pose().translate(this.img_x, this.img_y);
        pGuiGraphics.pose().scale(this.scale, this.scale);
        if (texture != null) {
            pGuiGraphics.blitInscribed(texture, 0, 0, this.image.w, this.image.h, this.image.w, this.image.h, true, true);
        }
        pGuiGraphics.pose().popMatrix();
        pGuiGraphics.disableScissor();
    }

    public static double getBestScale(int w, int h, int w1, int h1) {
        if (w <= 0 || h <= 0) {
            throw new IllegalArgumentException("\u56fe\u7247\u5bbd\u9ad8\u5fc5\u987b\u5927\u4e8e0");
        }
        double sx = (double)w1 / (double)w;
        double sy = (double)h1 / (double)h;
        return Math.min(sx, sy);
    }

    public void render(GuiGraphics p_281247_, int p_281844_, int p_283693_, float p_281842_) {
        super.render(p_281247_, p_281844_, p_283693_, p_281842_);
        int i = (this.width - 248) / 2 + 10;
        int j = (this.height - 166) / 2 + 8;
        int x = this.width / 2;
        int y = this.height / 2;
        p_281247_.drawString(this.font, (Component)this.title.copy().append((Component)Component.translatable((String)("msg.ci." + String.valueOf((Object)this.image.status)))), i, j, -14737633, false);
        p_281247_.drawString(this.font, String.format("x%.2f", Float.valueOf(this.scale)), x + 80, y - 60, -14737633, false);
    }
}

