/*
 * Decompiled with CFR 0.152.
 */
package org.eu.hanana.reimu.chatimage.screen.widget;

import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class TextListWidget
extends ObjectSelectionList<TextEntry> {
    private final int lw;
    protected Screen parent;

    public TextListWidget(Screen parent, int listWidth, int top, int bottom) {
        Minecraft minecraft = parent.getMinecraft();
        Objects.requireNonNull(parent.getFont());
        super(minecraft, listWidth, bottom - top, top, 9 + 5);
        this.parent = parent;
        this.lw = listWidth;
    }

    public void onSelect(TextEntry entry) {
    }

    public void setScrollAmount(double scrollAmount) {
        super.setScrollAmount(scrollAmount);
    }

    protected TextEntry getEntry(int index) {
        return (TextEntry)super.getEntry(index);
    }

    public void clearEntries() {
        super.clearEntries();
    }

    protected int scrollBarX() {
        return this.lw + this.getX();
    }

    public int addEntry(@NotNull TextEntry entry) {
        return super.addEntry((AbstractSelectionList.Entry)entry);
    }

    public TextEntry newEntry(String s) {
        return new TextEntry(s);
    }

    public class TextEntry
    extends ObjectSelectionList.Entry<TextEntry> {
        public String text;
        public ResourceLocation icon;

        public TextEntry(String s) {
            this.text = s;
            if (this.text == null) {
                this.text = "";
            }
        }

        @NotNull
        public Component getNarration() {
            return Component.translatable((String)"narrator.select", (Object[])new Object[]{this.text});
        }

        public void setFocused(boolean focused) {
            super.setFocused(focused);
            if (focused) {
                TextListWidget.this.onSelect(this);
            }
        }

        public void render(@NotNull GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
            if (this.icon != null) {
                guiGraphics.blitInscribed(this.icon, left, top, 11, 11, 11, 11);
            }
            guiGraphics.drawString(TextListWidget.this.parent.getFont(), this.text, left + 12, top + 1, -1);
        }
    }
}

