/*
 * Decompiled with CFR 0.152.
 */
package btwr.btwr_sl.lib.block;

import btwr.btwr_sl.lib.util.utils.ItemUtils;
import btwr.btwr_sl.lib.util.utils.VectorUtils;
import btwr.btwr_sl.tag.BTWRConventionalTags;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2384;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;

public class StackDroppingManager {
    private static final StackDroppingManager instance = new StackDroppingManager();
    private static final String TOUGH_ENVIRONMENT_ID = "tough_environment";
    private static final String STURDY_TREES_ID = "sturdy_trees";

    private StackDroppingManager() {
    }

    public static StackDroppingManager getInstance() {
        return instance;
    }

    public void onDropStacks(class_2680 state, class_1937 world, class_2338 pos, class_2586 blockEntity, class_1297 entity, class_1799 tool) {
        if (world instanceof class_3218) {
            class_2350 lookDirection = VectorUtils.getMiningDirection(entity, world, pos);
            if (this.isDroppingInDirectionBlock(state) && !this.isFullyBreakingTool(tool) && this.isModHavingDirectionalDropBlocks()) {
                ItemUtils.ejectStackFromBlockTowardsFacing(world, entity, pos, state, blockEntity, tool, lookDirection.method_10153());
            } else {
                class_2248.method_9609((class_2680)state, (class_3218)((class_3218)world), (class_2338)pos, (class_2586)blockEntity, (class_1297)entity, (class_1799)tool).forEach(stack -> class_2248.method_9577((class_1937)world, (class_2338)pos, (class_1799)stack));
                state.method_26180((class_3218)world, pos, tool, true);
            }
        }
    }

    private boolean isFullyBreakingTool(class_1799 tool) {
        return tool.method_31574(class_1802.field_8062) || tool.method_31573(BTWRConventionalTags.Items.MODERN_PICKAXES) || tool.method_31573(BTWRConventionalTags.Items.MODERN_AXES) || tool.method_31573(BTWRConventionalTags.Items.ADVANCED_PICKAXES) || tool.method_31573(BTWRConventionalTags.Items.ADVANCED_AXES);
    }

    private boolean isDroppingInDirectionBlock(class_2680 state) {
        if (state.method_26204() instanceof class_2384) {
            return false;
        }
        return state.method_26164(BTWRConventionalTags.Blocks.VANILLA_CONVERTING_BLOCKS) || state.method_26164(BTWRConventionalTags.Blocks.MODDED_CONVERTING_BLOCKS);
    }

    private boolean isModHavingDirectionalDropBlocks() {
        return FabricLoader.getInstance().isModLoaded(TOUGH_ENVIRONMENT_ID) || FabricLoader.getInstance().isModLoaded(STURDY_TREES_ID);
    }
}

