/*
 * Decompiled with CFR 0.152.
 */
package btwr.btwr_sl.lib;

import btwr.btwr_sl.BTWRSLMod;
import btwr.btwr_sl.lib.config.BTWRSLSettings;
import com.google.gson.Gson;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class BTWRSLModClient
implements ClientModInitializer {
    public BTWRSLSettings settings;
    private static BTWRSLModClient instance;

    public static BTWRSLModClient getInstance() {
        return instance;
    }

    public static BTWRSLSettings getSettings() {
        return BTWRSLModClient.getInstance().settings;
    }

    public void onInitializeClient() {
        instance = this;
        this.loadSettings();
    }

    public void loadSettings() {
        File file = new File("./config/btwr/btwrsl_common.json");
        Gson gson = new Gson();
        if (file.exists()) {
            try {
                FileReader fileReader = new FileReader(file);
                this.settings = (BTWRSLSettings)gson.fromJson((Reader)fileReader, BTWRSLSettings.class);
                fileReader.close();
            }
            catch (IOException e) {
                BTWRSLMod.LOGGER.warn("Could not load BTWRSL settings: {}", (Object)e.getLocalizedMessage());
            }
        } else {
            this.settings = new BTWRSLSettings();
        }
    }

    public void saveSettings() {
        Gson gson = new Gson();
        File file = new File("./config/btwr/btwrsl_common.json");
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdir();
        }
        try {
            FileWriter fileWriter = new FileWriter(file);
            fileWriter.write(gson.toJson((Object)this.settings));
            fileWriter.close();
        }
        catch (IOException e) {
            BTWRSLMod.LOGGER.warn("Could not save BTWRSL settings: {}", (Object)e.getLocalizedMessage());
        }
    }
}

