/*
 * Decompiled with CFR 0.152.
 */
package btwr.btwr_sl.lib.emi;

import btwr.btwr_sl.lib.recipe.ExtendedShapelessRecipe;
import dev.emi.emi.EmiPort;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.Bounds;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.api.widget.WidgetHolder;
import dev.emi.emi.recipe.EmiShapelessRecipe;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_1867;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5481;
import net.minecraft.class_5684;

@Environment(value=EnvType.CLIENT)
public class EmiExtendedShapelessRecipe
extends EmiShapelessRecipe {
    private final ExtendedShapelessRecipe recipe;
    private final int toolDamage;
    private final class_2371<class_1799> additionalDrops;
    private static final EmiTexture GREEN_PLUS = new EmiTexture(EmiPort.id((String)"textures/gui/green_plus.png"), 0, 0, 8, 8);

    public EmiExtendedShapelessRecipe(ExtendedShapelessRecipe recipe) {
        super((class_1867)recipe);
        this.recipe = recipe;
        this.toolDamage = recipe.getToolDamage();
        this.additionalDrops = recipe.getAdditionalDrops();
    }

    public int getToolDamage() {
        return this.toolDamage;
    }

    public List<class_1799> getAdditionalDrops() {
        ArrayList<class_1799> copies = new ArrayList<class_1799>(this.additionalDrops.size());
        for (class_1799 s : this.additionalDrops) {
            copies.add(s.method_7972());
        }
        return copies;
    }

    public void addWidgets(WidgetHolder widgets) {
        super.addWidgets(widgets);
        if (!this.additionalDrops.isEmpty()) {
            final int iconX = 112;
            final int iconY = 46;
            widgets.add(new Widget(){

                public Bounds getBounds() {
                    return new Bounds(iconX, iconY, 8, 8);
                }

                public void method_25394(class_332 draw, int mouseX, int mouseY, float delta) {
                    class_327 font = class_310.method_1551().field_1772;
                    draw.method_51433(font, "+", iconX + 1, iconY, 0, false);
                    draw.method_51433(font, "+", iconX - 1, iconY, 0, false);
                    draw.method_51433(font, "+", iconX, iconY + 1, 0, false);
                    draw.method_51433(font, "+", iconX, iconY - 1, 0, false);
                    draw.method_51433(font, "+", iconX, iconY, 8453920, false);
                }

                public List<class_5684> getTooltip(int mouseX, int mouseY) {
                    ArrayList<class_5684> tips = new ArrayList<class_5684>();
                    tips.add(class_5684.method_32662((class_5481)class_2561.method_43470((String)"\u00a7aAdditional Drops:").method_30937()));
                    for (class_1799 s : EmiExtendedShapelessRecipe.this.additionalDrops) {
                        if (s.method_7960()) continue;
                        class_5481 line = class_2561.method_43470((String)("  " + s.method_7947() + "x " + s.method_7964().getString())).method_30937();
                        tips.add(class_5684.method_32662((class_5481)line));
                    }
                    return tips;
                }
            });
        }
    }

    public List<EmiStack> getOutputs() {
        ArrayList<EmiStack> outs = new ArrayList<EmiStack>(super.getOutputs());
        for (class_1799 s : this.additionalDrops) {
            if (s == null || s.method_7960()) continue;
            outs.add(EmiStack.of((class_1799)s));
        }
        return outs;
    }

    public class_1799 applyToolDamage(class_1799 toolStack) {
        if (toolStack == null || toolStack.method_7960()) {
            return class_1799.field_8037;
        }
        if (toolStack.method_7963() || toolStack.method_7936() > 0) {
            class_1799 copy = toolStack.method_7972();
            int newDamage = copy.method_7919() + this.toolDamage;
            if (newDamage >= copy.method_7936()) {
                return class_1799.field_8037;
            }
            copy.method_7974(newDamage);
            return copy;
        }
        return toolStack.method_7972();
    }

    public EmiRecipeCategory getCategory() {
        return super.getCategory();
    }

    public String toString() {
        return "EmiCraftingWithToolShapelessRecipe[" + String.valueOf(this.recipe) + ", toolDamage=" + this.toolDamage + ", drops=" + this.additionalDrops.size() + "]";
    }
}

