/*
 * Decompiled with CFR 0.152.
 */
package btwr.btwr_sl.lib.gui;

import btwr.btwr_sl.BTWRSLMod;
import btwr.btwr_sl.lib.BTWRSLModClient;
import btwr.btwr_sl.lib.config.BTWRSLSettings;
import btwr.btwr_sl.lib.config.PenaltyDrawMode;
import java.util.TreeMap;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_746;

@Environment(value=EnvType.CLIENT)
public class PenaltyDisplayManager {
    private static final PenaltyDisplayManager INSTANCE = new PenaltyDisplayManager();
    public static final int HEALTH_PRIORITY = 10;
    public static final int GLOOM_PRIORITY = 20;
    public static final int HUNGER_PRIORITY = 30;
    public static final byte RIGHT = 1;
    public static final byte LEFT = 0;
    public static final byte BOTTOM = 1;
    public static final byte TOP = 0;
    private static TreeMap<Integer, Penalty> penalties = new TreeMap();
    private static boolean isRenderingFood = false;

    public static PenaltyDisplayManager getInstance() {
        return INSTANCE;
    }

    public void render(class_332 context, class_327 renderer) {
        class_746 player = class_310.method_1551().field_1724;
        this.renderPenalties(context, renderer, (class_1657)player);
    }

    private void renderPenalties(class_332 context, class_327 renderer, class_1657 player) {
        if (this.getDrawMode().isAnchor()) {
            this.renderPenaltiesAnchored(context, renderer, player);
            return;
        }
        int hungerBarX = context.method_51421() / 2 + 91;
        int hungerBarY = context.method_51443() - 39;
        hungerBarX += this.getSettings().getRenderXOffset();
        int textY = this.getTextY(player, hungerBarY -= this.getSettings().getRenderYOffset());
        int offsetY = 0;
        for (Penalty penalty : penalties.values()) {
            class_5250 translatedText = class_2561.method_43471((String)penalty.getDisplay());
            int statusX = hungerBarX - renderer.method_27525((class_5348)translatedText);
            if (!penalty.condition.test() || translatedText.getString().isEmpty()) continue;
            context.method_51439(renderer, (class_2561)translatedText, statusX, textY - offsetY, -1, true);
            offsetY += 10;
        }
        this.setRenderingFood(false);
    }

    private void renderPenaltiesAnchored(class_332 context, class_327 renderer, class_1657 player) {
        PenaltyDrawMode drawMode = this.getDrawMode();
        int renderX = drawMode.getX(context);
        int renderY = drawMode.getY(context);
        int offsetY = 0;
        int margin = this.getSettings().getRenderMargin();
        renderX += this.getSettings().getRenderXOffset();
        renderX += drawMode.getXMargin(margin);
        renderY -= this.getSettings().getRenderYOffset();
        renderY += drawMode.getYMargin(margin);
        for (Penalty penalty : penalties.values()) {
            class_5250 translatedText = class_2561.method_43471((String)penalty.getDisplay());
            int statusX = renderX - (drawMode.shouldAddX() ? renderer.method_27525((class_5348)translatedText) : 0);
            if (!penalty.condition.test() || translatedText.getString().isEmpty()) continue;
            context.method_51439(renderer, (class_2561)translatedText, statusX, renderY - offsetY, -1, true);
            offsetY += drawMode.shouldFlipY() ? -10 : 10;
        }
    }

    private int getTextY(class_1657 player, int hungerBarY) {
        int textY;
        boolean isRenderingAir = player.method_5669() != player.method_5748();
        boolean isRenderingArmor = player.method_6096() > 0;
        int n = textY = isRenderingFood ? hungerBarY - 10 : hungerBarY;
        if (isRenderingAir && isRenderingFood || isRenderingArmor && !isRenderingFood) {
            textY -= 10;
        }
        return textY;
    }

    public void setRenderingFood(boolean value) {
        isRenderingFood = value;
        if (FabricLoader.getInstance().isModLoaded("granular-hunger") || BTWRSLModClient.getSettings().isHungerOffsetEnabled()) {
            isRenderingFood = true;
        }
    }

    public void addPenalty(Penalty newPenalty) {
        int index = newPenalty.getPriority();
        boolean hasKey = penalties.containsKey(index);
        while (hasKey) {
            hasKey = penalties.containsKey(++index);
        }
        penalties.put(index, newPenalty);
    }

    public void removePenalty(Penalty newPenalty) {
        int index = newPenalty.getPriority();
        this.removePenaltyAtIndex(index);
    }

    public void removePenaltyAtIndex(int index) {
        try {
            penalties.remove(index);
        }
        catch (IndexOutOfBoundsException e) {
            BTWRSLMod.LOGGER.error("Could not remove penalty!", e.getCause());
        }
    }

    private BTWRSLSettings getSettings() {
        return BTWRSLModClient.getSettings();
    }

    private PenaltyDrawMode getDrawMode() {
        return BTWRSLModClient.getSettings().getDrawMode();
    }

    @Environment(value=EnvType.CLIENT)
    public static class Penalty {
        protected int priority;
        protected PenaltyString display;
        protected PenaltyCondition condition;

        public Penalty(int priority, PenaltyString display, PenaltyCondition condition) {
            this.priority = priority;
            this.display = display;
            this.condition = condition;
        }

        public Penalty(int priority, String string, PenaltyCondition condition) {
            this.priority = priority;
            this.display = () -> string;
            this.condition = condition;
        }

        public Penalty(int priority, PenaltyString display) {
            this.priority = priority;
            this.display = display;
            this.condition = () -> true;
        }

        public int getPriority() {
            return this.priority;
        }

        public String getDisplay() {
            return this.display.get();
        }
    }

    @FunctionalInterface
    @Environment(value=EnvType.CLIENT)
    public static interface PenaltyCondition {
        public boolean test();
    }

    @FunctionalInterface
    @Environment(value=EnvType.CLIENT)
    public static interface PenaltyString {
        public String get();
    }
}

