/*
 * Decompiled with CFR 0.152.
 */
package org.btwr.shared_library;

import com.google.gson.Gson;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.btwr.shared_library.BTWRSLMod;
import org.btwr.shared_library.compat.LeaveMyBarsAloneCompat;
import org.btwr.shared_library.compat.ToughAsNailsCompat;
import org.btwr.shared_library.config.BTWRSLSettings;
import org.btwr.shared_library.gui.hud.PenaltyDisplayManager;

@Environment(value=EnvType.CLIENT)
public class BTWRSLModClient
implements ClientModInitializer {
    public BTWRSLSettings settings;
    private static BTWRSLModClient instance;
    private static final String CONFIG_FILE_PATH = "./config/btwr/btwrsl_common.json";

    public static BTWRSLModClient getInstance() {
        return instance;
    }

    public static BTWRSLSettings getSettings() {
        return BTWRSLModClient.getInstance().settings;
    }

    public void onInitializeClient() {
        instance = this;
        this.loadSettings();
        PenaltyDisplayManager.HudYOffsetRegistry.registerDefaults();
        LeaveMyBarsAloneCompat.init();
        ToughAsNailsCompat.init();
    }

    public void loadSettings() {
        File file = new File(CONFIG_FILE_PATH);
        Gson gson = new Gson();
        if (file.exists()) {
            try {
                FileReader fileReader = new FileReader(file);
                this.settings = (BTWRSLSettings)gson.fromJson((Reader)fileReader, BTWRSLSettings.class);
                fileReader.close();
            }
            catch (IOException e) {
                BTWRSLMod.LOGGER.warn("Could not load BTWR: Shared Library settings: {}", (Object)e.getLocalizedMessage());
            }
        } else {
            this.settings = new BTWRSLSettings();
        }
    }

    public void saveSettings() {
        Gson gson = new Gson();
        File file = new File(CONFIG_FILE_PATH);
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdir();
        }
        try {
            FileWriter fileWriter = new FileWriter(file);
            fileWriter.write(gson.toJson((Object)this.settings));
            fileWriter.close();
        }
        catch (IOException e) {
            BTWRSLMod.LOGGER.warn("Could not save BTWR: Shared Library settings: {}", (Object)e.getLocalizedMessage());
        }
    }
}

