/*
 * Decompiled with CFR 0.152.
 */
package org.btwr.shared_library.gui;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1657;
import net.minecraft.class_5134;

@Environment(value=EnvType.CLIENT)
public class FOVManager {
    private static final FOVManager INSTANCE = new FOVManager();
    private static HashMap<String, Namespace> namespaces = new HashMap();

    public static FOVManager getInstance() {
        return INSTANCE;
    }

    public double offsetAttribute(class_1657 player, double value) {
        class_1324 speedAttrib = player.method_5996(class_5134.field_23719);
        if (speedAttrib != null) {
            return this.getAttributeValueFiltered(speedAttrib);
        }
        return value;
    }

    public float getAttributeValueFiltered(class_1324 attribute) {
        double currentValue = attribute.method_6194();
        Map operationToModifiers = Stream.of(class_1322.class_1323.values()).collect(Collectors.toMap(Function.identity(), operation -> Sets.newHashSet(), (o1, o2) -> o1, () -> Maps.newEnumMap(class_1322.class_1323.class)));
        attribute.method_6195().stream().filter(this::shouldInclude).forEach(modifier -> ((Set)operationToModifiers.get(modifier.comp_2450())).add(modifier));
        for (class_1322 attributeModifier : (Set)operationToModifiers.get(class_1322.class_1323.field_6328)) {
            currentValue -= attributeModifier.comp_2449();
        }
        for (class_1322 attributeModifier : (Set)operationToModifiers.get(class_1322.class_1323.field_6330)) {
            currentValue -= currentValue / attributeModifier.comp_2449();
        }
        for (class_1322 attributeModifier : (Set)operationToModifiers.get(class_1322.class_1323.field_6331)) {
            currentValue /= 1.0 + attributeModifier.comp_2449();
        }
        return (float)((class_1320)attribute.method_6198().comp_349()).method_6165(currentValue);
    }

    private boolean shouldInclude(class_1322 modifier) {
        String namespaceString = modifier.comp_2447().method_12836();
        Namespace namespace = namespaces.get(namespaceString);
        if (namespace == null) {
            return false;
        }
        return namespace.condition.test();
    }

    public void addNamespace(Namespace namespace) {
        namespaces.put(namespace.getNamespace(), namespace);
    }

    public void addNamespace(String namespaceString) {
        this.addNamespace(new Namespace(namespaceString));
    }

    @Environment(value=EnvType.CLIENT)
    public static class Namespace {
        private ExclusionCondition condition;
        private String namespace;

        public Namespace(String namespace) {
            this.condition = () -> true;
            this.namespace = namespace;
        }

        public Namespace(ExclusionCondition condition, String namespace) {
            this.condition = condition;
            this.namespace = namespace;
        }

        public String getNamespace() {
            return this.namespace;
        }
    }

    @FunctionalInterface
    @Environment(value=EnvType.CLIENT)
    public static interface ExclusionCondition {
        public boolean test();
    }
}

