/*
 * Decompiled with CFR 0.152.
 */
package org.btwr.shared_library.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_161;
import net.minecraft.class_170;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1867;
import net.minecraft.class_1935;
import net.minecraft.class_2119;
import net.minecraft.class_2371;
import net.minecraft.class_2450;
import net.minecraft.class_2960;
import net.minecraft.class_3956;
import net.minecraft.class_5797;
import net.minecraft.class_7710;
import net.minecraft.class_7800;
import net.minecraft.class_8782;
import net.minecraft.class_8790;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.class_9694;
import org.btwr.shared_library.mixin.accessors.ShapelessRecipeJsonBuilderAccessorMixin;
import org.btwr.shared_library.recipe.BTWRSLRecipes;
import org.btwr.shared_library.recipe.capability.AdditionalDropsRecipe;
import org.btwr.shared_library.recipe.capability.CraftingWithToolRecipe;
import org.btwr.shared_library.tag.BTWRConventionalTags;

public class ExtendedShapelessRecipe
extends class_1867
implements AdditionalDropsRecipe,
CraftingWithToolRecipe {
    final int toolDamage;
    final class_2371<class_1799> additionalDrops;

    public ExtendedShapelessRecipe(String group, class_7710 category, class_1799 result, class_2371<class_1856> ingredients, int toolDamage, class_2371<class_1799> additionalDrops) {
        super(group, category, result, ingredients);
        this.toolDamage = toolDamage;
        this.additionalDrops = additionalDrops;
    }

    public class_3956<?> method_17716() {
        return BTWRSLRecipes.EXTENDED_SHAPELESS_RECIPE_TYPE;
    }

    public class_1865<?> method_8119() {
        return BTWRSLRecipes.EXTENDED_SHAPELESS_RECIPE_SERIALIZER;
    }

    @Override
    public int getToolDamage() {
        return this.toolDamage;
    }

    @Override
    public class_2371<class_1799> getAdditionalDrops() {
        return this.additionalDrops;
    }

    public class_1799 getResult() {
        return this.method_8110(null);
    }

    public class_2371<class_1799> getRemainder(class_9694 input) {
        class_2371 remainders = class_2371.method_10213((int)input.method_59983(), (Object)class_1799.field_8037);
        for (int i = 0; i < remainders.size(); ++i) {
            class_1799 stack = input.method_59984(i);
            if (!stack.method_31573(BTWRConventionalTags.Items.CRAFTING_WITH_TOOLS_ITEMS)) continue;
            class_1799 tool = stack.method_7972();
            if (stack.method_31573(BTWRConventionalTags.Items.DAMAGE_ON_CRAFTING_TOOLS)) {
                int newDamage = stack.method_7919() + this.getToolDamage();
                if (newDamage >= tool.method_7936()) {
                    remainders.set(i, (Object)class_1799.field_8037);
                    continue;
                }
                tool.method_7974(newDamage);
            }
            remainders.set(i, (Object)tool);
        }
        return remainders;
    }

    public static class Serializer
    implements class_1865<ExtendedShapelessRecipe> {
        private static final MapCodec<ExtendedShapelessRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(class_1867::method_8112), (App)class_7710.field_40252.fieldOf("category").orElse((Object)class_7710.field_40251).forGetter(class_1867::method_45441), (App)class_1799.field_51397.fieldOf("result").forGetter(ExtendedShapelessRecipe::getResult), (App)class_1856.field_46096.listOf().fieldOf("ingredients").flatXmap(Serializer::validateIngredients, DataResult::success).forGetter(class_1867::method_8117), (App)Codec.INT.fieldOf("tool_damage").forGetter(CraftingWithToolRecipe::getToolDamage), (App)class_1799.field_49266.listOf().fieldOf("additional_drops").flatXmap(Serializer::validateAdditionalDrops, DataResult::success).forGetter(ExtendedShapelessRecipe::getAdditionalDrops)).apply((Applicative)instance, ExtendedShapelessRecipe::new));
        public static final class_9139<class_9129, ExtendedShapelessRecipe> PACKET_CODEC = class_9139.method_56437(Serializer::write, Serializer::read);

        private static DataResult<class_2371<class_1856>> validateIngredients(List<class_1856> ingredients) {
            Object[] ingredients2 = (class_1856[])ingredients.stream().filter(ingredient -> !ingredient.method_8103()).toArray(class_1856[]::new);
            if (ingredients2.length == 0) {
                return DataResult.error(() -> "No ingredients for shapeless recipe");
            }
            return ingredients2.length > 9 ? DataResult.error(() -> "Too many ingredients for shapeless recipe") : DataResult.success((Object)class_2371.method_10212((Object)class_1856.field_9017, (Object[])ingredients2));
        }

        private static DataResult<class_2371<class_1799>> validateAdditionalDrops(List<class_1799> stacks) {
            Object[] filtered = (class_1799[])stacks.stream().filter(ingredient -> !ingredient.method_7960()).toArray(class_1799[]::new);
            return DataResult.success((Object)class_2371.method_10212((Object)class_1799.field_8037, (Object[])filtered));
        }

        public MapCodec<ExtendedShapelessRecipe> method_53736() {
            return CODEC;
        }

        public class_9139<class_9129, ExtendedShapelessRecipe> method_56104() {
            return PACKET_CODEC;
        }

        private static ExtendedShapelessRecipe read(class_9129 buf) {
            String string = buf.method_19772();
            class_7710 craftingRecipeCategory = (class_7710)buf.method_10818(class_7710.class);
            int i = buf.method_10816();
            class_2371 defaultedList = class_2371.method_10213((int)i, (Object)class_1856.field_9017);
            defaultedList.replaceAll(empty -> (class_1856)class_1856.field_48355.decode((Object)buf));
            class_1799 itemStack = (class_1799)class_1799.field_48349.decode((Object)buf);
            int toolDamage = buf.method_10816();
            int additionalDropsCount = buf.method_10816();
            class_2371 additionalDropsList = class_2371.method_10213((int)additionalDropsCount, (Object)class_1799.field_8037);
            for (int d = 0; d < additionalDropsCount; ++d) {
                additionalDropsList.set(d, (Object)((class_1799)class_1799.field_48349.decode((Object)buf)));
            }
            return new ExtendedShapelessRecipe(string, craftingRecipeCategory, itemStack, (class_2371<class_1856>)defaultedList, toolDamage, (class_2371<class_1799>)additionalDropsList);
        }

        private static void write(class_9129 buf, ExtendedShapelessRecipe recipe) {
            buf.method_10814(recipe.method_8112());
            buf.method_10817((Enum)recipe.method_45441());
            buf.method_10804(recipe.method_8117().size());
            for (class_1856 ingredient : recipe.method_8117()) {
                class_1856.field_48355.encode((Object)buf, (Object)ingredient);
            }
            class_1799.field_48349.encode((Object)buf, (Object)recipe.getResult());
            buf.method_10804(recipe.getToolDamage());
            buf.method_10804(recipe.getAdditionalDrops().size());
            for (class_1799 stack : recipe.getAdditionalDrops()) {
                class_1799.field_48349.encode((Object)buf, (Object)stack);
            }
        }
    }

    public static class JsonBuilder
    extends class_2450 {
        private int toolDamage = 0;
        private final class_2371<class_1799> additionalDrops = class_2371.method_10211();

        public JsonBuilder(class_7800 category, class_1935 output, int count) {
            super(category, output, count);
        }

        public static JsonBuilder create(class_7800 category, class_1935 output) {
            return JsonBuilder.create(category, output, 1);
        }

        public static JsonBuilder create(class_7800 category, class_1935 output, int count) {
            return new JsonBuilder(category, output, count);
        }

        public JsonBuilder withToolDamage() {
            return this.withToolDamage(1);
        }

        public JsonBuilder withToolDamage(int damage) {
            this.toolDamage = damage;
            return this;
        }

        public JsonBuilder additionalDrop(class_1935 itemProvider) {
            return this.additionalDrop(itemProvider, 1);
        }

        public JsonBuilder additionalDrop(class_1935 itemProvider, int count) {
            this.additionalDrops.add((Object)new class_1799(itemProvider, count));
            return this;
        }

        public JsonBuilder additionalDrop(class_1799 stack) {
            this.additionalDrops.add((Object)stack.method_7972());
            return this;
        }

        public void method_17972(class_8790 exporter, class_2960 recipeId) {
            ShapelessRecipeJsonBuilderAccessorMixin accessor = (ShapelessRecipeJsonBuilderAccessorMixin)((Object)this);
            accessor.accessValidate(recipeId);
            class_161.class_162 builder = exporter.method_53818().method_705("has_the_recipe", class_2119.method_27847((class_2960)recipeId)).method_703(class_170.class_171.method_753((class_2960)recipeId)).method_704(class_8782.class_8797.field_1257);
            accessor.getAdvancementBuilder().forEach((arg_0, arg_1) -> ((class_161.class_162)builder).method_705(arg_0, arg_1));
            ExtendedShapelessRecipe recipe = new ExtendedShapelessRecipe(Objects.requireNonNullElse(accessor.getGroup(), ""), class_5797.method_55308((class_7800)accessor.getCategory()), new class_1799((class_1935)accessor.getOutput(), accessor.getCount()), accessor.getInputs(), this.toolDamage, this.additionalDrops);
            exporter.method_53819(recipeId, (class_1860)recipe, builder.method_695(recipeId.method_45138("recipes/" + accessor.getCategory().method_46203() + "/")));
        }
    }
}

