/*
 * Decompiled with CFR 0.152.
 */
package btwr.btwr_sl.lib.mixin.recipe;

import btwr.btwr_sl.lib.recipe.ExtendedShapelessRecipe;
import btwr.btwr_sl.lib.recipe.ExtendedShapelessRecipeFactory;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.Function;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1867;
import net.minecraft.class_2371;
import net.minecraft.class_7710;
import net.minecraft.class_9129;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1867.class_1868.class})
public abstract class ShapelessRecipeSerializerMixin {
    @Unique
    private static final Function<List<class_1856>, DataResult<class_2371<class_1856>>> INGREDIENTS_VALIDATOR = ingredients -> {
        Object[] ingredientsArray = (class_1856[])ingredients.stream().filter(ingredient -> !ingredient.method_8103()).toArray(class_1856[]::new);
        if (ingredientsArray.length == 0) {
            return DataResult.error(() -> "No ingredients for custom shapeless recipe");
        }
        return ingredientsArray.length > 9 ? DataResult.error(() -> "Too many ingredients for custom shapeless recipe") : DataResult.success((Object)class_2371.method_10212((Object)class_1856.field_9017, (Object[])ingredientsArray));
    };
    @Unique
    private static final Function<List<class_1799>, DataResult<class_2371<class_1799>>> ADDITIONAL_DROPS_VALIDATOR = drops -> {
        Object[] dropsArray = (class_1799[])drops.stream().filter(ingredient -> !ingredient.method_7960()).toArray(class_1799[]::new);
        return DataResult.success((Object)class_2371.method_10212((Object)class_1799.field_8037, (Object[])dropsArray));
    };

    @Inject(method={"codec"}, at={@At(value="HEAD")}, cancellable=true)
    public void injectGetCodec(CallbackInfoReturnable<MapCodec<class_1867>> cir) {
        MapCodec extendedCodec = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(class_1867::method_8112), (App)class_7710.field_40252.fieldOf("category").orElse((Object)class_7710.field_40251).forGetter(class_1867::method_45441), (App)class_1799.field_51397.fieldOf("result").forGetter(recipe -> recipe.method_8110(null)), (App)class_1856.field_46096.listOf().fieldOf("ingredients").flatXmap(INGREDIENTS_VALIDATOR, DataResult::success).forGetter(class_1867::method_8117), (App)class_1799.field_24671.listOf().optionalFieldOf("additionalDrops", (Object)class_2371.method_10211()).flatXmap(ADDITIONAL_DROPS_VALIDATOR, DataResult::success).forGetter(recipe -> ((ExtendedShapelessRecipe)recipe).getAdditionalDrops())).apply((Applicative)instance, ExtendedShapelessRecipeFactory::create));
        cir.setReturnValue((Object)extendedCodec);
    }

    @Inject(method={"read"}, at={@At(value="RETURN")}, cancellable=true)
    private static void onRead(class_9129 buf, CallbackInfoReturnable<class_1867> cir) {
        class_1867 recipe = (class_1867)cir.getReturnValue();
        class_2371<class_1799> addedDropsList = ShapelessRecipeSerializerMixin.getAdditionalDrops(buf);
        recipe.setAdditionalDrops(addedDropsList);
        cir.setReturnValue((Object)recipe);
    }

    @Inject(method={"write"}, at={@At(value="TAIL")})
    private static void onWrite(class_9129 buf, class_1867 recipe, CallbackInfo ci) {
        class_2371<class_1799> addedDropsList = recipe.getAdditionalDrops();
        buf.method_10804(addedDropsList.size());
        for (class_1799 droppedStack : addedDropsList) {
            class_1799.field_48349.encode((Object)buf, (Object)droppedStack);
        }
    }

    @Unique
    private static class_2371<class_1799> getAdditionalDrops(class_9129 buf) {
        class_2371 ingredients = class_2371.method_10211();
        int ingredientCount = buf.method_10816();
        for (int i = 0; i < ingredientCount; ++i) {
            ingredients.add((Object)((class_1799)class_1799.field_48349.decode((Object)buf)));
        }
        return ingredients;
    }
}

