/*
 * Decompiled with CFR 0.152.
 */
package com.vnx.goodblocker;

import com.vnx.goodblocker.commands.GoodBlockerCommand;
import com.vnx.goodblocker.listeners.CommandListener;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandExecutor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class GoodBlocker
extends JavaPlugin {
    private List<String> blockedCommands;
    private String blockedMessage;
    private boolean enableLogging;

    public void onEnable() {
        this.saveDefaultConfig();
        this.loadConfiguration();
        this.getCommand("xblocker").setExecutor((CommandExecutor)new GoodBlockerCommand(this));
        this.getServer().getPluginManager().registerEvents((Listener)new CommandListener(this), (Plugin)this);
        this.getLogger().info("xblocker has been enabled successfully!");
        this.getLogger().info("Blocked commands: " + this.blockedCommands.size());
    }

    public void onDisable() {
        this.getLogger().info("GoodBlocker has been disabled!");
    }

    public void loadConfiguration() {
        this.reloadConfig();
        FileConfiguration config = this.getConfig();
        this.blockedCommands = config.getStringList("blocked-commands");
        this.blockedMessage = ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("messages.blocked-command", "&cThis command is blocked!"));
        this.enableLogging = config.getBoolean("enable-logging", true);
        if (this.blockedCommands == null) {
            this.blockedCommands = new ArrayList<String>();
        }
    }

    public List<String> getBlockedCommands() {
        return new ArrayList<String>(this.blockedCommands);
    }

    public String getBlockedMessage() {
        return this.blockedMessage;
    }

    public boolean isLoggingEnabled() {
        return this.enableLogging;
    }

    public boolean isCommandBlocked(String command) {
        command = command.toLowerCase().startsWith("/") ? command.substring(1) : command;
        for (String blocked : this.blockedCommands) {
            String prefix;
            String blockedCmd = blocked.toLowerCase();
            if (command.equals(blockedCmd) || command.startsWith(blockedCmd + " ")) {
                return true;
            }
            if (!blockedCmd.endsWith("*") || !command.startsWith(prefix = blockedCmd.substring(0, blockedCmd.length() - 1))) continue;
            return true;
        }
        return false;
    }

    public void addBlockedCommand(String command) {
        if (!this.blockedCommands.contains(command)) {
            this.blockedCommands.add(command);
            this.getConfig().set("blocked-commands", this.blockedCommands);
            this.saveConfig();
        }
    }

    public void removeBlockedCommand(String command) {
        if (this.blockedCommands.remove(command)) {
            this.getConfig().set("blocked-commands", this.blockedCommands);
            this.saveConfig();
        }
    }
}

