/*
 * Decompiled with CFR 0.152.
 */
package com.vnx.goodblocker.commands;

import com.vnx.goodblocker.GoodBlocker;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;

public class GoodBlockerCommand
implements CommandExecutor,
TabCompleter {
    private final GoodBlocker plugin;

    public GoodBlockerCommand(GoodBlocker plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!sender.hasPermission("xblocker.admin")) {
            sender.sendMessage(ChatColor.RED + "You don't have permission to use this command!");
            return true;
        }
        if (args.length == 0) {
            this.sendHelp(sender);
            return true;
        }
        switch (args[0].toLowerCase()) {
            case "reload": {
                if (!sender.hasPermission("xblocker.reload")) {
                    sender.sendMessage(ChatColor.RED + "You don't have permission to reload the configuration!");
                    return true;
                }
                this.plugin.loadConfiguration();
                sender.sendMessage(ChatColor.GREEN + "Configuration reloaded successfully!");
                break;
            }
            case "list": {
                List<String> blocked = this.plugin.getBlockedCommands();
                if (blocked.isEmpty()) {
                    sender.sendMessage(ChatColor.YELLOW + "No commands are blocked.");
                    break;
                }
                sender.sendMessage(ChatColor.GREEN + "Blocked commands (" + blocked.size() + "):");
                for (String cmd : blocked) {
                    sender.sendMessage(ChatColor.GRAY + "  - " + ChatColor.WHITE + cmd);
                }
                break;
            }
            case "add": {
                if (args.length < 2) {
                    sender.sendMessage(ChatColor.RED + "Usage: /xblocker add <command>");
                    return true;
                }
                String cmdToAdd = args[1].toLowerCase();
                this.plugin.addBlockedCommand(cmdToAdd);
                sender.sendMessage(ChatColor.GREEN + "Command '" + cmdToAdd + "' added to the block list!");
                break;
            }
            case "remove": {
                if (args.length < 2) {
                    sender.sendMessage(ChatColor.RED + "Usage: /xblocker remove <command>");
                    return true;
                }
                String cmdToRemove = args[1].toLowerCase();
                this.plugin.removeBlockedCommand(cmdToRemove);
                sender.sendMessage(ChatColor.GREEN + "Command '" + cmdToRemove + "' removed from the block list!");
                break;
            }
            default: {
                this.sendHelp(sender);
            }
        }
        return true;
    }

    private void sendHelp(CommandSender sender) {
        sender.sendMessage(ChatColor.GOLD + "=== xblocker Help ===");
        sender.sendMessage(ChatColor.YELLOW + "/xb reload" + ChatColor.GRAY + " - Reload the configuration");
        sender.sendMessage(ChatColor.YELLOW + "/xb list" + ChatColor.GRAY + " - List blocked commands");
        sender.sendMessage(ChatColor.YELLOW + "/xb add <command>" + ChatColor.GRAY + " - Block a command");
        sender.sendMessage(ChatColor.YELLOW + "/xb remove <command>" + ChatColor.GRAY + " - Unblock a command");
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (args.length == 1) {
            return Arrays.asList("reload", "list", "add", "remove");
        }
        if (args.length == 2 && args[0].equalsIgnoreCase("remove")) {
            return new ArrayList<String>(this.plugin.getBlockedCommands());
        }
        return new ArrayList<String>();
    }
}

