/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.mekanism;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.DataResult;
import dev.latvian.mods.kubejs.error.KubeRuntimeException;
import dev.latvian.mods.kubejs.holder.HolderWrapper;
import dev.latvian.mods.kubejs.script.KubeJSContext;
import dev.latvian.mods.kubejs.script.SourceLine;
import dev.latvian.mods.kubejs.util.ID;
import dev.latvian.mods.kubejs.util.RegistryAccessContainer;
import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.Wrapper;
import dev.latvian.mods.rhino.type.TypeInfo;
import dev.latvian.mods.rhino.util.HideFromJS;
import java.lang.invoke.CallSite;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import mekanism.api.MekanismAPI;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.api.recipes.ingredients.chemical.ChemicalIngredient;
import mekanism.api.recipes.ingredients.chemical.CompoundChemicalIngredient;
import mekanism.api.recipes.ingredients.chemical.DifferenceChemicalIngredient;
import mekanism.api.recipes.ingredients.chemical.EmptyChemicalIngredient;
import mekanism.api.recipes.ingredients.chemical.SingleChemicalIngredient;
import mekanism.api.recipes.ingredients.chemical.TagChemicalIngredient;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import org.jetbrains.annotations.Nullable;

public interface MekanismChemicalWrapper {
    public static final TypeInfo CHEMICAL_TYPE_INFO = TypeInfo.of(Chemical.class);
    public static final TypeInfo CHEMICAL_HOLDER_TYPE_INFO = TypeInfo.of(Holder.class).withParams(new TypeInfo[]{TypeInfo.of(Chemical.class)});
    public static final TypeInfo CHEMICAL_STACK_TYPE_INFO = TypeInfo.of(ChemicalStack.class);
    public static final TypeInfo CHEMICAL_INGREDIENT_TYPE_INFO = TypeInfo.of(ChemicalIngredient.class);
    public static final TypeInfo CHEMICAL_STACK_INGREDIENT_TYPE_INFO = TypeInfo.of(ChemicalStackIngredient.class);
    public static final DataResult<ChemicalStack> EMPTY_STACK_RESULT = DataResult.success((Object)ChemicalStack.EMPTY);
    public static final DataResult<ChemicalIngredient> EMPTY_INGREDIENT_RESULT = DataResult.success((Object)EmptyChemicalIngredient.INSTANCE);

    @HideFromJS
    private static Holder<Chemical> wrapAsHolder(Chemical chem) {
        return MekanismAPI.CHEMICAL_REGISTRY.wrapAsHolder((Object)chem);
    }

    public static Holder<Chemical> of(KubeJSContext cx, Object from) {
        Object object = from;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ChemicalStack.class}, (Object)object, n)) {
            case -1 -> MekanismAPI.EMPTY_CHEMICAL_HOLDER;
            case 0 -> {
                ChemicalStack c = (ChemicalStack)object;
                yield c.getChemicalHolder();
            }
            default -> HolderWrapper.wrap((KubeJSContext)cx, (Object)from, (TypeInfo)CHEMICAL_TYPE_INFO);
        };
    }

    public static ChemicalStack stack(Holder<Chemical> chemical, long amount) {
        return new ChemicalStack(chemical, amount);
    }

    public static ChemicalIngredient ingredientExcept(ChemicalIngredient ingredient, ChemicalIngredient except) {
        return new DifferenceChemicalIngredient(ingredient, except);
    }

    public static ChemicalIngredient ingredientIntersection(List<ChemicalIngredient> children) {
        return new CompoundChemicalIngredient(children);
    }

    public static ChemicalStackIngredient ingredientStack(ChemicalIngredient ingredient, long amount) {
        return new ChemicalStackIngredient(ingredient, amount);
    }

    public static ChemicalStack stackOf(Context cx, Object from) {
        return (ChemicalStack)MekanismChemicalWrapper.tryWrapStack(cx, from).getOrThrow(error -> new KubeRuntimeException("Failed to read chemical stack from %s: %s".formatted(from, error)).source(SourceLine.of((Context)cx)));
    }

    @HideFromJS
    @Nullable
    public static ChemicalStack wrapStackTrivial(Context cx, Object from) {
        ChemicalStack chemicalStack;
        while (from instanceof Wrapper) {
            Wrapper w = (Wrapper)from;
            from = w.unwrap();
        }
        RegistryAccessContainer registries = RegistryAccessContainer.of((Context)cx);
        Object object = from;
        int n = 0;
        block8: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ChemicalStack.class, Chemical.class, Holder.class, Holder.class}, (Object)object, n)) {
                case -1: {
                    chemicalStack = ChemicalStack.EMPTY;
                    break block8;
                }
                case 0: {
                    ChemicalStack id;
                    chemicalStack = id = (ChemicalStack)object;
                    break block8;
                }
                case 1: {
                    Chemical chem = (Chemical)object;
                    chemicalStack = MekanismChemicalWrapper.wrapStackTrivial(cx, MekanismChemicalWrapper.wrapAsHolder(chem));
                    break block8;
                }
                case 2: {
                    Holder holder = (Holder)object;
                    if (!holder.is(MekanismAPI.EMPTY_CHEMICAL_KEY)) {
                        n = 3;
                        continue block8;
                    }
                    chemicalStack = ChemicalStack.EMPTY;
                    break block8;
                }
                case 3: {
                    Holder holder = (Holder)object;
                    chemicalStack = new ChemicalStack(holder, 1000L);
                    break block8;
                }
                default: {
                    chemicalStack = null;
                    break block8;
                }
            }
            break;
        }
        return chemicalStack;
    }

    @HideFromJS
    public static DataResult<ChemicalStack> tryWrapStack(Context cx, Object from) {
        while (from instanceof Wrapper) {
            Wrapper w = (Wrapper)from;
            from = w.unwrap();
        }
        RegistryAccessContainer registries = RegistryAccessContainer.of((Context)cx);
        ChemicalStack trivial = MekanismChemicalWrapper.wrapStackTrivial(cx, from);
        if (trivial != null) {
            return DataResult.success((Object)trivial);
        }
        String str = from.toString();
        if (str.isEmpty() || str.equals("mekanism:empty")) {
            return EMPTY_STACK_RESULT;
        }
        try {
            return MekanismChemicalWrapper.readStack(new StringReader(str));
        }
        catch (CommandSyntaxException ex) {
            return DataResult.error(() -> ((CommandSyntaxException)ex).getMessage());
        }
    }

    @HideFromJS
    @Nullable
    public static ChemicalIngredient wrapIngredientTrivial(Context cx, Object from) {
        Object object = from;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ChemicalIngredient.class, ChemicalStackIngredient.class, ChemicalStack.class, Chemical.class}, (Object)object, n)) {
            case -1 -> EmptyChemicalIngredient.INSTANCE;
            case 0 -> {
                ChemicalIngredient c = (ChemicalIngredient)object;
                yield c;
            }
            case 1 -> {
                ChemicalStackIngredient c = (ChemicalStackIngredient)object;
                yield c.ingredient();
            }
            case 2 -> {
                ChemicalStack c = (ChemicalStack)object;
                yield new SingleChemicalIngredient(c.getChemicalHolder());
            }
            case 3 -> {
                Chemical c = (Chemical)object;
                yield new SingleChemicalIngredient(MekanismChemicalWrapper.wrapAsHolder(c));
            }
            default -> null;
        };
    }

    @HideFromJS
    public static DataResult<ChemicalIngredient> tryWrapIngredient(Context cx, Object from) {
        DataResult dataResult;
        ChemicalIngredient trivial;
        if (from instanceof Wrapper) {
            Wrapper w = (Wrapper)from;
            from = w.unwrap();
        }
        if ((trivial = MekanismChemicalWrapper.wrapIngredientTrivial(cx, from)) != null) {
            return DataResult.success((Object)trivial);
        }
        Object object = from;
        Objects.requireNonNull(object);
        Object object2 = object;
        int n = 0;
        block11: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Iterable.class, CharSequence.class, CharSequence.class}, (Object)object2, n)) {
                case 0: {
                    DataResult dataResult2;
                    Iterable itr = (Iterable)object2;
                    ArrayList results = new ArrayList();
                    boolean failed = false;
                    Stream.Builder<CallSite> errors = Stream.builder();
                    for (Object elem : itr) {
                        DataResult<ChemicalIngredient> ingredient = MekanismChemicalWrapper.tryWrapIngredient(cx, elem);
                        ingredient.resultOrPartial().filter(ingr -> !ingr.isEmpty()).ifPresent(results::add);
                        if (!ingredient.isError()) continue;
                        failed = true;
                        errors.add((CallSite)((Object)(String.valueOf(elem) + ": " + ((DataResult.Error)ingredient.error().orElseThrow()).message())));
                    }
                    if (failed) {
                        DataResult dataResult3;
                        String msg = errors.build().collect(Collectors.joining("; "));
                        dataResult = dataResult3 = DataResult.error(() -> "Failed to parse chemical ingredient list: " + msg);
                        break block11;
                    }
                    dataResult = dataResult2 = DataResult.success((Object)(switch (results.size()) {
                        case 0 -> EmptyChemicalIngredient.INSTANCE;
                        case 1 -> (ChemicalIngredient)results.getFirst();
                        default -> new CompoundChemicalIngredient(results);
                    }));
                    break block11;
                }
                case 1: {
                    DataResult dataResult4;
                    CharSequence cs = (CharSequence)object2;
                    if (!cs.isEmpty()) {
                        n = 2;
                        continue block11;
                    }
                    dataResult = dataResult4 = EMPTY_INGREDIENT_RESULT;
                    break block11;
                }
                case 2: {
                    CharSequence cs = (CharSequence)object2;
                    if (!cs.equals("mekanism:empty")) {
                        n = 3;
                        continue block11;
                    }
                    DataResult<ChemicalIngredient> dataResult5 = EMPTY_INGREDIENT_RESULT;
                    dataResult = dataResult5;
                    break block11;
                }
                default: {
                    try {
                        DataResult<ChemicalIngredient> dataResult6 = MekanismChemicalWrapper.readIngredient(cx, new StringReader(from.toString()));
                        dataResult = dataResult6;
                    }
                    catch (CommandSyntaxException ex) {
                        DataResult dataResult7;
                        dataResult = dataResult7 = DataResult.error(() -> ((CommandSyntaxException)ex).getMessage());
                    }
                    break block11;
                }
            }
            break;
        }
        return dataResult;
    }

    public static ChemicalIngredient ingredientOf(Context cx, Object from) {
        return (ChemicalIngredient)MekanismChemicalWrapper.tryWrapIngredient(cx, from).getOrThrow(error -> new KubeRuntimeException("Failed to read chemical ingredient from %s: %s".formatted(from, error)).source(SourceLine.of((Context)cx)));
    }

    @HideFromJS
    public static DataResult<ChemicalStackIngredient> tryWrapStackIngredient(Context cx, Object from) {
        DataResult dataResult;
        while (from instanceof Wrapper) {
            Wrapper w = (Wrapper)from;
            from = w.unwrap();
        }
        Object object = from;
        int n = 0;
        block12: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ChemicalIngredient.class, ChemicalStack.class, ChemicalStackIngredient.class, ChemicalIngredient.class, ChemicalStack.class, Chemical.class}, (Object)object, n)) {
                case -1: {
                    DataResult dataResult2;
                    dataResult = dataResult2 = DataResult.error(() -> "Chemical stack ingredient cannot be parsed from null!");
                    break block12;
                }
                case 0: {
                    DataResult dataResult3;
                    ChemicalIngredient c = (ChemicalIngredient)object;
                    if (!c.isEmpty()) {
                        n = 1;
                        continue block12;
                    }
                    dataResult = dataResult3 = DataResult.error(() -> "Cannot use empty ingredient for chemical stack ingredient!");
                    break block12;
                }
                case 1: {
                    DataResult dataResult4;
                    ChemicalStack c = (ChemicalStack)object;
                    if (!c.isEmpty()) {
                        n = 2;
                        continue block12;
                    }
                    dataResult = dataResult4 = DataResult.error(() -> "Cannot use empty chemical stack for chemical stack ingredient!");
                    break block12;
                }
                case 2: {
                    DataResult dataResult5;
                    ChemicalStackIngredient c = (ChemicalStackIngredient)object;
                    dataResult = dataResult5 = DataResult.success((Object)c);
                    break block12;
                }
                case 3: {
                    DataResult dataResult6;
                    ChemicalIngredient c = (ChemicalIngredient)object;
                    dataResult = dataResult6 = DataResult.success((Object)new ChemicalStackIngredient(c, 1000L));
                    break block12;
                }
                case 4: {
                    DataResult dataResult7;
                    ChemicalStack c = (ChemicalStack)object;
                    dataResult = dataResult7 = DataResult.success((Object)new ChemicalStackIngredient((ChemicalIngredient)new SingleChemicalIngredient(c.getChemicalHolder()), c.getAmount()));
                    break block12;
                }
                case 5: {
                    DataResult dataResult8;
                    Chemical c = (Chemical)object;
                    dataResult = dataResult8 = DataResult.success((Object)new ChemicalStackIngredient((ChemicalIngredient)new SingleChemicalIngredient(MekanismChemicalWrapper.wrapAsHolder(c)), 1000L));
                    break block12;
                }
                default: {
                    try {
                        DataResult dataResult9;
                        dataResult = dataResult9 = MekanismChemicalWrapper.readStackIngredient(new StringReader(from.toString()));
                    }
                    catch (CommandSyntaxException ex) {
                        DataResult dataResult10;
                        dataResult = dataResult10 = DataResult.error(() -> ((CommandSyntaxException)ex).getMessage());
                    }
                    break block12;
                }
            }
            break;
        }
        return dataResult;
    }

    public static ChemicalStackIngredient stackIngredientOf(Context cx, Object from) {
        return (ChemicalStackIngredient)MekanismChemicalWrapper.tryWrapStackIngredient(cx, from).getOrThrow(error -> new KubeRuntimeException("Failed to read chemical stack ingredient from %s: %s".formatted(from, error)).source(SourceLine.of((Context)cx)));
    }

    @HideFromJS
    private static DataResult<Holder<Chemical>> find(ResourceLocation id) {
        return MekanismAPI.CHEMICAL_REGISTRY.getHolder(id).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Chemical with ID " + String.valueOf(id) + " does not exist!")).map(Function.identity());
    }

    public static DataResult<Holder<Chemical>> read(StringReader reader) {
        reader.skipWhitespace();
        return ID.read((StringReader)reader).flatMap(MekanismChemicalWrapper::find);
    }

    public static DataResult<ChemicalStack> readStack(StringReader reader) throws CommandSyntaxException {
        reader.skipWhitespace();
        DataResult<Long> amount = MekanismChemicalWrapper.readChemicalAmount(reader);
        DataResult<Holder<Chemical>> chemical = MekanismChemicalWrapper.read(reader);
        return chemical.apply2(ChemicalStack::new, amount);
    }

    public static DataResult<ChemicalIngredient> readIngredient(Context cx, StringReader reader) throws CommandSyntaxException {
        reader.skipWhitespace();
        if (reader.peek() == '#') {
            reader.skip();
            return ID.read((StringReader)reader).map(id -> TagKey.create((ResourceKey)MekanismAPI.CHEMICAL_REGISTRY_NAME, (ResourceLocation)id)).map(TagChemicalIngredient::new);
        }
        return MekanismChemicalWrapper.read(reader).map(SingleChemicalIngredient::new);
    }

    public static DataResult<ChemicalStackIngredient> readStackIngredient(StringReader reader) throws CommandSyntaxException {
        reader.skipWhitespace();
        DataResult<Long> amount = MekanismChemicalWrapper.readChemicalAmount(reader);
        DataResult<ChemicalIngredient> ingredient = MekanismChemicalWrapper.readIngredient(null, reader);
        return ingredient.apply2(ChemicalStackIngredient::new, amount);
    }

    @HideFromJS
    public static DataResult<Long> readChemicalAmount(StringReader reader) throws CommandSyntaxException {
        reader.skipWhitespace();
        if (reader.canRead() && StringReader.isAllowedNumber((char)reader.peek())) {
            double amountd = reader.readDouble();
            reader.skipWhitespace();
            if (reader.peek() == 'b' || reader.peek() == 'B') {
                reader.skip();
                reader.skipWhitespace();
                amountd *= 1000.0;
            }
            if (reader.peek() == '/') {
                reader.skip();
                reader.skipWhitespace();
                amountd /= reader.readDouble();
            }
            long amount = (long)amountd;
            reader.expect('x');
            reader.skipWhitespace();
            if (amount < 1L) {
                return DataResult.error(() -> "Fluid amount smaller than 1 is not allowed!");
            }
            return DataResult.success((Object)amount);
        }
        return DataResult.success((Object)1000L);
    }
}

