/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.mekanism;

import dev.latvian.mods.kubejs.generator.KubeDataGenerator;
import dev.latvian.mods.kubejs.mekanism.KubeChemicalBuilder;
import dev.latvian.mods.kubejs.mekanism.MekanismChemicalWrapper;
import dev.latvian.mods.kubejs.mekanism.recipe.component.ChemicalIngredientRecipeComponent;
import dev.latvian.mods.kubejs.mekanism.recipe.component.ChemicalRecipeComponent;
import dev.latvian.mods.kubejs.mekanism.recipe.component.ChemicalStackIngredientRecipeComponent;
import dev.latvian.mods.kubejs.mekanism.recipe.component.ChemicalStackRecipeComponent;
import dev.latvian.mods.kubejs.plugin.KubeJSPlugin;
import dev.latvian.mods.kubejs.recipe.component.RecipeComponentTypeRegistry;
import dev.latvian.mods.kubejs.registry.BuilderBase;
import dev.latvian.mods.kubejs.registry.BuilderTypeRegistry;
import dev.latvian.mods.kubejs.registry.RegistryObjectStorage;
import dev.latvian.mods.kubejs.script.BindingRegistry;
import dev.latvian.mods.kubejs.script.DataComponentTypeInfoRegistry;
import dev.latvian.mods.kubejs.script.TypeWrapperRegistry;
import dev.latvian.mods.rhino.type.TypeInfo;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import mekanism.api.MekanismAPI;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.datamaps.IMekanismDataMapTypes;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.api.recipes.ingredients.chemical.ChemicalIngredient;
import mekanism.common.Mekanism;
import mekanism.common.registration.MekanismDeferredHolder;
import mekanism.common.registries.MekanismDataComponents;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.resources.ResourceKey;

public class MekanismKubeJSPlugin
implements KubeJSPlugin {
    public static final RegistryObjectStorage<Chemical> CHEMICAL_REGISTRY = RegistryObjectStorage.of((ResourceKey)MekanismAPI.CHEMICAL_REGISTRY_NAME);

    public void registerBuilderTypes(BuilderTypeRegistry registry) {
        registry.of(MekanismAPI.CHEMICAL_REGISTRY_NAME, reg -> {
            reg.addDefault(KubeChemicalBuilder.Default.class, KubeChemicalBuilder.Default::new);
            reg.add(Mekanism.rl((String)"liquid"), KubeChemicalBuilder.Liquid.class, KubeChemicalBuilder.Liquid::new);
            reg.add(Mekanism.rl((String)"clean_slurry"), KubeChemicalBuilder.CleanSlurry.class, KubeChemicalBuilder.CleanSlurry::new);
            reg.add(Mekanism.rl((String)"dirty_slurry"), KubeChemicalBuilder.DirtySlurry.class, KubeChemicalBuilder.DirtySlurry::new);
            reg.add(Mekanism.rl((String)"infuse_type"), KubeChemicalBuilder.InfuseType.class, KubeChemicalBuilder.InfuseType::new);
            reg.add(Mekanism.rl((String)"pigment"), KubeChemicalBuilder.Pigment.class, KubeChemicalBuilder.Pigment::new);
        });
    }

    public void registerBindings(BindingRegistry bindings) {
        bindings.add("MekanismChemical", MekanismChemicalWrapper.class);
    }

    public void registerTypeWrappers(TypeWrapperRegistry registry) {
        registry.register(ChemicalStack.class, MekanismChemicalWrapper::stackOf);
        registry.register(ChemicalIngredient.class, MekanismChemicalWrapper::ingredientOf);
        registry.register(ChemicalStackIngredient.class, MekanismChemicalWrapper::stackIngredientOf);
    }

    public void registerRecipeComponents(RecipeComponentTypeRegistry registry) {
        registry.register(ChemicalRecipeComponent.CHEMICAL);
        registry.register(ChemicalStackRecipeComponent.CHEMICAL_STACK);
        registry.register(ChemicalStackRecipeComponent.OPTIONAL_CHEMICAL_STACK);
        registry.register(ChemicalIngredientRecipeComponent.CHEMICAL_INGREDIENT);
        registry.register(ChemicalIngredientRecipeComponent.OPTIONAL_CHEMICAL_INGREDIENT);
        registry.register(ChemicalStackIngredientRecipeComponent.CHEMICAL_STACK_INGREDIENT);
    }

    public void registerDataComponentTypeDescriptions(DataComponentTypeInfoRegistry registry) {
        try {
            TypeInfo dctt = TypeInfo.of(DataComponentType.class);
            for (Field field : MekanismDataComponents.class.getDeclaredFields()) {
                TypeInfo t;
                if (field.getType() != MekanismDeferredHolder.class || !Modifier.isPublic(field.getModifiers()) || !Modifier.isStatic(field.getModifiers()) || !(t = TypeInfo.of((Type)field.getGenericType()).param(1)).is(dctt)) continue;
                TypeInfo t2 = t.param(0);
                DataComponentType d = (DataComponentType)((MekanismDeferredHolder)field.get(null)).get();
                registry.register(d, t2);
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    public void generateData(KubeDataGenerator generator) {
        generator.dataMap(IMekanismDataMapTypes.INSTANCE.chemicalSolidTag(), callback -> {
            for (BuilderBase builder : CHEMICAL_REGISTRY) {
                if (!(builder instanceof KubeChemicalBuilder)) continue;
                KubeChemicalBuilder b = (KubeChemicalBuilder)builder;
                if (b.ore == null) continue;
                callback.accept(b.id, (Object)b.ore);
            }
        });
        generator.dataMap(IMekanismDataMapTypes.INSTANCE.chemicalFuel(), callback -> {
            for (BuilderBase builder : CHEMICAL_REGISTRY) {
                if (!(builder instanceof KubeChemicalBuilder)) continue;
                KubeChemicalBuilder b = (KubeChemicalBuilder)builder;
                if (b.fuel == null) continue;
                callback.accept(b.id, (Object)b.fuel);
            }
        });
        generator.dataMap(IMekanismDataMapTypes.INSTANCE.chemicalRadioactivity(), callback -> {
            for (BuilderBase builder : CHEMICAL_REGISTRY) {
                if (!(builder instanceof KubeChemicalBuilder)) continue;
                KubeChemicalBuilder b = (KubeChemicalBuilder)builder;
                if (b.radiation == null) continue;
                callback.accept(b.id, (Object)b.radiation);
            }
        });
        generator.dataMap(IMekanismDataMapTypes.INSTANCE.cooledChemicalCoolant(), callback -> {
            for (BuilderBase builder : CHEMICAL_REGISTRY) {
                if (!(builder instanceof KubeChemicalBuilder)) continue;
                KubeChemicalBuilder b = (KubeChemicalBuilder)builder;
                if (b.cooledCoolant == null) continue;
                callback.accept(b.id, (Object)b.cooledCoolant);
            }
        });
        generator.dataMap(IMekanismDataMapTypes.INSTANCE.heatedChemicalCoolant(), callback -> {
            for (BuilderBase builder : CHEMICAL_REGISTRY) {
                if (!(builder instanceof KubeChemicalBuilder)) continue;
                KubeChemicalBuilder b = (KubeChemicalBuilder)builder;
                if (b.heatedCoolant == null) continue;
                callback.accept(b.id, (Object)b.heatedCoolant);
            }
        });
    }
}

