/*
 * Decompiled with CFR 0.152.
 */
package com.mysiupysiu.bignay.screen;

import com.mysiupysiu.bignay.screen.WorldExportProgressScreen;
import com.mysiupysiu.bignay.screen.file.chooser.FolderChooserScreen;
import com.mysiupysiu.bignay.utils.WorldExporter;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.storage.LevelStorageSource;

public class WorldExportScreen
extends Screen {
    private final LevelStorageSource.LevelStorageAccess levelAccess;
    private final Screen previousScreen;
    private File destinationFile;
    private final File sourceWorld;
    private final long worldSizeBytes;
    private boolean exportPlayerData = true;
    private boolean finished = false;
    private boolean cancelled = false;
    private EditBox nameField;
    private Button selectDestButton;
    private Button exportButton;
    private String worldName;

    public WorldExportScreen(Screen previousScreen, LevelStorageSource.LevelStorageAccess levelAccess) throws IOException, NoSuchFieldException, IllegalAccessException {
        super((Component)Component.m_237115_((String)"selectWorld.edit.export"));
        this.levelAccess = levelAccess;
        this.previousScreen = previousScreen;
        this.sourceWorld = new File(levelAccess.getWorldDir().toFile().getCanonicalPath(), levelAccess.m_78277_());
        this.worldSizeBytes = this.computeFolderSize(this.sourceWorld.toPath());
        this.worldName = levelAccess.m_78308_().m_78361_();
    }

    protected void m_7856_() {
        super.m_7856_();
        int centerX = this.f_96543_ / 2;
        int y = 60;
        int rowGap = 28;
        int inputWidth = 260;
        int inputX = centerX - inputWidth / 2;
        int nameFieldY = y + rowGap + 12;
        this.nameField = new EditBox(this.f_96547_, inputX, nameFieldY, inputWidth, 18, (Component)Component.m_237115_((String)"selectWorld.enterName"));
        this.nameField.m_94144_(this.worldName);
        this.nameField.m_94199_(128);
        this.m_142416_((GuiEventListener)this.nameField);
        Button exportPlayerDataButton = Button.m_253074_((Component)this.getExportPlayerDataLabel(), b -> {
            this.exportPlayerData = !this.exportPlayerData;
            b.m_93666_(this.getExportPlayerDataLabel());
        }).m_252987_(inputX, nameFieldY + rowGap + 50, inputWidth, 20).m_253136_();
        this.m_142416_((GuiEventListener)exportPlayerDataButton);
        this.selectDestButton = Button.m_253074_((Component)Component.m_237115_((String)"exportWorld.choose"), b -> {
            FolderChooserScreen folderChooser = new FolderChooserScreen();
            folderChooser.setOnConfirm(this::setDestinationFile);
            folderChooser.setPreviousScreen(this);
            this.worldName = this.nameField.m_94155_();
            Minecraft.m_91087_().m_91152_((Screen)folderChooser);
        }).m_252987_(inputX + inputWidth - 98, nameFieldY + rowGap + 20, 98, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.selectDestButton);
        int btnY = this.f_96544_ - 40;
        Button cancelButton = Button.m_253074_((Component)Component.m_237115_((String)"gui.cancel"), b -> Minecraft.m_91087_().m_91152_(this.previousScreen)).m_252987_(centerX + 10, btnY, 120, 20).m_253136_();
        this.m_142416_((GuiEventListener)cancelButton);
        this.exportButton = Button.m_253074_((Component)Component.m_237115_((String)"exportWorld.export"), b -> {
            WorldExporter exporter = new WorldExporter(this.levelAccess, this.sourceWorld);
            exporter.setDestination(this.destinationFile);
            exporter.setExportPlayerData(this.exportPlayerData);
            exporter.setWorldName(this.worldName);
            Minecraft.m_91087_().m_91152_((Screen)new WorldExportProgressScreen(exporter));
        }).m_252987_(centerX - 130, btnY, 120, 20).m_253136_();
        this.exportButton.f_93623_ = this.destinationFile != null;
        this.m_142416_((GuiEventListener)this.exportButton);
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(graphics);
        graphics.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 15, 0xFFFFFF);
        int centerX = this.f_96543_ / 2;
        int y = 60;
        int rowGap = 28;
        int inputWidth = 260;
        int inputX = centerX - inputWidth / 2;
        int centerY = this.f_96544_ / 2;
        String sizeText = this.worldSizeBytes >= 0L ? WorldExportScreen.humanReadableByteCount(this.worldSizeBytes) : "-";
        graphics.m_280614_(this.f_96547_, (Component)Component.m_237110_((String)"exportWorld.size", (Object[])new Object[]{sizeText}), inputX, y, 0xFFFFFF, false);
        int nameFieldY = y + rowGap + 12;
        graphics.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"selectWorld.enterName"), inputX, nameFieldY - 12, 0xAAAAAA, false);
        String label = Component.m_237115_((String)"exportWorld.chosen-destination").getString();
        graphics.m_280056_(this.f_96547_, label, inputX, nameFieldY + rowGap + 6, 0xFFFFFF, false);
        String destinationInfo = this.destinationFile != null ? this.destinationFile.getAbsolutePath() : Component.m_237115_((String)"exportWorld.chosen-destination.none").getString();
        int pathX = inputX + this.f_96547_.m_92895_(label);
        int inputRight = inputX + inputWidth;
        int buttonX = this.selectDestButton.m_252754_();
        int maxWidth = Math.max(buttonX - pathX - 8, inputRight - pathX);
        Object shortDest = destinationInfo;
        while (this.f_96547_.m_92895_((String)shortDest) > maxWidth && ((String)shortDest).length() > 5) {
            shortDest = "..." + ((String)shortDest).substring(4);
        }
        graphics.m_280056_(this.f_96547_, (String)shortDest, pathX, nameFieldY + rowGap + 6, 0xFFFFFF, false);
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
    }

    private long computeFolderSize(Path p) {
        long l;
        block9: {
            if (p == null) {
                return -1L;
            }
            Stream<Path> walk = Files.walk(p, new FileVisitOption[0]);
            try {
                l = walk.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).mapToLong(path -> {
                    try {
                        return Files.size(path);
                    }
                    catch (IOException e) {
                        return 0L;
                    }
                }).sum();
                if (walk == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (walk != null) {
                        try {
                            walk.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return -1L;
                }
            }
            walk.close();
        }
        return l;
    }

    public static String humanReadableByteCount(long bytes) {
        if (bytes < 0L) {
            return "-";
        }
        if (bytes < 1024L) {
            return bytes + " B";
        }
        int exp = (int)(Math.log(bytes) / Math.log(1024.0));
        String pre = "" + "KMGT".charAt(exp - 1);
        return String.format("%.1f %sB", (double)bytes / Math.pow(1024.0, exp), pre);
    }

    public void setDestinationFile(File destinationFile) {
        this.destinationFile = destinationFile;
        Minecraft.m_91087_().m_91152_((Screen)this);
        if (this.exportButton != null) {
            this.exportButton.f_93623_ = destinationFile != null;
        }
    }

    private Component getExportPlayerDataLabel() {
        return this.exportPlayerData ? Component.m_237115_((String)"exportWorld.exportPlayerData.on") : Component.m_237115_((String)"exportWorld.exportPlayerData.off");
    }
}

