/*
 * Decompiled with CFR 0.152.
 */
package com.mysiupysiu.bignay.screen;

import com.mysiupysiu.bignay.screen.WorldExportScreen;
import com.mysiupysiu.bignay.screen.WorldImportProgressScreen;
import com.mysiupysiu.bignay.utils.WorldImporter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.worldselection.SelectWorldScreen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.network.chat.Component;

public class WorldImportScreen
extends Screen {
    private final File source;
    private EditBox nameInput;
    private String levelName = "World name";
    private String gameMode;
    private String difficulty;
    private String version;
    private long seed;
    private long daysPlayed;

    public WorldImportScreen(File source) {
        super((Component)Component.m_237115_((String)"importWorld.title"));
        this.source = source;
    }

    protected void m_7856_() {
        int centerX = this.f_96543_ / 2;
        int y = 200;
        this.readLevelDat();
        this.nameInput = new EditBox(this.f_96547_, centerX - 100, 60, 200, 20, (Component)Component.m_237113_((String)this.levelName));
        this.nameInput.m_94144_(this.levelName);
        this.m_142416_((GuiEventListener)this.nameInput);
        Button importButton = Button.m_253074_((Component)Component.m_237115_((String)"importWorld.import"), b -> {
            WorldImporter importer = new WorldImporter(this.source);
            importer.setWorldName(this.nameInput.m_94155_().trim());
            Minecraft.m_91087_().m_91152_((Screen)new WorldImportProgressScreen(importer));
        }).m_252987_(centerX - 110, y, 100, 20).m_253136_();
        this.m_142416_((GuiEventListener)importButton);
        Button cancelButton = Button.m_253074_((Component)Component.m_237115_((String)"gui.cancel"), b -> Minecraft.m_91087_().m_91152_((Screen)new SelectWorldScreen((Screen)this))).m_252987_(centerX + 10, y, 100, 20).m_253136_();
        this.m_142416_((GuiEventListener)cancelButton);
    }

    public void m_88315_(GuiGraphics gui, int mouseX, int mouseY, float delta) {
        this.m_280273_(gui);
        gui.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 30, 0xFFFFFF);
        int centerX = this.f_96543_ / 2;
        int boxY = 100;
        gui.m_280509_(0, boxY, this.f_96543_, boxY + 90, -2013265920);
        int leftX = centerX - 120;
        int rightX = centerX + 20;
        int lineY = boxY + 10;
        int dy = 20;
        gui.m_280653_(this.f_96547_, (Component)Component.m_237110_((String)"importWorld.file", (Object[])new Object[]{this.source.getName()}), this.f_96543_ / 2, lineY, 0xFFFFFF);
        gui.m_280430_(this.f_96547_, (Component)Component.m_237110_((String)"importWorld.version", (Object[])new Object[]{this.version}), leftX, lineY + dy, 0xFFFFFF);
        gui.m_280430_(this.f_96547_, (Component)Component.m_237110_((String)"importWorld.gamemode", (Object[])new Object[]{this.gameMode}), leftX, lineY + dy * 2, 0xFFFFFF);
        gui.m_280430_(this.f_96547_, (Component)Component.m_237110_((String)"importWorld.difficulty", (Object[])new Object[]{this.difficulty}), leftX, lineY + dy * 3, 0xFFFFFF);
        gui.m_280430_(this.f_96547_, (Component)Component.m_237110_((String)"importWorld.seed", (Object[])new Object[]{this.seed}), rightX, lineY + dy, 0xFFFFFF);
        gui.m_280430_(this.f_96547_, (Component)Component.m_237110_((String)"importWorld.days", (Object[])new Object[]{this.daysPlayed}), rightX, lineY + dy * 2, 0xFFFFFF);
        gui.m_280430_(this.f_96547_, (Component)Component.m_237110_((String)"importWorld.size", (Object[])new Object[]{WorldExportScreen.humanReadableByteCount(this.source.length())}), rightX, lineY + dy * 3, 0xFFFFFF);
        super.m_88315_(gui, mouseX, mouseY, delta);
    }

    private void readLevelDat() {
        try (ZipFile zip = new ZipFile(this.source);){
            String topFolder = null;
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (entry.getName().equals("level.dat")) {
                    topFolder = "";
                    break;
                }
                int slash = entry.getName().indexOf(47);
                if (slash <= 0) continue;
                topFolder = entry.getName().substring(0, slash + 1);
            }
            if (topFolder == null) {
                return;
            }
            String path = topFolder + "level.dat";
            ZipEntry levelDatEntry = zip.getEntry(path);
            if (levelDatEntry == null) {
                return;
            }
            try (InputStream is = zip.getInputStream(levelDatEntry);){
                CompoundTag levelData = NbtIo.m_128939_((InputStream)is);
                CompoundTag data = levelData.m_128469_("Data");
                this.levelName = data.m_128461_("LevelName");
                this.version = levelData.m_128469_("Data").m_128469_("Version").m_128461_("Name");
                int gm = data.m_128451_("GameType");
                switch (gm) {
                    case 0: {
                        this.gameMode = "Survival";
                        break;
                    }
                    case 1: {
                        this.gameMode = "Creative";
                        break;
                    }
                    case 2: {
                        this.gameMode = "Adventure";
                        break;
                    }
                    case 3: {
                        this.gameMode = "Spectator";
                        break;
                    }
                    default: {
                        this.gameMode = "Unknown";
                    }
                }
                int diff = data.m_128451_("Difficulty");
                switch (diff) {
                    case 0: {
                        this.difficulty = "Peaceful";
                        break;
                    }
                    case 1: {
                        this.difficulty = "Easy";
                        break;
                    }
                    case 2: {
                        this.difficulty = "Normal";
                        break;
                    }
                    case 3: {
                        this.difficulty = "Hard";
                        break;
                    }
                    default: {
                        this.difficulty = "Unknown";
                    }
                }
                CompoundTag worldGen = data.m_128469_("WorldGenSettings");
                this.seed = worldGen.m_128441_("seed") ? worldGen.m_128454_("seed") : 0L;
                this.daysPlayed = data.m_128454_("DayTime") / 24000L;
            }
        }
        catch (IOException e) {
            this.levelName = "Unknown";
            this.gameMode = "Unknown";
            this.difficulty = "Unknown";
            this.seed = 0L;
            this.daysPlayed = 0L;
            this.version = "Unknown";
        }
    }

    public File getSource() {
        return this.source;
    }
}

