/*
 * Decompiled with CFR 0.152.
 */
package com.mysiupysiu.bignay.screen.file.chooser;

import com.mysiupysiu.bignay.screen.file.chooser.AbstractFileChooserScreen;
import com.mysiupysiu.bignay.utils.FileType;
import com.mysiupysiu.bignay.utils.FileUtils;
import java.io.File;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.network.chat.Component;

public class FileChooserScreen
extends AbstractFileChooserScreen {
    public FileChooserScreen() {
        super((Component)Component.m_237115_((String)"fileChooser.choose_file"));
    }

    public FileChooserScreen(FileType ... fileType) {
        super((Component)Component.m_237115_((String)"fileChooser.choose_file"));
        this.fileTypes = new LinkedHashSet<FileType>(Set.of(fileType));
    }

    @Override
    protected Stream<File> getFiles(File[] content) {
        if (this.fileTypes.isEmpty()) {
            return Arrays.stream(content);
        }
        Stream<File> folders = Arrays.stream(content).filter(File::isDirectory);
        Stream<File> files = Arrays.stream(content).filter(File::isFile).filter(f -> this.fileTypes.contains((Object)FileUtils.getFileType(f)));
        return Stream.concat(folders, files);
    }

    @Override
    protected boolean isRequireDirectory() {
        return false;
    }

    public void setFilter(FileType ... fileType) {
        this.fileTypes = Set.of(fileType);
        this.reloadEntries();
    }

    public void addFilter(FileType ... fileType) {
        this.fileTypes.addAll(Set.of(fileType));
        this.reloadEntries();
    }

    public void clearFilter() {
        this.fileTypes.clear();
        this.reloadEntries();
    }

    public void removeFilter(FileType ... fileType) {
        this.fileTypes.removeAll(Set.of(fileType));
        this.reloadEntries();
    }
}

