/*
 * Decompiled with CFR 0.152.
 */
package com.mysiupysiu.bignay.entities;

import com.mojang.logging.LogUtils;
import com.mysiupysiu.bignay.items.ItemInit;
import java.util.OptionalInt;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DiodeBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;

public class QuadItemFrameEntity
extends HangingEntity {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final EntityDataAccessor<ItemStack> DATA_ITEM_0 = SynchedEntityData.m_135353_(QuadItemFrameEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private static final EntityDataAccessor<ItemStack> DATA_ITEM_1 = SynchedEntityData.m_135353_(QuadItemFrameEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private static final EntityDataAccessor<ItemStack> DATA_ITEM_2 = SynchedEntityData.m_135353_(QuadItemFrameEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private static final EntityDataAccessor<ItemStack> DATA_ITEM_3 = SynchedEntityData.m_135353_(QuadItemFrameEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private static final EntityDataAccessor<Integer> DATA_ROT_0 = SynchedEntityData.m_135353_(QuadItemFrameEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DATA_ROT_1 = SynchedEntityData.m_135353_(QuadItemFrameEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DATA_ROT_2 = SynchedEntityData.m_135353_(QuadItemFrameEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DATA_ROT_3 = SynchedEntityData.m_135353_(QuadItemFrameEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final int NUM_ROTATIONS = 8;
    private float dropChance = 1.0f;
    private boolean fixed;

    public QuadItemFrameEntity(EntityType<? extends QuadItemFrameEntity> p_31761_, Level p_31762_) {
        super(p_31761_, p_31762_);
    }

    protected float m_6380_(Pose p_31784_, EntityDimensions p_31785_) {
        return 0.0f;
    }

    protected void m_8097_() {
        this.m_20088_().m_135372_(DATA_ITEM_0, (Object)ItemStack.f_41583_);
        this.m_20088_().m_135372_(DATA_ITEM_1, (Object)ItemStack.f_41583_);
        this.m_20088_().m_135372_(DATA_ITEM_2, (Object)ItemStack.f_41583_);
        this.m_20088_().m_135372_(DATA_ITEM_3, (Object)ItemStack.f_41583_);
        this.m_20088_().m_135372_(DATA_ROT_0, (Object)0);
        this.m_20088_().m_135372_(DATA_ROT_1, (Object)0);
        this.m_20088_().m_135372_(DATA_ROT_2, (Object)0);
        this.m_20088_().m_135372_(DATA_ROT_3, (Object)0);
    }

    public void m_6022_(Direction p_31793_) {
        Validate.notNull((Object)p_31793_);
        this.f_31699_ = p_31793_;
        if (p_31793_.m_122434_().m_122479_()) {
            this.m_146926_(0.0f);
            this.m_146922_(this.f_31699_.m_122416_() * 90);
        } else {
            this.m_146926_(-90 * p_31793_.m_122421_().m_122540_());
            this.m_146922_(0.0f);
        }
        this.f_19860_ = this.m_146909_();
        this.f_19859_ = this.m_146908_();
        this.m_7087_();
    }

    protected void m_7087_() {
        if (this.f_31699_ != null) {
            double d0 = 0.46875;
            double d1 = (double)this.f_31698_.m_123341_() + 0.5 - (double)this.f_31699_.m_122429_() * 0.46875;
            double d2 = (double)this.f_31698_.m_123342_() + 0.5 - (double)this.f_31699_.m_122430_() * 0.46875;
            double d3 = (double)this.f_31698_.m_123343_() + 0.5 - (double)this.f_31699_.m_122431_() * 0.46875;
            this.m_20343_(d1, d2, d3);
            double d4 = this.m_7076_();
            double d5 = this.m_7068_();
            double d6 = this.m_7076_();
            Direction.Axis direction$axis = this.f_31699_.m_122434_();
            switch (direction$axis) {
                case X: {
                    d4 = 1.0;
                    break;
                }
                case Y: {
                    d5 = 1.0;
                    break;
                }
                case Z: {
                    d6 = 1.0;
                }
            }
            this.m_20011_(new AABB(d1 - (d4 /= 32.0), d2 - (d5 /= 32.0), d3 - (d6 /= 32.0), d1 + d4, d2 + d5, d3 + d6));
        }
    }

    public boolean m_7088_() {
        if (this.fixed) {
            return true;
        }
        if (!this.m_9236_().m_45786_((Entity)this)) {
            return false;
        }
        BlockState blockstate = this.m_9236_().m_8055_(this.f_31698_.m_121945_(this.f_31699_.m_122424_()));
        return blockstate.m_280296_() || this.f_31699_.m_122434_().m_122479_() && DiodeBlock.m_52586_((BlockState)blockstate) ? this.m_9236_().m_6249_((Entity)this, this.m_20191_(), f_31697_).isEmpty() : false;
    }

    public void m_6478_(MoverType p_31781_, Vec3 p_31782_) {
        if (!this.fixed) {
            super.m_6478_(p_31781_, p_31782_);
        }
    }

    public void m_5997_(double p_31817_, double p_31818_, double p_31819_) {
        if (!this.fixed) {
            super.m_5997_(p_31817_, p_31818_, p_31819_);
        }
    }

    public float m_6143_() {
        return 0.0f;
    }

    public void m_6074_() {
        this.removeAllFramedMaps();
        super.m_6074_();
    }

    public boolean m_6469_(DamageSource p_31776_, float p_31777_) {
        if (this.fixed) {
            return !p_31776_.m_269533_(DamageTypeTags.f_268738_) && !p_31776_.m_19390_() ? false : super.m_6469_(p_31776_, p_31777_);
        }
        if (this.m_6673_(p_31776_)) {
            return false;
        }
        if (!p_31776_.m_269533_(DamageTypeTags.f_268415_) && !this.isAllEmpty()) {
            if (!this.m_9236_().f_46443_) {
                this.dropItem(p_31776_.m_7639_(), false);
                this.m_146852_(GameEvent.f_157792_, p_31776_.m_7639_());
                this.m_5496_(this.getRemoveItemSound(), 1.0f, 1.0f);
            }
            return true;
        }
        return super.m_6469_(p_31776_, p_31777_);
    }

    private boolean isAllEmpty() {
        for (int i = 0; i < 4; ++i) {
            if (this.getItem(i).m_41619_()) continue;
            return false;
        }
        return true;
    }

    public SoundEvent getRemoveItemSound() {
        return SoundEvents.f_12016_;
    }

    public int m_7076_() {
        return 14;
    }

    public int m_7068_() {
        return 14;
    }

    public boolean m_6783_(double p_31769_) {
        double d0 = 16.0;
        return p_31769_ < (d0 *= 64.0 * QuadItemFrameEntity.m_20150_()) * d0;
    }

    public void m_5553_(@Nullable Entity p_31779_) {
        this.m_5496_(this.getBreakSound(), 1.0f, 1.0f);
        this.dropItem(p_31779_, true);
        this.m_146852_(GameEvent.f_157792_, p_31779_);
    }

    public SoundEvent getBreakSound() {
        return SoundEvents.f_12014_;
    }

    public void m_7084_() {
        this.m_5496_(this.getPlaceSound(), 1.0f, 1.0f);
    }

    public SoundEvent getPlaceSound() {
        return SoundEvents.f_12015_;
    }

    private void dropItem(@Nullable Entity p_31803_, boolean p_31804_) {
        if (!this.fixed) {
            if (p_31803_ instanceof Player) {
                Player player = (Player)p_31803_;
                if (player.m_150110_().f_35937_) {
                    this.removeAllFramedMaps();
                    return;
                }
            }
            if (p_31804_) {
                this.m_19983_(this.getFrameItemStack());
            }
            for (int i = 0; i < 4; ++i) {
                ItemStack itemstack = this.getItem(i);
                if (itemstack.m_41619_()) continue;
                itemstack = itemstack.m_41777_();
                this.removeFramedMap(itemstack);
                if (this.f_19796_.m_188501_() < this.dropChance) {
                    this.m_19983_(itemstack);
                }
                this.setItem(i, ItemStack.f_41583_, false);
            }
        }
    }

    private void removeAllFramedMaps() {
        for (int i = 0; i < 4; ++i) {
            this.removeFramedMap(this.getItem(i));
        }
    }

    private void removeFramedMap(ItemStack p_31811_) {
        this.getFramedMapId(p_31811_).ifPresent(p_289456_ -> {
            MapItemSavedData mapitemsaveddata = MapItem.m_151128_((Integer)p_289456_, (Level)this.m_9236_());
            if (mapitemsaveddata != null) {
                mapitemsaveddata.m_77947_(this.f_31698_, this.m_19879_());
                mapitemsaveddata.m_77760_(true);
            }
        });
        p_31811_.m_41636_((Entity)null);
    }

    private OptionalInt getFramedMapId(ItemStack stack) {
        Integer integer;
        if (stack.m_150930_(Items.f_42573_) && (integer = MapItem.m_151131_((ItemStack)stack)) != null) {
            return OptionalInt.of(integer);
        }
        return OptionalInt.empty();
    }

    public ItemStack getItem() {
        return this.getItem(0);
    }

    public ItemStack getItem(int slot) {
        return switch (slot) {
            case 0 -> (ItemStack)this.m_20088_().m_135370_(DATA_ITEM_0);
            case 1 -> (ItemStack)this.m_20088_().m_135370_(DATA_ITEM_1);
            case 2 -> (ItemStack)this.m_20088_().m_135370_(DATA_ITEM_2);
            case 3 -> (ItemStack)this.m_20088_().m_135370_(DATA_ITEM_3);
            default -> ItemStack.f_41583_;
        };
    }

    public void setItem(ItemStack p_31806_) {
        this.setItem(0, p_31806_, true);
    }

    public void setItem(int slot, ItemStack stack, boolean notify) {
        ItemStack old;
        if (!stack.m_41619_()) {
            stack = stack.m_255036_(1);
        }
        if (!(old = this.getItem(slot)).m_41619_() && !ItemStack.m_41728_((ItemStack)old, (ItemStack)stack)) {
            this.removeFramedMap(old);
        }
        this.onItemChanged(slot, stack);
        switch (slot) {
            case 0: {
                this.m_20088_().m_135381_(DATA_ITEM_0, (Object)stack);
                break;
            }
            case 1: {
                this.m_20088_().m_135381_(DATA_ITEM_1, (Object)stack);
                break;
            }
            case 2: {
                this.m_20088_().m_135381_(DATA_ITEM_2, (Object)stack);
                break;
            }
            case 3: {
                this.m_20088_().m_135381_(DATA_ITEM_3, (Object)stack);
            }
        }
        if (!stack.m_41619_()) {
            this.m_5496_(this.getAddItemSound(), 1.0f, 1.0f);
        }
        if (notify && this.f_31698_ != null) {
            this.m_9236_().m_46717_(this.f_31698_, Blocks.f_50016_);
        }
    }

    public SoundEvent getAddItemSound() {
        return SoundEvents.f_12013_;
    }

    public SlotAccess m_141942_(int p_149629_) {
        if (p_149629_ >= 0 && p_149629_ < 4) {
            final int idx = p_149629_;
            return new SlotAccess(){

                public ItemStack m_142196_() {
                    return QuadItemFrameEntity.this.getItem(idx);
                }

                public boolean m_142104_(ItemStack p_149635_) {
                    QuadItemFrameEntity.this.setItem(idx, p_149635_, false);
                    return true;
                }
            };
        }
        return super.m_141942_(p_149629_);
    }

    public void m_7350_(EntityDataAccessor<?> p_31797_) {
        if (p_31797_.equals(DATA_ITEM_0) || p_31797_.equals(DATA_ITEM_1) || p_31797_.equals(DATA_ITEM_2) || p_31797_.equals(DATA_ITEM_3)) {
            this.m_7087_();
        }
    }

    private void onItemChanged(int slot, ItemStack stack) {
        this.m_7087_();
    }

    public int getRotation(int slot) {
        return switch (slot) {
            case 0 -> (Integer)this.m_20088_().m_135370_(DATA_ROT_0);
            case 1 -> (Integer)this.m_20088_().m_135370_(DATA_ROT_1);
            case 2 -> (Integer)this.m_20088_().m_135370_(DATA_ROT_2);
            case 3 -> (Integer)this.m_20088_().m_135370_(DATA_ROT_3);
            default -> 0;
        };
    }

    public void setRotation(int slot, int rot) {
        this.setRotation(slot, rot, true);
    }

    private void setRotation(int slot, int rot, boolean notify) {
        int r = Math.floorMod(rot, 8);
        switch (slot) {
            case 0: {
                this.m_20088_().m_135381_(DATA_ROT_0, (Object)r);
                break;
            }
            case 1: {
                this.m_20088_().m_135381_(DATA_ROT_1, (Object)r);
                break;
            }
            case 2: {
                this.m_20088_().m_135381_(DATA_ROT_2, (Object)r);
                break;
            }
            case 3: {
                this.m_20088_().m_135381_(DATA_ROT_3, (Object)r);
            }
        }
        if (notify && this.f_31698_ != null) {
            this.m_9236_().m_46717_(this.f_31698_, Blocks.f_50016_);
        }
    }

    public void m_7380_(CompoundTag p_31808_) {
        super.m_7380_(p_31808_);
        for (int i = 0; i < 4; ++i) {
            ItemStack it = this.getItem(i);
            if (it.m_41619_()) continue;
            CompoundTag tag = new CompoundTag();
            it.m_41739_(tag);
            p_31808_.m_128365_("Item" + i, (Tag)tag);
            p_31808_.m_128344_("ItemRotation" + i, (byte)this.getRotation(i));
        }
        p_31808_.m_128344_("Facing", (byte)this.f_31699_.m_122411_());
        p_31808_.m_128379_("Invisible", this.m_20145_());
        p_31808_.m_128379_("Fixed", this.fixed);
        p_31808_.m_128350_("ItemDropChance", this.dropChance);
    }

    public void m_7378_(CompoundTag p_31795_) {
        super.m_7378_(p_31795_);
        for (int i = 0; i < 4; ++i) {
            CompoundTag compoundtag;
            String key = "Item" + i;
            if (!p_31795_.m_128441_(key) || (compoundtag = p_31795_.m_128469_(key)) == null || compoundtag.m_128456_()) continue;
            ItemStack itemstack = ItemStack.m_41712_((CompoundTag)compoundtag);
            if (itemstack.m_41619_()) {
                LOGGER.warn("Unable to load item from: {}", (Object)compoundtag);
                continue;
            }
            this.setItem(i, itemstack, false);
            String rKey = "ItemRotation" + i;
            if (!p_31795_.m_128441_(rKey)) continue;
            this.setRotation(i, p_31795_.m_128445_(rKey), false);
        }
        if (p_31795_.m_128441_("ItemDropChance")) {
            this.dropChance = p_31795_.m_128457_("ItemDropChance");
        }
        this.m_6022_(Direction.m_122376_((int)p_31795_.m_128445_("Facing")));
        this.m_6842_(p_31795_.m_128471_("Invisible"));
        this.fixed = p_31795_.m_128471_("Fixed");
    }

    private int getQuadrantFromHit(Player player) {
        boolean top;
        Vec3 rayOrigin = player.m_20299_(1.0f);
        Vec3 rayDir = player.m_20252_(1.0f).m_82541_();
        Vec3 planeCenter = new Vec3(this.m_20185_(), this.m_20186_(), this.m_20189_());
        Vec3 normal = new Vec3((double)this.f_31699_.m_122429_(), (double)this.f_31699_.m_122430_(), (double)this.f_31699_.m_122431_()).m_82541_();
        Vec3 planePoint = planeCenter.m_82520_(-normal.f_82479_ * 0.46875, -normal.f_82480_ * 0.46875, -normal.f_82481_ * 0.46875);
        double denom = rayDir.m_82526_(normal);
        if (Math.abs(denom) < 1.0E-6) {
            return 0;
        }
        double t = planePoint.m_82546_(rayOrigin).m_82526_(normal) / denom;
        if (t < 0.0) {
            return 0;
        }
        Vec3 hit = rayOrigin.m_82549_(rayDir.m_82490_(t));
        Vec3 localUp = Math.abs(normal.f_82480_) > 0.9 ? new Vec3(0.0, 0.0, 1.0) : new Vec3(0.0, 1.0, 0.0);
        Vec3 right = localUp.m_82537_(normal).m_82541_();
        Vec3 up = normal.m_82537_(right).m_82541_();
        Vec3 delta = hit.m_82546_(planePoint);
        double x = delta.m_82526_(right);
        double y = delta.m_82526_(up);
        boolean left = x < 0.0;
        boolean bl = top = y > 0.0;
        if (left && top) {
            return 0;
        }
        if (!left && top) {
            return 1;
        }
        if (left && !top) {
            return 2;
        }
        return 3;
    }

    public InteractionResult m_6096_(Player p_31787_, InteractionHand p_31788_) {
        boolean hasHeld;
        ItemStack itemstackInHand = p_31787_.m_21120_(p_31788_);
        boolean hasAny = !this.isAllEmpty();
        boolean bl = hasHeld = !itemstackInHand.m_41619_();
        if (this.fixed) {
            return InteractionResult.PASS;
        }
        if (!this.m_9236_().f_46443_) {
            int slot = this.getQuadrantFromHit(p_31787_);
            ItemStack slotStack = this.getItem(slot);
            if (slotStack.m_41619_()) {
                if (hasHeld && !this.m_213877_()) {
                    MapItemSavedData mapitemsaveddata;
                    if (itemstackInHand.m_150930_(Items.f_42573_) && (mapitemsaveddata = MapItem.m_42853_((ItemStack)itemstackInHand, (Level)this.m_9236_())) != null && mapitemsaveddata.m_181312_(256)) {
                        return InteractionResult.FAIL;
                    }
                    this.setItem(slot, itemstackInHand.m_41777_(), true);
                    this.m_146852_(GameEvent.f_157792_, (Entity)p_31787_);
                    if (!p_31787_.m_150110_().f_35937_) {
                        itemstackInHand.m_41774_(1);
                    }
                }
            } else {
                this.m_5496_(this.getRotateItemSound(), 1.0f, 1.0f);
                this.setRotation(slot, this.getRotation(slot) + 1);
                this.m_146852_(GameEvent.f_157792_, (Entity)p_31787_);
            }
            return InteractionResult.CONSUME;
        }
        return !hasAny && !hasHeld ? InteractionResult.PASS : InteractionResult.SUCCESS;
    }

    public SoundEvent getRotateItemSound() {
        return SoundEvents.f_12017_;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this, this.f_31699_.m_122411_(), this.m_31748_());
    }

    public void m_141965_(ClientboundAddEntityPacket p_149626_) {
        super.m_141965_(p_149626_);
        this.m_6022_(Direction.m_122376_((int)p_149626_.m_131509_()));
    }

    public ItemStack m_142340_() {
        for (int i = 0; i < 4; ++i) {
            ItemStack s = this.getItem(i);
            if (s.m_41619_()) continue;
            return s.m_41777_();
        }
        return this.getFrameItemStack();
    }

    protected ItemStack getFrameItemStack() {
        return new ItemStack((ItemLike)ItemInit.QUAD_ITEM_FRAME.get());
    }

    public float m_213816_() {
        Direction direction = this.m_6350_();
        int i = direction.m_122434_().m_122478_() ? 90 * direction.m_122421_().m_122540_() : 0;
        return Mth.m_14098_((int)(180 + direction.m_122416_() * 90 + this.getRotation(0) * 45 + i));
    }
}

