/*
 * Decompiled with CFR 0.152.
 */
package com.mysiupysiu.bignay.events;

import com.mysiupysiu.bignay.items.ItemInit;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="bignay", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class TotemEvents {
    private static final String USED_TOTEM_TAG_TIME = "bignay:used_totem_time";
    private static final long TOTEM_TAG_VALID_TICKS = 40L;

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onLivingAttack(LivingAttackEvent event) {
        float currentHealth;
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        if (!(event.getEntity() instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)event.getEntity();
        if (player.m_9236_().f_46443_) {
            return;
        }
        float damage = event.getAmount();
        if (damage < (currentHealth = player.m_21223_())) {
            return;
        }
        ItemStack stack = TotemEvents.findTotemInHand(player);
        if (stack.m_41619_()) {
            return;
        }
        boolean consumed = TotemEvents.consumeTotem(player, stack);
        if (!consumed) {
            return;
        }
        event.setCanceled(true);
        CompoundTag tag = player.getPersistentData();
        try {
            long time = player.m_9236_().m_46467_();
            tag.m_128356_(USED_TOTEM_TAG_TIME, time);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        player.m_21153_(Math.max(1.0f, player.m_21233_() / 2.0f));
        player.m_36324_().m_38705_(20);
        player.m_36324_().m_38717_(5.0f);
        try {
            player.f_19802_ = 20;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        TotemEvents.teleportToRespawnSafe(player);
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onLivingDeath(LivingDeathEvent event) {
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        if (!(event.getEntity() instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)event.getEntity();
        if (player.m_9236_().f_46443_) {
            return;
        }
        ItemStack stack = TotemEvents.findTotemInHand(player);
        CompoundTag tag = player.getPersistentData();
        boolean hadFreshTag = TotemEvents.hasFreshTotemTag(tag, player);
        boolean consumed = false;
        if (!stack.m_41619_()) {
            consumed = TotemEvents.consumeTotem(player, stack);
        }
        if (consumed || hadFreshTag) {
            try {
                long time = player.m_9236_().m_46467_();
                tag.m_128356_(USED_TOTEM_TAG_TIME, time);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            event.setCanceled(true);
            player.m_21153_(Math.max(1.0f, player.m_21233_() / 2.0f));
            player.m_36324_().m_38705_(20);
            player.m_36324_().m_38717_(5.0f);
            try {
                player.f_19802_ = 20;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            TotemEvents.teleportToRespawnSafe(player);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onLivingDrops(LivingDropsEvent event) {
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        if (!(event.getEntity() instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)event.getEntity();
        if (player.m_9236_().f_46443_) {
            return;
        }
        CompoundTag tag = player.getPersistentData();
        boolean hasFreshTag = TotemEvents.hasFreshTotemTag(tag, player);
        if (hasFreshTag) {
            try {
                event.getDrops().clear();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        if (!event.isWasDeath()) {
            return;
        }
        Player original = event.getOriginal();
        Player cloned = event.getEntity();
        if (!(original instanceof ServerPlayer) || !(cloned instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer oldP = (ServerPlayer)original;
        ServerPlayer newP = (ServerPlayer)cloned;
        try {
            ItemStack s;
            int i;
            CompoundTag oldTag = oldP.getPersistentData();
            boolean hadFreshTag = TotemEvents.hasFreshTotemTag(oldTag, oldP);
            if (!hadFreshTag) {
                return;
            }
            Inventory oldInv = oldP.m_150109_();
            Inventory newInv = newP.m_150109_();
            for (i = 0; i < Math.min(oldInv.f_35974_.size(), newInv.f_35974_.size()); ++i) {
                s = (ItemStack)oldInv.f_35974_.get(i);
                newInv.f_35974_.set(i, (Object)(s == null ? ItemStack.f_41583_ : s.m_41777_()));
            }
            for (i = 0; i < Math.min(oldInv.f_35975_.size(), newInv.f_35975_.size()); ++i) {
                s = (ItemStack)oldInv.f_35975_.get(i);
                newInv.f_35975_.set(i, (Object)(s == null ? ItemStack.f_41583_ : s.m_41777_()));
            }
            for (i = 0; i < Math.min(oldInv.f_35976_.size(), newInv.f_35976_.size()); ++i) {
                s = (ItemStack)oldInv.f_35976_.get(i);
                newInv.f_35976_.set(i, (Object)(s == null ? ItemStack.f_41583_ : s.m_41777_()));
            }
            int levels = oldP.f_36078_;
            if (levels > 0) {
                newP.m_6749_(levels);
            }
            newP.f_36079_ = oldP.f_36079_;
            newP.f_36080_ = oldP.f_36080_;
            newP.getPersistentData().m_128473_(USED_TOTEM_TAG_TIME);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static boolean hasFreshTotemTag(CompoundTag tag, ServerPlayer player) {
        if (tag == null || player == null || player.m_9236_() == null) {
            return false;
        }
        try {
            if (!tag.m_128441_(USED_TOTEM_TAG_TIME)) {
                return false;
            }
            long time = tag.m_128454_(USED_TOTEM_TAG_TIME);
            long now = player.m_9236_().m_46467_();
            long diff = now - time;
            return diff >= 0L && diff <= 40L;
        }
        catch (Throwable ignored) {
            return false;
        }
    }

    private static ItemStack findTotemInHand(ServerPlayer player) {
        ItemStack main = player.m_21205_();
        if (!main.m_41619_() && main.m_41720_() == ItemInit.TOTEM_OF_KEEPING_INVENTORY.get()) {
            return main;
        }
        ItemStack off = player.m_21206_();
        if (!off.m_41619_() && off.m_41720_() == ItemInit.TOTEM_OF_KEEPING_INVENTORY.get()) {
            return off;
        }
        return ItemStack.f_41583_;
    }

    private static boolean consumeTotem(ServerPlayer player, ItemStack stack) {
        if (stack == null || stack.m_41619_()) {
            return false;
        }
        stack.m_41774_(1);
        ServerLevel lvl = player.m_284548_();
        if (lvl != null) {
            lvl.m_5594_(null, player.m_20183_(), SoundEvents.f_12513_, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        return true;
    }

    private static void teleportToRespawnSafe(ServerPlayer player) {
        ServerLevel respawnLevel = player.f_8924_.m_129880_(player.m_8963_());
        if (respawnLevel == null) {
            respawnLevel = player.f_8924_.m_129880_(Level.f_46428_);
        }
        Vec3 targetPos = null;
        ServerLevel targetLevel = respawnLevel;
        BlockPos respawnPos = player.m_8961_();
        float angle = player.m_8962_();
        boolean forced = player.m_8964_();
        if (respawnPos != null && respawnLevel != null) {
            try {
                Optional optional = ServerPlayer.m_36130_((ServerLevel)respawnLevel, (BlockPos)respawnPos, (float)angle, (boolean)forced, (boolean)false);
                if (optional.isPresent()) {
                    BlockPos p = BlockPos.m_274446_((Position)((Position)optional.get()));
                    targetPos = new Vec3((double)p.m_123341_() + 0.5, (double)p.m_123342_(), (double)p.m_123343_() + 0.5);
                    targetLevel = respawnLevel;
                }
            }
            catch (Throwable optional) {
                // empty catch block
            }
        }
        if (targetPos == null) {
            ServerLevel overworld = player.f_8924_.m_129880_(Level.f_46428_);
            if (overworld == null) {
                return;
            }
            targetLevel = overworld;
            BlockPos spawn = overworld.m_220360_();
            int chunkRadius = 1;
            int attempts = 10;
            for (int i = 0; i < attempts && targetPos == null; ++i) {
                int offsetZ;
                int offsetX = player.m_217043_().m_188503_(chunkRadius * 16 * 2 + 1) - chunkRadius * 16;
                BlockPos candidate = spawn.m_7918_(offsetX, 0, offsetZ = player.m_217043_().m_188503_(chunkRadius * 16 * 2 + 1) - chunkRadius * 16);
                BlockPos safe = overworld.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, candidate);
                if (safe == null || safe.m_123342_() <= 0 || safe.m_123342_() >= overworld.m_151558_()) continue;
                targetPos = new Vec3((double)safe.m_123341_() + 0.5, (double)safe.m_123342_(), (double)safe.m_123343_() + 0.5);
            }
            if (targetPos == null) {
                BlockPos safe = overworld.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, spawn);
                if (safe == null) {
                    safe = spawn;
                }
                targetPos = new Vec3((double)safe.m_123341_() + 0.5, (double)safe.m_123342_(), (double)safe.m_123343_() + 0.5);
            }
        }
        try {
            player.m_8999_(targetLevel, targetPos.f_82479_, targetPos.f_82480_, targetPos.f_82481_, player.m_146908_(), player.m_146909_());
            player.m_20256_(Vec3.f_82478_);
        }
        catch (Throwable t) {
            try {
                ServerLevel overworld = player.f_8924_.m_129880_(Level.f_46428_);
                if (overworld == null) {
                    return;
                }
                BlockPos fallback = overworld.m_220360_();
                BlockPos safe = overworld.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, fallback);
                if (safe == null) {
                    safe = fallback;
                }
                Vec3 pos = new Vec3((double)safe.m_123341_() + 0.5, (double)safe.m_123342_(), (double)safe.m_123343_() + 0.5);
                player.m_8999_(overworld, pos.f_82479_, pos.f_82480_, pos.f_82481_, player.m_146908_(), player.m_146909_());
                player.m_20256_(Vec3.f_82478_);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        try {
            player.m_21153_(20.0f);
            player.m_36324_().m_38705_(20);
            player.m_36324_().m_38717_(5.0f);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

