/*
 * Decompiled with CFR 0.152.
 */
package com.mysiupysiu.bignay.utils;

import com.mysiupysiu.bignay.utils.ProgressListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import net.minecraft.world.level.storage.LevelStorageSource;

public class WorldExporter {
    private final LevelStorageSource.LevelStorageAccess levelAccess;
    private final File source;
    private ProgressListener progressListener;
    private volatile boolean canceled = false;
    private File destination;
    private String worldName;
    private boolean exportPlayerData;

    public WorldExporter(LevelStorageSource.LevelStorageAccess levelAccess, File source) {
        this.levelAccess = levelAccess;
        this.source = source;
    }

    public void execute() {
        File outputZip = new File(this.destination, this.worldName + ".zip");
        long totalSize = this.calculateTotalSize(this.source);
        long[] processed = new long[]{0L};
        try (FileOutputStream fos = new FileOutputStream(outputZip);
             ZipOutputStream zos = new ZipOutputStream(fos);){
            this.zipFolderRecursive(this.source, this.source.getName(), zos, processed, totalSize);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (this.canceled && outputZip.exists()) {
            outputZip.delete();
        }
        this.close();
    }

    private long calculateTotalSize(File folder) {
        long size = 0L;
        File[] files = folder.listFiles();
        if (files == null) {
            return 0L;
        }
        for (File f : files) {
            if (f.isDirectory()) {
                size += this.calculateTotalSize(f);
                continue;
            }
            size += f.length();
        }
        return size;
    }

    private void zipFolderRecursive(File folder, String parentPath, ZipOutputStream zos, long[] processed, long totalSize) throws IOException {
        File[] files = folder.listFiles();
        if (files == null) {
            return;
        }
        Set<String> playerDataFolders = Set.of("advancements", "playerdata", "stats");
        for (File file : files) {
            String entryName = parentPath + "/" + file.getName();
            if (file.isDirectory() && !this.exportPlayerData && playerDataFolders.contains(file.getName().toLowerCase())) continue;
            if (file.isDirectory()) {
                zos.putNextEntry(new ZipEntry(entryName + "/"));
                zos.closeEntry();
                this.zipFolderRecursive(file, entryName, zos, processed, totalSize);
                continue;
            }
            try (FileInputStream fis = new FileInputStream(file);){
                int len;
                zos.putNextEntry(new ZipEntry(entryName));
                byte[] buffer = new byte[4096];
                while ((len = fis.read(buffer)) != -1 && !this.canceled) {
                    zos.write(buffer, 0, len);
                    processed[0] = processed[0] + (long)len;
                    if (this.progressListener == null || totalSize <= 0L) continue;
                    double progress = (double)processed[0] / (double)totalSize;
                    this.progressListener.onProgress(progress);
                }
                zos.closeEntry();
            }
        }
    }

    public File getSource() {
        return this.source;
    }

    public File getDestination() {
        return this.destination;
    }

    public void setDestination(File destination) {
        this.destination = destination;
    }

    public String getWorldName() {
        return this.worldName;
    }

    public void setWorldName(String worldName) {
        this.worldName = worldName;
    }

    public boolean isExportPlayerData() {
        return this.exportPlayerData;
    }

    public void setExportPlayerData(boolean exportPlayerData) {
        this.exportPlayerData = exportPlayerData;
    }

    public void setProgressListener(ProgressListener listener) {
        this.progressListener = listener;
    }

    public ProgressListener getProgressListener() {
        return this.progressListener;
    }

    public void cancel() {
        this.canceled = true;
        this.close();
    }

    public void close() {
        try {
            this.levelAccess.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

