/*
 * Decompiled with CFR 0.152.
 */
package com.mysiupysiu.bignay.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.registries.ForgeRegistries;

public class HollowLogBlock
extends RotatedPillarBlock
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;

    public HollowLogBlock() {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_49999_).m_60955_());
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_55923_, (Comparable)Direction.Axis.Y)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_55923_, WATERLOGGED});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        FluidState fluid = context.m_43725_().m_6425_(context.m_8083_());
        boolean isWater = fluid.m_76152_() == Fluids.f_76193_;
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_55923_, (Comparable)context.m_43719_().m_122434_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(isWater));
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public boolean m_7923_(BlockState state) {
        return true;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext ctx) {
        return this.getHollowShape((Direction.Axis)state.m_61143_((Property)f_55923_));
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext ctx) {
        return this.m_5940_(state, world, pos, ctx);
    }

    private VoxelShape getHollowShape(Direction.Axis axis) {
        return switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.Axis.X -> Shapes.m_83113_((VoxelShape)Shapes.m_83144_(), (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.125, (double)0.125, (double)1.0, (double)0.875, (double)0.875), (BooleanOp)BooleanOp.f_82685_);
            case Direction.Axis.Y -> Shapes.m_83113_((VoxelShape)Shapes.m_83144_(), (VoxelShape)Shapes.m_83048_((double)0.125, (double)0.0, (double)0.125, (double)0.875, (double)1.0, (double)0.875), (BooleanOp)BooleanOp.f_82685_);
            case Direction.Axis.Z -> Shapes.m_83113_((VoxelShape)Shapes.m_83144_(), (VoxelShape)Shapes.m_83048_((double)0.125, (double)0.125, (double)0.0, (double)0.875, (double)0.875, (double)1.0), (BooleanOp)BooleanOp.f_82685_);
        };
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BucketItem bucket;
        Item item;
        ResourceLocation key;
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_41720_() instanceof AxeItem && (key = ForgeRegistries.BLOCKS.getKey((Object)this)) != null && !key.m_135815_().contains("stripped")) {
            String newName = "hollow_stripped_" + key.m_135815_().substring(7);
            Block stripped = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(key.m_135827_(), newName));
            if (stripped != null && stripped != Blocks.f_50016_) {
                BlockState ns = (BlockState)((BlockState)stripped.m_49966_().m_61124_((Property)f_55923_, (Comparable)((Direction.Axis)state.m_61143_((Property)f_55923_)))).m_61124_((Property)WATERLOGGED, (Comparable)((Boolean)state.m_61143_((Property)WATERLOGGED)));
                level.m_7731_(pos, ns, 11);
                level.m_5594_(player, pos, SoundEvents.f_11688_, SoundSource.BLOCKS, 1.0f, 1.0f);
                if (!level.m_5776_()) {
                    stack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
                }
                return InteractionResult.m_19078_((boolean)level.m_5776_());
            }
        }
        if ((item = stack.m_41720_()) instanceof BucketItem && (bucket = (BucketItem)item).getFluid() == Fluids.f_76193_ && !((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            if (!level.m_5776_()) {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true)), 3);
                level.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
                level.m_5594_(player, pos, SoundEvents.f_11778_, SoundSource.BLOCKS, 1.0f, 1.0f);
                if (!player.m_7500_()) {
                    player.m_21008_(hand, new ItemStack((ItemLike)Items.f_42446_));
                }
            }
            return InteractionResult.m_19078_((boolean)level.m_5776_());
        }
        if (stack.m_41720_() == Items.f_42446_ && ((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            if (!level.m_5776_()) {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)), 3);
                level.m_5594_(player, pos, SoundEvents.f_11781_, SoundSource.BLOCKS, 1.0f, 1.0f);
                if (!player.m_7500_()) {
                    player.m_21008_(hand, new ItemStack((ItemLike)Items.f_42447_));
                }
            }
            return InteractionResult.m_19078_((boolean)level.m_5776_());
        }
        return super.m_6227_(state, level, pos, player, hand, hit);
    }
}

