/*
 * Decompiled with CFR 0.152.
 */
package com.mysiupysiu.bignay.blocks;

import com.mysiupysiu.bignay.blocks.BlockEntityInit;
import com.mysiupysiu.bignay.blocks.BlockInit;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class CustomCampfireBlockEntity
extends BlockEntity {
    private static final Map<Block, BlockEntityType<CustomCampfireBlockEntity>> ENTITY_TYPES = new HashMap<Block, BlockEntityType<CustomCampfireBlockEntity>>();
    private final NonNullList<ItemStack> items = NonNullList.m_122780_((int)4, (Object)ItemStack.f_41583_);
    private final int[] cookingProgress = new int[4];
    private final int[] cookingTimeTotal = new int[4];

    public CustomCampfireBlockEntity(BlockPos pos, BlockState state) {
        super(CustomCampfireBlockEntity.getEntityType(state.m_60734_()), pos, state);
    }

    private static BlockEntityType<CustomCampfireBlockEntity> getEntityType(Block block) {
        return ENTITY_TYPES.getOrDefault(block, (BlockEntityType<CustomCampfireBlockEntity>)((BlockEntityType)BlockEntityInit.OAK_CAMPFIRE.get()));
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, CustomCampfireBlockEntity campfire) {
        if (!((Boolean)state.m_61143_((Property)CampfireBlock.f_51227_)).booleanValue()) {
            return;
        }
        for (int i = 0; i < campfire.items.size(); ++i) {
            ItemStack stack = (ItemStack)campfire.items.get(i);
            if (stack.m_41619_()) continue;
            int n = i;
            campfire.cookingProgress[n] = campfire.cookingProgress[n] + 1;
            if (campfire.cookingProgress[i] < campfire.cookingTimeTotal[i]) continue;
            ItemStack result = CustomCampfireBlockEntity.getCookingResult(level, stack);
            if (!result.m_41619_()) {
                double x = (double)pos.m_123341_() + 0.4 + 0.2 * (double)(i % 2);
                double z = (double)pos.m_123343_() + 0.4 + 0.2 * (double)(i / 2);
                level.m_7967_((Entity)new ItemEntity(level, x, (double)pos.m_123342_() + 0.5, z, result.m_41777_()));
            }
            campfire.setItem(i, ItemStack.f_41583_);
            campfire.cookingProgress[i] = 0;
            campfire.cookingTimeTotal[i] = 0;
            campfire.m_6596_();
            level.m_7260_(pos, state, state, 3);
            campfire.syncToClient();
        }
    }

    public static void registerEntityTypes() {
        CustomCampfireBlockEntity.add(BlockInit.ACACIA_CAMPFIRE, BlockEntityInit.ACACIA_CAMPFIRE);
        CustomCampfireBlockEntity.add(BlockInit.BIRCH_CAMPFIRE, BlockEntityInit.BIRCH_CAMPFIRE);
        CustomCampfireBlockEntity.add(BlockInit.CHERRY_CAMPFIRE, BlockEntityInit.CHERRY_CAMPFIRE);
        CustomCampfireBlockEntity.add(BlockInit.CRIMSON_CAMPFIRE, BlockEntityInit.CRIMSON_CAMPFIRE);
        CustomCampfireBlockEntity.add(BlockInit.DARK_OAK_CAMPFIRE, BlockEntityInit.DARK_OAK_CAMPFIRE);
        CustomCampfireBlockEntity.add(BlockInit.JUNGLE_CAMPFIRE, BlockEntityInit.JUNGLE_CAMPFIRE);
        CustomCampfireBlockEntity.add(BlockInit.MANGROVE_CAMPFIRE, BlockEntityInit.MANGROVE_CAMPFIRE);
        CustomCampfireBlockEntity.add(BlockInit.OAK_CAMPFIRE, BlockEntityInit.OAK_CAMPFIRE);
        CustomCampfireBlockEntity.add(BlockInit.SPRUCE_CAMPFIRE, BlockEntityInit.SPRUCE_CAMPFIRE);
        CustomCampfireBlockEntity.add(BlockInit.WARPED_CAMPFIRE, BlockEntityInit.WARPED_CAMPFIRE);
        CustomCampfireBlockEntity.add(BlockInit.VERDANT_CAMPFIRE, BlockEntityInit.VERDANT_CAMPFIRE);
        CustomCampfireBlockEntity.add(BlockInit.SOUL_ACACIA_CAMPFIRE, BlockEntityInit.SOUL_ACACIA_CAMPFIRE);
        CustomCampfireBlockEntity.add(BlockInit.SOUL_BIRCH_CAMPFIRE, BlockEntityInit.SOUL_BIRCH_CAMPFIRE);
        CustomCampfireBlockEntity.add(BlockInit.SOUL_CHERRY_CAMPFIRE, BlockEntityInit.SOUL_CHERRY_CAMPFIRE);
        CustomCampfireBlockEntity.add(BlockInit.SOUL_CRIMSON_CAMPFIRE, BlockEntityInit.SOUL_CRIMSON_CAMPFIRE);
        CustomCampfireBlockEntity.add(BlockInit.SOUL_DARK_OAK_CAMPFIRE, BlockEntityInit.SOUL_DARK_OAK_CAMPFIRE);
        CustomCampfireBlockEntity.add(BlockInit.SOUL_JUNGLE_CAMPFIRE, BlockEntityInit.SOUL_JUNGLE_CAMPFIRE);
        CustomCampfireBlockEntity.add(BlockInit.SOUL_MANGROVE_CAMPFIRE, BlockEntityInit.SOUL_MANGROVE_CAMPFIRE);
        CustomCampfireBlockEntity.add(BlockInit.SOUL_OAK_CAMPFIRE, BlockEntityInit.SOUL_OAK_CAMPFIRE);
        CustomCampfireBlockEntity.add(BlockInit.SOUL_SPRUCE_CAMPFIRE, BlockEntityInit.SOUL_SPRUCE_CAMPFIRE);
        CustomCampfireBlockEntity.add(BlockInit.SOUL_WARPED_CAMPFIRE, BlockEntityInit.SOUL_WARPED_CAMPFIRE);
        CustomCampfireBlockEntity.add(BlockInit.SOUL_VERDANT_CAMPFIRE, BlockEntityInit.SOUL_VERDANT_CAMPFIRE);
    }

    private static void add(Supplier<Block> blockSupplier, Supplier<BlockEntityType<CustomCampfireBlockEntity>> entitySupplier) {
        ENTITY_TYPES.put(blockSupplier.get(), entitySupplier.get());
    }

    public boolean placeFood(ItemStack stack, int slot) {
        if (slot >= 0 && slot < 4 && ((ItemStack)this.items.get(slot)).m_41619_()) {
            if (!CustomCampfireBlockEntity.hasCampfireRecipe(this.f_58857_, stack)) {
                return false;
            }
            ItemStack single = stack.m_41777_();
            single.m_41764_(1);
            this.items.set(slot, (Object)single);
            this.cookingTimeTotal[slot] = CustomCampfireBlockEntity.getCookTime(this.f_58857_, single);
            this.cookingProgress[slot] = 0;
            this.m_6596_();
            this.syncToClient();
            return true;
        }
        return false;
    }

    private static boolean hasCampfireRecipe(Level level, ItemStack stack) {
        return level.m_7465_().m_44015_(RecipeType.f_44111_, (Container)new SimpleContainer(new ItemStack[]{stack}), level).isPresent();
    }

    public ItemStack getItem(int index) {
        return (ItemStack)this.items.get(index);
    }

    private static int getCookTime(Level level, ItemStack stack) {
        return level.m_7465_().m_44015_(RecipeType.f_44111_, (Container)new SimpleContainer(new ItemStack[]{stack}), level).map(r -> r.m_43753_()).orElse(200);
    }

    private static ItemStack getCookingResult(Level level, ItemStack stack) {
        return level.m_7465_().m_44015_(RecipeType.f_44111_, (Container)new SimpleContainer(new ItemStack[]{stack}), level).map(r -> r.m_8043_(level.m_9598_())).orElse(ItemStack.f_41583_);
    }

    public void syncToClient() {
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ClientboundBlockEntityDataPacket packet = this.getUpdatePacket();
            if (packet != null) {
                serverLevel.m_7726_().f_8325_.m_183262_(serverLevel.m_46745_(this.f_58858_).m_7697_(), false).forEach(player -> player.f_8906_.m_9829_((Packet)packet));
            }
        }
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        this.m_183515_(tag);
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.m_142466_(tag);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        ContainerHelper.m_18980_((CompoundTag)tag, this.items);
        for (int i = 0; i < 4; ++i) {
            this.cookingProgress[i] = tag.m_128451_("CookingProgress" + i);
            this.cookingTimeTotal[i] = tag.m_128451_("CookingTimeTotal" + i);
        }
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        ContainerHelper.m_18973_((CompoundTag)tag, this.items);
        for (int i = 0; i < 4; ++i) {
            tag.m_128405_("CookingProgress" + i, this.cookingProgress[i]);
            tag.m_128405_("CookingTimeTotal" + i, this.cookingTimeTotal[i]);
        }
    }

    public void setItem(int index, ItemStack stack) {
        if (index >= 0 && index < this.items.size()) {
            this.items.set(index, (Object)stack);
            this.m_6596_();
        }
    }

    static {
        CustomCampfireBlockEntity.registerEntityTypes();
    }
}

