/*
 * Decompiled with CFR 0.152.
 */
package com.mysiupysiu.bignay.screen.file.chooser;

import com.mysiupysiu.bignay.utils.FileType;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

abstract class AbstractFileChooserScreen
extends Screen {
    private static final int MARGIN = 20;
    private static final int LINE_HEIGHT = 11;
    private static final int VISIBLE_LINES = 15;
    private Screen previousScreen;
    private Path currentDir;
    private List<File> entries;
    private Consumer<File> onConfirm;
    protected Set<FileType> fileTypes;
    private int scroll = 0;
    private int selectedIndex = -1;
    private boolean showHidden = false;
    private final boolean requireDirectory = this.isRequireDirectory();
    private long lastClickTime = 0L;
    private int lastClickedIndex = -1;
    private Button refreshButton;
    private Button hiddenToggleButton;
    private Button homeButton;
    private Button upButton;

    public AbstractFileChooserScreen(Component component) {
        super(component);
        this.fileTypes = new LinkedHashSet<FileType>();
        this.goHome();
        this.reloadEntries();
    }

    protected abstract Stream<File> getFiles(File[] var1);

    protected abstract boolean isRequireDirectory();

    protected void m_7856_() {
        super.m_7856_();
        int btnWidth = 98;
        int btnHeight = 20;
        int btnY = 24;
        int spacing = 10;
        int hiddenX = this.f_96543_ - 20 - btnWidth - 20;
        int upX = hiddenX - btnWidth - spacing;
        int homeX = upX - btnWidth - spacing;
        this.refreshButton = Button.m_253074_((Component)Component.m_237115_((String)"fileChooser.refresh"), b -> this.reloadEntries()).m_252987_(20, btnY, btnWidth, btnHeight).m_253136_();
        this.m_142416_((GuiEventListener)this.refreshButton);
        this.homeButton = Button.m_253074_((Component)Component.m_237115_((String)"fileChooser.home"), b -> this.goHome()).m_252987_(homeX, btnY, btnWidth, btnHeight).m_253136_();
        this.m_142416_((GuiEventListener)this.homeButton);
        this.upButton = Button.m_253074_((Component)Component.m_237115_((String)"fileChooser.up"), b -> this.goUp()).m_252987_(upX, btnY, btnWidth, btnHeight).m_253136_();
        this.m_142416_((GuiEventListener)this.upButton);
        this.hiddenToggleButton = Button.m_253074_((Component)this.getHiddenFilesButtonLabel(), b -> this.toggleHiddenFiles()).m_252987_(hiddenX, btnY, btnWidth, btnHeight).m_253136_();
        this.m_142416_((GuiEventListener)this.hiddenToggleButton);
        int listY = 68;
        int listEndY = listY + 165;
        int confirmY = listEndY + 30;
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"fileChooser.confirm"), b -> {
            if (this.onConfirm != null) {
                File target = this.selectedIndex >= 0 && this.selectedIndex < this.entries.size() ? this.entries.get(this.selectedIndex) : this.currentDir.toFile();
                boolean isDirectory = target.isDirectory();
                if (isDirectory) {
                    if (!this.requireDirectory) {
                        this.currentDir = target.toPath();
                        this.reloadEntries();
                    } else {
                        this.onConfirm.accept(target);
                    }
                } else {
                    this.onConfirm.accept(target);
                }
            }
        }).m_252987_(upX, confirmY, btnWidth, btnHeight).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"fileChooser.cancel"), b -> Minecraft.m_91087_().m_91152_(this.previousScreen)).m_252987_(hiddenX, confirmY, btnWidth, btnHeight).m_253136_());
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        this.m_280273_(graphics);
        graphics.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 10, 0xFFFFFF);
        graphics.m_280056_(this.f_96547_, "Current path: " + this.currentDir.toString(), 20, 48, 0xAAAAAA, false);
        this.refreshButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"fileChooser.refresh.description")));
        this.refreshButton.m_257427_(200);
        this.homeButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"fileChooser.home.description")));
        this.homeButton.m_257427_(200);
        this.upButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"fileChooser.up.description")));
        this.upButton.m_257427_(200);
        int listX = 20;
        int listY = 68;
        int listW = this.f_96543_ - 40;
        graphics.m_280509_(listX - 2, listY - 2, listX + listW + 2, listY + 165 + 6, -2013265920);
        for (int i = 0; i < 15; ++i) {
            int color;
            int idx = i + this.scroll;
            int y = listY + i * 11;
            if (idx >= this.entries.size()) break;
            File f = this.entries.get(idx);
            String prefix = f.isDirectory() ? "[DIR] " : "      ";
            int n = color = f.isDirectory() ? 0xAADDAA : 0xFFFFFF;
            if (idx == this.selectedIndex) {
                graphics.m_280509_(listX, y - 2, listX + listW, y + 11, 0x40FFFFFF);
            }
            graphics.m_280056_(this.f_96547_, prefix + f.getName(), listX + 4, y, color, false);
        }
        super.m_88315_(graphics, mouseX, mouseY, delta);
    }

    public boolean m_6050_(double mouseX, double mouseY, double amount) {
        this.scroll = amount < 0.0 ? Math.min(this.scroll + 1, Math.max(0, this.entries.size() - 15)) : Math.max(this.scroll - 1, 0);
        return true;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        int localY;
        int line;
        int idx;
        int listX = 20;
        int listY = 68;
        int listW = this.f_96543_ - 40;
        if (mouseX >= (double)listX && mouseX <= (double)(listX + listW) && mouseY >= (double)listY && mouseY <= (double)(listY + 165) && (idx = this.scroll + (line = (localY = (int)mouseY - listY) / 11)) >= 0 && idx < this.entries.size()) {
            File f = this.entries.get(idx);
            long now = System.currentTimeMillis();
            boolean doubleClick = idx == this.lastClickedIndex && now - this.lastClickTime < 250L;
            this.lastClickTime = now;
            this.lastClickedIndex = idx;
            if (doubleClick) {
                if (f.isDirectory()) {
                    this.currentDir = f.toPath();
                    this.reloadEntries();
                } else {
                    this.onConfirm.accept(this.entries.get(this.selectedIndex));
                }
            } else {
                this.selectedIndex = idx;
            }
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 265) {
            this.selectedIndex = Math.max(0, this.selectedIndex - 1);
            if (this.selectedIndex < this.scroll) {
                this.scroll = this.selectedIndex;
            }
            return true;
        }
        if (keyCode == 256) {
            Minecraft.m_91087_().m_91152_(this.previousScreen);
            return true;
        }
        if (keyCode == 264) {
            this.selectedIndex = Math.min(this.entries.size() - 1, this.selectedIndex + 1);
            if (this.selectedIndex >= this.scroll + 15) {
                this.scroll = this.selectedIndex - 15 + 1;
            }
            return true;
        }
        if ((keyCode == 257 || keyCode == 335) && this.selectedIndex >= 0 && this.selectedIndex < this.entries.size()) {
            File f = this.entries.get(this.selectedIndex);
            if (f.isDirectory()) {
                this.currentDir = f.toPath();
                this.reloadEntries();
            } else {
                Minecraft.m_91087_().m_91152_(null);
            }
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public void setOnConfirm(Consumer<File> onConfirm) {
        this.onConfirm = onConfirm;
    }

    private void goUp() {
        Path parent = this.currentDir.getParent();
        if (parent != null) {
            this.currentDir = parent;
            this.reloadEntries();
        }
    }

    protected void reloadEntries() {
        File dir = this.currentDir.toFile();
        File[] files = dir.listFiles();
        if (files == null) {
            files = new File[]{};
        }
        this.entries = this.getFiles(files).filter(f -> !f.isHidden() || this.showHidden).sorted(Comparator.comparing(f -> !f.isDirectory()).thenComparing(File::getName, String.CASE_INSENSITIVE_ORDER)).collect(Collectors.toList());
        this.scroll = 0;
        this.selectedIndex = -1;
    }

    private void toggleHiddenFiles() {
        this.showHidden = !this.showHidden;
        this.reloadEntries();
        this.hiddenToggleButton.m_93666_(this.getHiddenFilesButtonLabel());
    }

    public Screen getPreviousScreen() {
        return this.previousScreen;
    }

    public void setPreviousScreen(Screen previousScreen) {
        this.previousScreen = previousScreen;
    }

    private Component getHiddenFilesButtonLabel() {
        return Component.m_237115_((String)("fileChooser.hidden_files_" + (this.showHidden ? "on" : "off")));
    }

    private void goHome() {
        this.currentDir = Paths.get(System.getProperty("user.home", "."), new String[0]);
        this.reloadEntries();
    }
}

