/*
 * Decompiled with CFR 0.152.
 */
package com.mysiupysiu.bignay.utils;

import com.mysiupysiu.bignay.utils.ProgressListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;

public class WorldImporter {
    private ProgressListener progressListener;
    private final File source;
    private Path target;
    private String worldName;
    private volatile boolean canceled = false;

    public WorldImporter(File source) {
        this.source = source;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isValidWorld(File source) {
        try (ZipFile zip = new ZipFile(source);){
            HashSet<String> topLevelFolders = new HashSet<String>();
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                String name = entry.getName();
                if (name.equals("level.dat")) {
                    boolean bl = true;
                    return bl;
                }
                int slash = name.indexOf(47);
                if (slash <= 0) continue;
                String folder = name.substring(0, slash + 1);
                topLevelFolders.add(folder);
            }
            if (topLevelFolders.size() != 1) {
                boolean entry = false;
                return entry;
            }
            String onlyFolder = (String)topLevelFolders.iterator().next();
            boolean bl = zip.getEntry(onlyFolder + "level.dat") != null;
            return bl;
        }
        catch (IOException e) {
            return false;
        }
    }

    public void execute() {
        if (this.worldName == null || this.worldName.isEmpty()) {
            return;
        }
        this.target = Paths.get(System.getProperty("user.dir"), "saves", this.worldName);
        try (ZipFile zip = new ZipFile(this.source);){
            String topFolder = null;
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                String name = entry.getName();
                if (name.equals("level.dat")) {
                    topFolder = "";
                    break;
                }
                int slash = name.indexOf(47);
                if (slash <= 0) continue;
                topFolder = name.substring(0, slash + 1);
            }
            long totalSize = this.calculateTotalSize(zip);
            long processed = 0L;
            entries = zip.entries();
            while (entries.hasMoreElements() && !this.canceled) {
                ZipEntry entry = entries.nextElement();
                String name = entry.getName();
                if (topFolder != null && !topFolder.isEmpty() && name.startsWith(topFolder)) {
                    name = name.substring(topFolder.length());
                }
                if (name.isEmpty()) continue;
                Path outPath = this.target.resolve(name).normalize();
                if (entry.isDirectory()) {
                    Files.createDirectories(outPath, new FileAttribute[0]);
                    continue;
                }
                Files.createDirectories(outPath.getParent(), new FileAttribute[0]);
                InputStream is = zip.getInputStream(entry);
                try {
                    byte[] buffer = new byte[4096];
                    OutputStream os = Files.newOutputStream(outPath, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
                    try {
                        int len;
                        while ((len = is.read(buffer)) != -1 && !this.canceled) {
                            os.write(buffer, 0, len);
                            processed += (long)len;
                            if (this.progressListener == null || totalSize <= 0L) continue;
                            double progress = (double)processed / (double)totalSize;
                            this.progressListener.onProgress(progress);
                        }
                    }
                    finally {
                        if (os == null) continue;
                        os.close();
                    }
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
            if (!this.canceled) {
                this.updateWorldName();
            } else {
                this.deleteDirectory(this.target.toFile());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private long calculateTotalSize(ZipFile zip) {
        return zip.stream().filter(entry -> !entry.isDirectory()).mapToLong(ZipEntry::getSize).filter(size -> size > 0L).sum();
    }

    private void deleteDirectory(File dir) {
        if (!dir.exists()) {
            return;
        }
        File[] files = dir.listFiles();
        if (files != null) {
            for (File f : files) {
                if (f.isDirectory()) {
                    this.deleteDirectory(f);
                    continue;
                }
                f.delete();
            }
        }
        dir.delete();
    }

    public void updateWorldName() throws IOException {
        Path levelDatPath = this.target.resolve("level.dat");
        CompoundTag levelData = NbtIo.m_128939_((InputStream)Files.newInputStream(levelDatPath, new OpenOption[0]));
        CompoundTag data = levelData.m_128469_("Data");
        data.m_128359_("LevelName", this.worldName);
        NbtIo.m_128947_((CompoundTag)levelData, (OutputStream)Files.newOutputStream(levelDatPath, StandardOpenOption.WRITE));
    }

    public void setWorldName(String worldName) {
        if (worldName == null || worldName.isBlank()) {
            return;
        }
        this.worldName = worldName;
    }

    public String getWorldName() {
        return this.worldName;
    }

    public File getSource() {
        return this.source;
    }

    public void setProgressListener(ProgressListener listener) {
        this.progressListener = listener;
    }

    public ProgressListener getProgressListener() {
        return this.progressListener;
    }

    public void cancel() {
        this.canceled = true;
    }
}

