/*
 * Decompiled with CFR 0.152.
 */
package com.mysiupysiu.bignay.entities;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.mysiupysiu.bignay.BignayMod;
import com.mysiupysiu.bignay.entities.GlowQuadItemFrameEntity;
import com.mysiupysiu.bignay.entities.GlowQuadItemFrameModel;
import com.mysiupysiu.bignay.entities.QuadItemFrameEntity;
import com.mysiupysiu.bignay.entities.QuadItemFrameModel;
import com.mysiupysiu.bignay.utils.BignayTags;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;

public class QuadItemFrameRenderer
extends EntityRenderer<QuadItemFrameEntity> {
    protected QuadItemFrameModel model;

    public QuadItemFrameRenderer(EntityRendererProvider.Context ctx) {
        super(ctx);
        this.model = new QuadItemFrameModel(ctx.m_174023_(BignayMod.ClientModEvents.QUAD_ITEM_FRAME_LAYER));
    }

    public void render(QuadItemFrameEntity entity, float yaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        poseStack.m_85836_();
        Direction dir = entity.m_6350_();
        BlockPos blockPos = entity.m_31748_();
        double blockCenterX = (double)blockPos.m_123341_() + 0.5;
        double blockCenterY = (double)blockPos.m_123342_() + 0.5;
        double blockCenterZ = (double)blockPos.m_123343_() + 0.5;
        double correction = 0.5;
        double desiredPivotX = blockCenterX - (double)dir.m_122429_() * correction;
        double desiredPivotY = blockCenterY - (double)dir.m_122430_() * correction;
        double desiredPivotZ = blockCenterZ - (double)dir.m_122431_() * correction;
        double entityX = entity.m_20185_();
        double entityY = entity.m_20186_();
        double entityZ = entity.m_20189_();
        double dx = desiredPivotX - entityX;
        double dy = desiredPivotY - entityY;
        double dz = desiredPivotZ - entityZ;
        poseStack.m_85837_(dx, dy, dz);
        switch (dir) {
            case NORTH: {
                poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
                break;
            }
            case WEST: {
                poseStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
                poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
                break;
            }
            case EAST: {
                poseStack.m_252781_(Axis.f_252436_.m_252977_(-90.0f));
                poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
                break;
            }
            case UP: {
                poseStack.m_252781_(Axis.f_252529_.m_252977_(-90.0f));
                break;
            }
            case DOWN: {
                poseStack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
                poseStack.m_252781_(Axis.f_252436_.m_252977_(0.0f));
            }
        }
        boolean isGlow = entity instanceof GlowQuadItemFrameEntity;
        VertexConsumer vc = buffer.m_6299_(isGlow ? RenderType.m_110485_((ResourceLocation)GlowQuadItemFrameModel.TEXTURE) : RenderType.m_110452_((ResourceLocation)QuadItemFrameModel.TEXTURE));
        this.model.m_7695_(poseStack, vc, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        float quadOffset = 0.18f;
        float depthOffset = 0.05f;
        for (int i = 0; i < 4; ++i) {
            float ty;
            float tx;
            ItemStack stack = entity.getItem(i);
            if (stack == null || stack.m_41619_()) continue;
            float scale = 0.5f;
            poseStack.m_85836_();
            if (dir == Direction.UP) {
                tx = i % 2 == 0 ? 0.18f : -0.18f;
                ty = i < 2 ? -0.18f : 0.18f;
            } else {
                tx = i % 2 == 0 ? -0.18f : 0.18f;
                float f = ty = i < 2 ? 0.18f : -0.18f;
            }
            if (stack.m_204117_(BignayTags.Items.BIG_ITEMS)) {
                scale = 0.35f;
            }
            poseStack.m_252880_(tx, ty, 0.05f);
            poseStack.m_85841_(scale, scale, scale);
            poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
            int rot = entity.getRotation(i);
            float rotDeg = (float)(rot % 8) * 45.0f;
            poseStack.m_252781_(Axis.f_252403_.m_252977_(rotDeg));
            int light = isGlow ? 0xF00080 : packedLight;
            Minecraft.m_91087_().m_91291_().m_269128_(stack, ItemDisplayContext.FIXED, light, OverlayTexture.f_118083_, poseStack, buffer, entity.m_9236_(), 0);
            poseStack.m_85849_();
        }
        poseStack.m_85849_();
        super.m_7392_((Entity)entity, yaw, partialTicks, poseStack, buffer, packedLight);
    }

    public ResourceLocation getTextureLocation(QuadItemFrameEntity entity) {
        return QuadItemFrameModel.TEXTURE;
    }
}

