/*
 * Decompiled with CFR 0.152.
 */
package com.mysiupysiu.bignay.events;

import com.mysiupysiu.bignay.items.ItemInit;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Blaze;
import net.minecraft.world.entity.monster.CaveSpider;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Drowned;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Husk;
import net.minecraft.world.entity.monster.MagmaCube;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class MobHeadDropEvent {
    private static final Set<Integer> USED_CREEPERS = new HashSet<Integer>();

    @SubscribeEvent
    public static void onLivingDrops(LivingDropsEvent event) {
        if (event.getEntity().m_9236_().f_46443_) {
            return;
        }
        LivingEntity mob = event.getEntity();
        DamageSource source = event.getSource();
        Entity attacker = source.m_7639_();
        Entity direct = source.m_7640_();
        Creeper creeper = null;
        if (attacker instanceof Creeper) {
            Creeper c;
            creeper = c = (Creeper)attacker;
        } else if (direct instanceof Creeper) {
            Creeper c;
            creeper = c = (Creeper)direct;
        }
        if (creeper == null || !creeper.m_7090_()) {
            return;
        }
        if (USED_CREEPERS.contains(creeper.m_19879_())) {
            return;
        }
        USED_CREEPERS.add(creeper.m_19879_());
        ItemStack dropStack = null;
        if (mob instanceof EnderMan) {
            dropStack = new ItemStack((ItemLike)ItemInit.ENDERMAN_HEAD.get());
        } else if (mob instanceof CaveSpider) {
            dropStack = new ItemStack((ItemLike)ItemInit.CAVE_SPIDER_HEAD.get());
        } else if (mob instanceof Spider) {
            dropStack = new ItemStack((ItemLike)ItemInit.SPIDER_HEAD.get());
        } else if (mob instanceof MagmaCube) {
            dropStack = new ItemStack((ItemLike)ItemInit.MAGMA_CUBE_HEAD.get());
        } else if (mob instanceof Drowned) {
            dropStack = new ItemStack((ItemLike)ItemInit.DROWNED_HEAD.get());
        } else if (mob instanceof Husk) {
            dropStack = new ItemStack((ItemLike)ItemInit.HUSK_HEAD.get());
        } else if (mob instanceof Blaze) {
            dropStack = new ItemStack((ItemLike)ItemInit.BLAZE_HEAD.get());
        } else if (mob instanceof Slime) {
            dropStack = new ItemStack((ItemLike)ItemInit.SLIME_HEAD.get());
        }
        if (dropStack == null) {
            return;
        }
        ItemEntity drop = new ItemEntity(mob.m_9236_(), mob.m_20185_(), mob.m_20186_(), mob.m_20189_(), dropStack);
        drop.m_32060_();
        event.getDrops().add(drop);
    }
}

