/*
 * Decompiled with CFR 0.152.
 */
package com.mysiupysiu.bignay.items;

import com.mysiupysiu.bignay.blocks.BlockInit;
import com.mysiupysiu.bignay.entities.GlowQuadItemFrameItem;
import com.mysiupysiu.bignay.entities.QuadItemFrameItem;
import com.mysiupysiu.bignay.items.DefaultItem;
import com.mysiupysiu.bignay.items.TotemOfKeepingInventory;
import com.mysiupysiu.bignay.items.WaxItem;
import com.mysiupysiu.bignay.items.WitherBoneMealItem;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemNameBlockItem;
import net.minecraft.world.item.SignItem;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class ItemInit {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"bignay");
    private static final List<RegistryObject<Item>> INGREDIENTS_TAB_ITEMS = new ArrayList<RegistryObject<Item>>();
    public static final RegistryObject<Item> WAX = ItemInit.registerItem("wax", WaxItem::new);
    public static final RegistryObject<Item> WITHER_BONE = ItemInit.registerItem("wither_bone", DefaultItem::new);
    public static final RegistryObject<Item> WITHER_BONE_MEAL = ItemInit.registerItem("wither_bone_meal", WitherBoneMealItem::new);
    public static final RegistryObject<Item> POTTER_SHERD = ItemInit.registerItem("pottery_sherd", DefaultItem::new);
    public static final RegistryObject<Item> TOTEM_OF_KEEPING_INVENTORY = ItemInit.registerItem("totem_of_keeping_inventory", TotemOfKeepingInventory::new);
    public static final RegistryObject<Item> RAVAGER_HIDE = ItemInit.registerItem("ravager_hide", DefaultItem::new);
    public static final RegistryObject<Item> QUAD_ITEM_FRAME = ItemInit.registerItem("quad_item_frame", () -> new QuadItemFrameItem(new Item.Properties().m_41487_(64)));
    public static final RegistryObject<Item> GLOW_QUAD_ITEM_FRAME = ItemInit.registerItem("glow_quad_item_frame", () -> new GlowQuadItemFrameItem(new Item.Properties().m_41487_(64)));
    public static final RegistryObject<Item> VERDANT_SIGN = ItemInit.registerItem("verdant_sign", () -> new SignItem(new Item.Properties().m_41487_(16), (Block)BlockInit.VERDANT_SIGN.get(), (Block)BlockInit.VERDANT_WALL_SIGN.get()));
    public static final RegistryObject<Item> VERDANT_HANGING_SIGN = ItemInit.registerItem("verdant_hanging_sign", () -> new SignItem(new Item.Properties().m_41487_(16), (Block)BlockInit.VERDANT_HANGING_SIGN.get(), (Block)BlockInit.VERDANT_WALL_HANGING_SIGN.get()));
    public static final RegistryObject<Item> PALE_PUMPKIN_SEEDS = ItemInit.registerItem("pale_pumpkin_seeds", () -> new ItemNameBlockItem((Block)BlockInit.PALE_PUMPKIN_STEM.get(), new Item.Properties()));

    private static RegistryObject<Item> registerItem(String name, Supplier<Item> supplier) {
        RegistryObject item = ITEMS.register(name, supplier);
        INGREDIENTS_TAB_ITEMS.add((RegistryObject<Item>)item);
        return item;
    }

    public static void register(IEventBus eventBus) {
        ITEMS.register(eventBus);
    }

    public static void addCreative(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey().equals((Object)CreativeModeTabs.f_256968_)) {
            INGREDIENTS_TAB_ITEMS.forEach(arg_0 -> ((BuildCreativeModeTabContentsEvent)event).accept(arg_0));
        }
    }
}

