/*
 * Decompiled with CFR 0.152.
 */
package com.mysiupysiu.bignay.blocks;

import com.mysiupysiu.bignay.blocks.CustomCampfireBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;

public class CustomCampfireBlock
extends CampfireBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;

    public CustomCampfireBlock(BlockBehaviour.Properties properties) {
        super(false, 1, properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_51227_, (Comparable)Boolean.valueOf(true))).m_61124_((Property)f_51228_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)f_51229_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new CustomCampfireBlockEntity(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        if (level.f_46443_) {
            return (lvl, pos, blockState, be) -> {
                if (((Boolean)blockState.m_61143_((Property)f_51227_)).booleanValue()) {
                    CustomCampfireBlock.addCampfireParticles(lvl, pos, (Boolean)blockState.m_61143_((Property)f_51228_));
                    if (this.isCampfire(state.m_60734_())) {
                        CustomCampfireBlockEntity.serverTick(level, pos, state, (CustomCampfireBlockEntity)be);
                    }
                }
            };
        }
        return this.isCampfire(state.m_60734_()) ? (lvl, pos, st, be) -> CustomCampfireBlockEntity.serverTick(lvl, pos, st, (CustomCampfireBlockEntity)be) : null;
    }

    private boolean isCampfire(Block block) {
        return BuiltInRegistries.f_256975_.m_7981_((Object)block).m_135815_().contains("campfire");
    }

    public static void addCampfireParticles(Level level, BlockPos pos, boolean signal) {
        RandomSource random = level.m_213780_();
        if (random.m_188501_() < 0.11f) {
            for (int i = 0; i < random.m_188503_(signal ? 3 : 2) + 1; ++i) {
                double dx = (double)pos.m_123341_() + 0.5;
                double dy = (double)pos.m_123342_() + 1.0;
                double dz = (double)pos.m_123343_() + 0.5;
                level.m_7106_((ParticleOptions)ParticleTypes.f_123777_, dx, dy, dz, 0.0, 0.07, 0.0);
            }
        }
        if (signal && random.m_188503_(5) == 0) {
            double dx = (double)pos.m_123341_() + 0.5;
            double dy = (double)pos.m_123342_() + 1.0;
            double dz = (double)pos.m_123343_() + 0.5;
            level.m_7106_((ParticleOptions)ParticleTypes.f_123778_, dx, dy, dz, 0.0, 0.07, 0.0);
        }
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        boolean water = context.m_43725_().m_6425_(context.m_8083_()).m_76152_() == Fluids.f_76193_;
        boolean signal = context.m_43725_().m_8055_(context.m_8083_().m_7495_()).m_60713_(Blocks.f_50335_);
        return (BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_())).m_61124_((Property)f_51229_, (Comparable)Boolean.valueOf(water))).m_61124_((Property)f_51227_, (Comparable)Boolean.valueOf(!water))).m_61124_((Property)f_51228_, (Comparable)Boolean.valueOf(signal));
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean moved) {
        if (!level.f_46443_) {
            boolean isSignalFire = level.m_8055_(pos.m_7495_()).m_60713_(Blocks.f_50335_);
            if ((Boolean)state.m_61143_((Property)f_51228_) != isSignalFire) {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)f_51228_, (Comparable)Boolean.valueOf(isSignalFire)), 3);
            }
        }
        super.m_6861_(state, level, pos, block, fromPos, moved);
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_51227_, f_51228_, f_51229_, FACING});
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack itemstack = player.m_21120_(hand);
        if (!((Boolean)state.m_61143_((Property)f_51227_)).booleanValue()) {
            if (itemstack.m_41720_() == Items.f_42409_ || itemstack.m_41720_() == Items.f_42613_) {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)f_51227_, (Comparable)Boolean.valueOf(true)), 3);
                level.m_5594_(null, pos, SoundEvents.f_11942_, SoundSource.BLOCKS, 1.0f, 1.0f);
                if (itemstack.m_41720_() == Items.f_42409_) {
                    itemstack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
                } else if (!player.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        }
        if (((Boolean)state.m_61143_((Property)f_51227_)).booleanValue() && itemstack.m_41720_() instanceof ShovelItem) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)f_51227_, (Comparable)Boolean.valueOf(false)), 3);
            level.m_5594_(null, pos, SoundEvents.f_11937_, SoundSource.BLOCKS, 1.0f, 10.0f);
            return InteractionResult.SUCCESS;
        }
        BlockEntity be = level.m_7702_(pos);
        if (be instanceof CustomCampfireBlockEntity) {
            CustomCampfireBlockEntity campfire = (CustomCampfireBlockEntity)be;
            for (int i = 0; i < 4; ++i) {
                if (!campfire.placeFood(itemstack, i)) continue;
                if (!player.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof CustomCampfireBlockEntity) {
                CustomCampfireBlockEntity campfireEntity = (CustomCampfireBlockEntity)blockEntity;
                for (int i = 0; i < 4; ++i) {
                    ItemStack itemstack = campfireEntity.getItem(i);
                    if (itemstack.m_41619_()) continue;
                    Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)itemstack);
                }
                level.m_46717_(pos, (Block)this);
            }
            super.m_6810_(state, level, pos, newState, isMoving);
        }
    }
}

