/*
 * Decompiled with CFR 0.152.
 */
package com.mateita.launchblocks;

import java.util.ArrayList;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.util.Vector;

public class LaunchBlocks
extends JavaPlugin
implements Listener {
    private double launchPower;
    private double launchHeight;
    private NamespacedKey launchBlockKey;

    @Override
    public void onEnable() {
        this.saveDefaultConfig();
        this.loadConfig();
        this.getServer().getPluginManager().registerEvents(this, this);
        this.getCommand("launchblock").setExecutor(this);
        this.launchBlockKey = new NamespacedKey(this, "launchblock");
        this.getLogger().info("LaunchBlocks has been enabled!");
    }

    @Override
    public void onDisable() {
        this.getLogger().info("LaunchBlocks has been disabled!");
    }

    private void loadConfig() {
        FileConfiguration config = this.getConfig();
        this.launchPower = config.getDouble("launch.power", 2.0);
        this.launchHeight = config.getDouble("launch.height", 0.5);
    }

    @Override
    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(String.valueOf((Object)ChatColor.RED) + "Only players can use this command!");
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("launchblocks.give")) {
            player.sendMessage(String.valueOf((Object)ChatColor.RED) + "You don't have permission to use this command!");
            return true;
        }
        ItemStack launchBlock = this.createLaunchBlock();
        player.getInventory().addItem(launchBlock);
        player.sendMessage(String.valueOf((Object)ChatColor.GREEN) + "You received a LaunchBlock!");
        return true;
    }

    private ItemStack createLaunchBlock() {
        ItemStack item = new ItemStack(Material.SLIME_BLOCK);
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(String.valueOf((Object)ChatColor.GREEN) + "LaunchBlock");
        ArrayList<String> lore = new ArrayList<String>();
        lore.add(String.valueOf((Object)ChatColor.GRAY) + "Place this block to create a launcher");
        lore.add(String.valueOf((Object)ChatColor.GRAY) + "Step on it to be launched forward!");
        meta.setLore(lore);
        meta.getPersistentDataContainer().set(this.launchBlockKey, PersistentDataType.BYTE, (byte)1);
        item.setItemMeta(meta);
        return item;
    }

    @EventHandler
    public void onPlayerMove(PlayerMoveEvent event) {
        Block slimeBlock;
        Player player = event.getPlayer();
        Block block = player.getLocation().subtract(0.0, 0.1, 0.0).getBlock();
        if (block.getType() == Material.SLIME_BLOCK && this.isLaunchBlock(slimeBlock = player.getWorld().getBlockAt(block.getLocation()))) {
            Vector direction = player.getLocation().getDirection().multiply(this.launchPower);
            direction.setY(this.launchHeight);
            player.setVelocity(direction);
            player.playSound(player.getLocation(), "entity.slime.jump", 1.0f, 1.0f);
        }
    }

    private boolean isLaunchBlock(Block block) {
        return block.getType() == Material.SLIME_BLOCK;
    }
}

