/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.morefoworld.command.sub;

import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.function.BiConsumer;
import me.hsgamer.morefoworld.MoreFoWorld;
import me.hsgamer.morefoworld.Permissions;
import me.hsgamer.morefoworld.command.sub.LinkWorldCommand;
import me.hsgamer.morefoworld.config.PortalConfig;
import me.hsgamer.morefoworld.core.bukkit.utils.MessageUtils;
import org.bukkit.World;
import org.bukkit.command.CommandSender;

public class LinkPortalCommand
extends LinkWorldCommand {
    private final MoreFoWorld plugin;

    public LinkPortalCommand(MoreFoWorld plugin) {
        super("linkportal", "Link portals between two worlds", 1, "<nether/end>", Permissions.LINK_PORTAL.getName());
        this.plugin = plugin;
    }

    @Override
    protected void onWorldCommand(CommandSender sender, World from, World to, String ... args) {
        BiConsumer<String, String> action;
        switch (args[0].toLowerCase(Locale.ROOT)) {
            case "nether": {
                action = this.plugin.get(PortalConfig.class)::linkNetherPortal;
                break;
            }
            case "end": {
                action = this.plugin.get(PortalConfig.class)::linkEndPortal;
                break;
            }
            default: {
                MessageUtils.sendMessage(sender, "&cInvalid type: &e" + args[0]);
                return;
            }
        }
        action.accept(from.getName(), to.getName());
        MessageUtils.sendMessage(sender, "&aSuccessfully linked");
    }

    @Override
    protected List<String> onWorldTabComplete(CommandSender sender, String ... args) {
        if (args.length == 1) {
            return List.of("nether", "end");
        }
        return Collections.emptyList();
    }
}

