/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.morefoworld.config.converter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import me.hsgamer.morefoworld.WorldSetting;
import me.hsgamer.morefoworld.core.config.annotation.converter.Converter;

public class WorldSettingListConverter
implements Converter {
    @Override
    public List<WorldSetting> convert(Object raw) {
        if (raw instanceof Map) {
            Map worldMap = (Map)raw;
            ArrayList<WorldSetting> worldSettings = new ArrayList<WorldSetting>();
            for (Map.Entry entry : worldMap.entrySet()) {
                Object v;
                String worldName = Objects.toString(entry.getKey(), null);
                if (worldName == null || !((v = entry.getValue()) instanceof Map)) continue;
                Map settingMap = (Map)v;
                HashMap<String, Object> mappedSettingMap = new HashMap<String, Object>();
                settingMap.forEach((key, value) -> {
                    String keyString = Objects.toString(key, null);
                    if (keyString == null) {
                        return;
                    }
                    mappedSettingMap.put(keyString, value);
                });
                worldSettings.add(WorldSetting.fromMap(worldName, mappedSettingMap));
            }
            return worldSettings;
        }
        return null;
    }

    @Override
    public Map<String, Map<String, Object>> convertToRaw(Object value) {
        if (value instanceof List) {
            List list = (List)value;
            HashMap<String, Map<String, Object>> rawMap = new HashMap<String, Map<String, Object>>();
            for (Object object : list) {
                if (!(object instanceof WorldSetting)) continue;
                WorldSetting worldSetting = (WorldSetting)object;
                rawMap.put(worldSetting.getName(), worldSetting.toMap());
            }
            return rawMap;
        }
        return null;
    }
}

