/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.morefoworld.config.object;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import me.hsgamer.morefoworld.config.object.Position;
import org.bukkit.Bukkit;
import org.bukkit.Location;

public record WorldPosition(String world, Position position) {
    public static WorldPosition deserialize(Map<String, Object> map) {
        return new WorldPosition(Optional.ofNullable(map.get("world")).map(Object::toString).orElse(""), Position.deserialize(map));
    }

    public static WorldPosition fromLocation(Location location) {
        return new WorldPosition(location.getWorld().getName(), Position.fromLocation(location));
    }

    public Location toLocation() {
        return this.position.toLocation(Bukkit.getWorld((String)this.world));
    }

    public Map<String, Object> serialize() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("world", this.world);
        map.putAll(this.position.serialize());
        return map;
    }
}

